/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.Rounding;
import org.decimal4j.truncate.DecimalRounding;

final class Invert {
    public static final long invertLong(long lValue) {
        if (lValue == 0L) {
            throw new ArithmeticException("Division by zero: " + lValue + "^-1");
        }
        if (lValue == 1L) {
            return 1L;
        }
        if (lValue == -1L) {
            return -1L;
        }
        return 0L;
    }

    public static final long invertLong(DecimalRounding rounding, long lValue) {
        if (lValue == 0L) {
            throw new ArithmeticException("Division by zero: " + lValue + "^-1");
        }
        if (lValue == 1L) {
            return 1L;
        }
        if (lValue == -1L) {
            return -1L;
        }
        return Rounding.calculateRoundingIncrementForDivision(rounding, 0L, 1L, lValue);
    }

    public static final long invert(DecimalArithmetic arith, long uDecimal) {
        return arith.divide(arith.one(), uDecimal);
    }

    public static final long invert(DecimalArithmetic arith, DecimalRounding rounding, long uDecimal) {
        return arith.divide(arith.one(), uDecimal);
    }

    private Invert() {
    }
}

