/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.arithmetic.Rounding;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.truncate.DecimalRounding;

final class LongConversion {
    public static final long longToUnscaledUnchecked(ScaleMetrics scaleMetrics, long value) {
        return scaleMetrics.multiplyByScaleFactor(value);
    }

    public static final long longToUnscaled(ScaleMetrics scaleMetrics, long value) {
        if (scaleMetrics.isValidIntegerValue(value)) {
            return scaleMetrics.multiplyByScaleFactor(value);
        }
        throw new IllegalArgumentException("Overflow: cannot convert " + value + " to Decimal with scale " + scaleMetrics.getScale());
    }

    public static final long unscaledToLong(ScaleMetrics scaleMetrics, long uDecimal) {
        return scaleMetrics.divideByScaleFactor(uDecimal);
    }

    public static final long unscaledToLong(ScaleMetrics scaleMetrics, DecimalRounding rounding, long uDecimal) {
        long truncated = scaleMetrics.divideByScaleFactor(uDecimal);
        long remainder = uDecimal - scaleMetrics.multiplyByScaleFactor(truncated);
        return truncated + (long)Rounding.calculateRoundingIncrement(rounding, truncated, remainder, scaleMetrics.getScaleFactor());
    }

    private LongConversion() {
    }
}

