/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.Checked;
import org.decimal4j.arithmetic.Exceptions;
import org.decimal4j.arithmetic.Pow10;
import org.decimal4j.arithmetic.Rounding;
import org.decimal4j.arithmetic.SpecialMultiplicationResult;
import org.decimal4j.scale.Scale9f;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.scale.Scales;
import org.decimal4j.truncate.DecimalRounding;

final class Mul {
    private static final ScaleMetrics SCALE9F = Scale9f.INSTANCE;

    private static final boolean doesProductFitInLong(long uDecimal1, long uDecimal2) {
        return -3037000499L <= uDecimal1 & uDecimal1 <= 3037000499L & -3037000499L <= uDecimal2 & uDecimal2 <= 3037000499L;
    }

    public static final long multiply(DecimalArithmetic arith, long uDecimal1, long uDecimal2) {
        SpecialMultiplicationResult special = SpecialMultiplicationResult.getFor(arith, uDecimal1, uDecimal2);
        if (special != null) {
            return special.multiply(arith, uDecimal1, uDecimal2);
        }
        return Mul.multiply(uDecimal1, arith.getScaleMetrics(), uDecimal2);
    }

    public static final long multiplyByUnscaled(long uDecimal, long unscaled, int scale) {
        if (scale > 18) {
            throw new IllegalArgumentException("Illegal scale, must be <=18 but was " + scale);
        }
        if (uDecimal == 0L | unscaled == 0L) {
            return 0L;
        }
        if (scale == 0) {
            return uDecimal * unscaled;
        }
        if (scale < 0) {
            return Pow10.divideByPowerOf10(uDecimal * unscaled, scale);
        }
        ScaleMetrics scaleMetrics = Scales.getScaleMetrics(scale);
        return Mul.multiply(uDecimal, scaleMetrics, unscaled);
    }

    private static final long multiply(long uDecimal1, ScaleMetrics scaleMetrics2, long uDecimal2) {
        if (Mul.doesProductFitInLong(uDecimal1, uDecimal2)) {
            return scaleMetrics2.divideByScaleFactor(uDecimal1 * uDecimal2);
        }
        int scale = scaleMetrics2.getScale();
        if (scale <= 9) {
            long i1 = scaleMetrics2.divideByScaleFactor(uDecimal1);
            long i2 = scaleMetrics2.divideByScaleFactor(uDecimal2);
            long f1 = uDecimal1 - scaleMetrics2.multiplyByScaleFactor(i1);
            long f2 = uDecimal2 - scaleMetrics2.multiplyByScaleFactor(i2);
            return uDecimal1 * i2 + i1 * f2 + scaleMetrics2.divideByScaleFactor(f1 * f2);
        }
        ScaleMetrics scaleDiff09 = Scales.getScaleMetrics(scale - 9);
        ScaleMetrics scaleDiff18 = Scales.getScaleMetrics(18 - scale);
        long h1 = SCALE9F.divideByScaleFactor(uDecimal1);
        long h2 = SCALE9F.divideByScaleFactor(uDecimal2);
        long l1 = uDecimal1 - SCALE9F.multiplyByScaleFactor(h1);
        long l2 = uDecimal2 - SCALE9F.multiplyByScaleFactor(h2);
        long h1xl2 = h1 * l2;
        long h2xl1 = h2 * l1;
        long l1xl2d = SCALE9F.divideByScaleFactor(l1 * l2);
        long h1xl2d = scaleDiff09.divideByScaleFactor(h1xl2);
        long h2xl1d = scaleDiff09.divideByScaleFactor(h2xl1);
        long h1xl2r = h1xl2 - scaleDiff09.multiplyByScaleFactor(h1xl2d);
        long h2xl1r = h2xl1 - scaleDiff09.multiplyByScaleFactor(h2xl1d);
        return scaleDiff18.multiplyByScaleFactor(h1 * h2) + h1xl2d + h2xl1d + scaleDiff09.divideByScaleFactor(h1xl2r + h2xl1r + l1xl2d);
    }

    public static final long multiply(DecimalArithmetic arith, DecimalRounding rounding, long uDecimal1, long uDecimal2) {
        SpecialMultiplicationResult special = SpecialMultiplicationResult.getFor(arith, uDecimal1, uDecimal2);
        if (special != null) {
            return special.multiply(arith, uDecimal1, uDecimal2);
        }
        return Mul.multiply(rounding, uDecimal1, arith.getScaleMetrics(), uDecimal2);
    }

    public static final long multiplyByUnscaled(DecimalRounding rounding, long uDecimal, long unscaled, int scale) {
        if (scale > 18) {
            throw new IllegalArgumentException("Illegal scale, must be <=18 but was " + scale);
        }
        if (uDecimal == 0L | unscaled == 0L) {
            return 0L;
        }
        if (scale == 0) {
            return uDecimal * unscaled;
        }
        if (scale < 0) {
            return Pow10.divideByPowerOf10(rounding, uDecimal * unscaled, scale);
        }
        ScaleMetrics scaleMetrics = Scales.getScaleMetrics(scale);
        return Mul.multiply(rounding, uDecimal, scaleMetrics, unscaled);
    }

    private static final long multiply(DecimalRounding rounding, long uDecimal1, ScaleMetrics scaleMetrics2, long uDecimal2) {
        if (Mul.doesProductFitInLong(uDecimal1, uDecimal2)) {
            return Mul.multiply32(rounding, uDecimal1, scaleMetrics2, uDecimal2);
        }
        int scale = scaleMetrics2.getScale();
        if (scale <= 9) {
            long i1 = scaleMetrics2.divideByScaleFactor(uDecimal1);
            long i2 = scaleMetrics2.divideByScaleFactor(uDecimal2);
            long f1 = uDecimal1 - scaleMetrics2.multiplyByScaleFactor(i1);
            long f2 = uDecimal2 - scaleMetrics2.multiplyByScaleFactor(i2);
            long f1xf2 = f1 * f2;
            long f1xf2d = scaleMetrics2.divideByScaleFactor(f1xf2);
            long f1xf2r = f1xf2 - scaleMetrics2.multiplyByScaleFactor(f1xf2d);
            long unrounded = uDecimal1 * i2 + i1 * f2 + f1xf2d;
            return unrounded + (long)Rounding.calculateRoundingIncrement(rounding, unrounded, f1xf2r, scaleMetrics2.getScaleFactor());
        }
        ScaleMetrics scaleDiff09 = Scales.getScaleMetrics(scale - 9);
        ScaleMetrics scaleDiff18 = Scales.getScaleMetrics(18 - scale);
        long h1 = SCALE9F.divideByScaleFactor(uDecimal1);
        long h2 = SCALE9F.divideByScaleFactor(uDecimal2);
        long l1 = uDecimal1 - SCALE9F.multiplyByScaleFactor(h1);
        long l2 = uDecimal2 - SCALE9F.multiplyByScaleFactor(h2);
        long h1xl2 = h1 * l2;
        long h2xl1 = h2 * l1;
        long l1xl2 = l1 * l2;
        long l1xl2d = SCALE9F.divideByScaleFactor(l1xl2);
        long h1xl2d = scaleDiff09.divideByScaleFactor(h1xl2);
        long h2xl1d = scaleDiff09.divideByScaleFactor(h2xl1);
        long h1xl2r = h1xl2 - scaleDiff09.multiplyByScaleFactor(h1xl2d);
        long h2xl1r = h2xl1 - scaleDiff09.multiplyByScaleFactor(h2xl1d);
        long l1xl2r = l1xl2 - SCALE9F.multiplyByScaleFactor(l1xl2d);
        long h1xl2_h2xl1_l1xl1 = h1xl2r + h2xl1r + l1xl2d;
        long h1xl2_h2xl1_l1xl1d = scaleDiff09.divideByScaleFactor(h1xl2_h2xl1_l1xl1);
        long h1xl2_h2xl1_l1xl1r = h1xl2_h2xl1_l1xl1 - scaleDiff09.multiplyByScaleFactor(h1xl2_h2xl1_l1xl1d);
        long unrounded = scaleDiff18.multiplyByScaleFactor(h1 * h2) + h1xl2d + h2xl1d + h1xl2_h2xl1_l1xl1d;
        long remainder = SCALE9F.multiplyByScaleFactor(h1xl2_h2xl1_l1xl1r) + l1xl2r;
        return unrounded + (long)Rounding.calculateRoundingIncrement(rounding, unrounded, remainder, scaleMetrics2.getScaleFactor());
    }

    private static final long multiply32(DecimalRounding rounding, long uDecimal1, ScaleMetrics scaleMetrics2, long uDecimal2) {
        long u1xu2 = uDecimal1 * uDecimal2;
        long u1xu2d = scaleMetrics2.divideByScaleFactor(u1xu2);
        long u1xu2r = u1xu2 - scaleMetrics2.multiplyByScaleFactor(u1xu2d);
        return u1xu2d + (long)Rounding.calculateRoundingIncrement(rounding, u1xu2d, u1xu2r, scaleMetrics2.getScaleFactor());
    }

    public static final long multiplyChecked(DecimalArithmetic arith, long uDecimal1, long uDecimal2) {
        SpecialMultiplicationResult special = SpecialMultiplicationResult.getFor(arith, uDecimal1, uDecimal2);
        if (special != null) {
            return special.multiply(arith, uDecimal1, uDecimal2);
        }
        ScaleMetrics scaleMetrics = arith.getScaleMetrics();
        return Mul.multiplyChecked(scaleMetrics, uDecimal1, scaleMetrics, uDecimal2);
    }

    public static final long multiplyByUnscaledChecked(DecimalArithmetic arith, long uDecimal, long unscaled, int scale) {
        if (scale > 18) {
            throw new IllegalArgumentException("Illegal scale, must be <=18 but was " + scale);
        }
        if (uDecimal == 0L | unscaled == 0L) {
            return 0L;
        }
        if (scale == 0) {
            return arith.multiplyByLong(uDecimal, unscaled);
        }
        if (scale < 0) {
            long unscaledResult = Checked.multiplyLong(uDecimal, unscaled);
            return Pow10.divideByPowerOf10Checked(arith, unscaledResult, scale);
        }
        ScaleMetrics scaleMetrics = Scales.getScaleMetrics(scale);
        return Mul.multiplyChecked(arith.getScaleMetrics(), uDecimal, scaleMetrics, unscaled);
    }

    private static final long multiplyChecked(ScaleMetrics scaleMetrics1, long uDecimal1, ScaleMetrics scaleMetrics2, long uDecimal2) {
        try {
            if (Mul.doesProductFitInLong(uDecimal1, uDecimal2)) {
                return scaleMetrics2.divideByScaleFactor(uDecimal1 * uDecimal2);
            }
            int scale = scaleMetrics2.getScale();
            if (scale <= 9) {
                long i1 = scaleMetrics2.divideByScaleFactor(uDecimal1);
                long i2 = scaleMetrics2.divideByScaleFactor(uDecimal2);
                long f1 = uDecimal1 - scaleMetrics2.multiplyByScaleFactor(i1);
                long f2 = uDecimal2 - scaleMetrics2.multiplyByScaleFactor(i2);
                long i1xf2 = i1 * f2;
                long f1xf2 = scaleMetrics2.divideByScaleFactor(f1 * f2);
                long result = Checked.multiplyLong(uDecimal1, i2);
                result = Checked.addLong(result, i1xf2);
                result = Checked.addLong(result, f1xf2);
                return result;
            }
            ScaleMetrics scaleDiff09 = Scales.getScaleMetrics(scale - 9);
            ScaleMetrics scaleDiff18 = Scales.getScaleMetrics(18 - scale);
            long h1 = SCALE9F.divideByScaleFactor(uDecimal1);
            long h2 = SCALE9F.divideByScaleFactor(uDecimal2);
            long l1 = uDecimal1 - SCALE9F.multiplyByScaleFactor(h1);
            long l2 = uDecimal2 - SCALE9F.multiplyByScaleFactor(h2);
            long h1xh2 = Checked.multiplyLong(h1, h2);
            long h1xl2 = h1 * l2;
            long h2xl1 = h2 * l1;
            long l1xl2d = SCALE9F.divideByScaleFactor(l1 * l2);
            long h1xl2d = scaleDiff09.divideByScaleFactor(h1xl2);
            long h2xl1d = scaleDiff09.divideByScaleFactor(h2xl1);
            long h1xl2r = h1xl2 - scaleDiff09.multiplyByScaleFactor(h1xl2d);
            long h2xl1r = h2xl1 - scaleDiff09.multiplyByScaleFactor(h2xl1d);
            long result = scaleDiff18.multiplyByScaleFactorExact(h1xh2);
            result = Checked.addLong(result, h1xl2d);
            result = Checked.addLong(result, h2xl1d);
            result = Checked.addLong(result, scaleDiff09.divideByScaleFactor(h1xl2r + h2xl1r + l1xl2d));
            return result;
        }
        catch (ArithmeticException e) {
            throw Exceptions.newArithmeticExceptionWithCause("Overflow: " + scaleMetrics1.toString(uDecimal1) + " * " + scaleMetrics2.toString(uDecimal2), e);
        }
    }

    public static final long multiplyChecked(DecimalArithmetic arith, DecimalRounding rounding, long uDecimal1, long uDecimal2) {
        SpecialMultiplicationResult special = SpecialMultiplicationResult.getFor(arith, uDecimal1, uDecimal2);
        if (special != null) {
            return special.multiply(arith, uDecimal1, uDecimal2);
        }
        ScaleMetrics scaleMetrics = arith.getScaleMetrics();
        return Mul.multiplyChecked(rounding, scaleMetrics, uDecimal1, scaleMetrics, uDecimal2);
    }

    public static final long multiplyByUnscaledChecked(DecimalArithmetic arith, DecimalRounding rounding, long uDecimal, long unscaled, int scale) {
        if (scale > 18) {
            throw new IllegalArgumentException("Illegal scale, must be <=18 but was " + scale);
        }
        if (uDecimal == 0L | unscaled == 0L) {
            return 0L;
        }
        if (scale == 0) {
            return arith.multiplyByLong(uDecimal, unscaled);
        }
        if (scale < 0) {
            long unscaledResult = Checked.multiplyLong(uDecimal, unscaled);
            return Pow10.divideByPowerOf10Checked(arith, rounding, unscaledResult, scale);
        }
        ScaleMetrics scaleMetrics2 = Scales.getScaleMetrics(scale);
        return Mul.multiplyChecked(rounding, arith.getScaleMetrics(), uDecimal, scaleMetrics2, unscaled);
    }

    private static final long multiplyChecked(DecimalRounding rounding, ScaleMetrics scaleMetrics1, long uDecimal1, ScaleMetrics scaleMetrics2, long uDecimal2) {
        try {
            if (Mul.doesProductFitInLong(uDecimal1, uDecimal2)) {
                return Mul.multiply32(rounding, uDecimal1, scaleMetrics2, uDecimal2);
            }
            int scale = scaleMetrics2.getScale();
            if (scale <= 9) {
                long i1 = scaleMetrics2.divideByScaleFactor(uDecimal1);
                long i2 = scaleMetrics2.divideByScaleFactor(uDecimal2);
                long f1 = uDecimal1 - scaleMetrics2.multiplyByScaleFactor(i1);
                long f2 = uDecimal2 - scaleMetrics2.multiplyByScaleFactor(i2);
                long i1xf2 = i1 * f2;
                long f1xf2 = f1 * f2;
                long f1xf2d = scaleMetrics2.divideByScaleFactor(f1xf2);
                long f1xf2r = f1xf2 - scaleMetrics2.multiplyByScaleFactor(f1xf2d);
                long result = Checked.multiplyLong(uDecimal1, i2);
                result = Checked.addLong(result, i1xf2);
                result = Checked.addLong(result, f1xf2d);
                return result + (long)Rounding.calculateRoundingIncrement(rounding, result, f1xf2r, scaleMetrics2.getScaleFactor());
            }
            ScaleMetrics scaleDiff09 = Scales.getScaleMetrics(scale - 9);
            ScaleMetrics scaleDiff18 = Scales.getScaleMetrics(18 - scale);
            long h1 = SCALE9F.divideByScaleFactor(uDecimal1);
            long h2 = SCALE9F.divideByScaleFactor(uDecimal2);
            long l1 = uDecimal1 - SCALE9F.multiplyByScaleFactor(h1);
            long l2 = uDecimal2 - SCALE9F.multiplyByScaleFactor(h2);
            long h1xl2 = h1 * l2;
            long h2xl1 = h2 * l1;
            long l1xl2 = l1 * l2;
            long l1xl2d = SCALE9F.divideByScaleFactor(l1xl2);
            long h1xl2d = scaleDiff09.divideByScaleFactor(h1xl2);
            long h2xl1d = scaleDiff09.divideByScaleFactor(h2xl1);
            long h1xl2r = h1xl2 - scaleDiff09.multiplyByScaleFactor(h1xl2d);
            long h2xl1r = h2xl1 - scaleDiff09.multiplyByScaleFactor(h2xl1d);
            long l1xl2r = l1xl2 - SCALE9F.multiplyByScaleFactor(l1xl2d);
            long h1xl2_h2xl1_l1xl1 = h1xl2r + h2xl1r + l1xl2d;
            long h1xl2_h2xl1_l1xl1d = scaleDiff09.divideByScaleFactor(h1xl2_h2xl1_l1xl1);
            long h1xl2_h2xl1_l1xl1r = h1xl2_h2xl1_l1xl1 - scaleDiff09.multiplyByScaleFactorExact(h1xl2_h2xl1_l1xl1d);
            long h1xh2 = Checked.multiplyLong(h1, h2);
            long result = scaleDiff18.multiplyByScaleFactorExact(h1xh2);
            result = Checked.addLong(result, h1xl2d);
            result = Checked.addLong(result, h2xl1d);
            result = Checked.addLong(result, scaleDiff09.divideByScaleFactor(h1xl2r + h2xl1r + l1xl2d));
            long remainder = SCALE9F.multiplyByScaleFactor(h1xl2_h2xl1_l1xl1r) + l1xl2r;
            return Checked.addLong(result, Rounding.calculateRoundingIncrement(rounding, result, remainder, scaleMetrics2.getScaleFactor()));
        }
        catch (ArithmeticException e) {
            Exceptions.rethrowIfRoundingNecessary(e);
            throw Exceptions.newArithmeticExceptionWithCause("Overflow: " + scaleMetrics1.toString(uDecimal1) + " * " + scaleMetrics2.toString(uDecimal2), e);
        }
    }

    private Mul() {
    }
}

