/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.Rounding;
import org.decimal4j.truncate.DecimalRounding;
import org.decimal4j.truncate.TruncatedPart;

final class Shift {
    public static final long shiftLeft(DecimalRounding rounding, long uDecimal, int positions) {
        if (positions >= 0) {
            return positions < 64 ? uDecimal << positions : 0L;
        }
        return Shift.shiftRight(rounding, uDecimal, -positions > 0 ? -positions : Integer.MAX_VALUE);
    }

    public static final long shiftRight(DecimalRounding rounding, long uDecimal, int positions) {
        if (uDecimal == 0L | positions == 0) {
            return uDecimal;
        }
        if (positions >= 0) {
            if (rounding == DecimalRounding.FLOOR) {
                return positions < 64 ? uDecimal >> positions : (long)(uDecimal >= 0L ? 0 : -1);
            }
            if (positions < 64) {
                long truncated = uDecimal >= 0L ? uDecimal >>> positions : -(-uDecimal >>> positions);
                long remainder = uDecimal - (truncated << positions);
                TruncatedPart truncatedPart = positions == 63 ? Rounding.truncatedPartFor2pow63(remainder) : Rounding.truncatedPartFor(Math.abs(remainder), 1L << positions);
                return truncated + (long)rounding.calculateRoundingIncrement(Long.signum(uDecimal), truncated, truncatedPart);
            }
            if (positions == 64) {
                return rounding.calculateRoundingIncrement(Long.signum(uDecimal), 0L, Rounding.truncatedPartFor2pow64(Math.abs(uDecimal)));
            }
            return rounding.calculateRoundingIncrement(Long.signum(uDecimal), 0L, TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO);
        }
        return positions > -64 ? uDecimal << -positions : 0L;
    }

    public static final long shiftLeftChecked(DecimalArithmetic arith, DecimalRounding rounding, long uDecimal, int positions) {
        if (positions >= 0) {
            int leadingZeros;
            if (uDecimal == 0L | positions == 0) {
                return uDecimal;
            }
            if (positions < 64 && (uDecimal > 0L ? positions < 63 && (leadingZeros = Long.numberOfLeadingZeros(uDecimal)) > positions : uDecimal > Long.MIN_VALUE && (leadingZeros = Long.numberOfLeadingZeros(uDecimal ^ 0xFFFFFFFFFFFFFFFFL)) > positions)) {
                return uDecimal << positions;
            }
            throw new ArithmeticException("Overflow: " + arith.toString(uDecimal) + " << " + positions + " = " + arith.toString(uDecimal << positions));
        }
        return Shift.shiftRight(rounding, uDecimal, -positions > 0 ? -positions : Integer.MAX_VALUE);
    }

    public static final long shiftRightChecked(DecimalArithmetic arith, DecimalRounding rounding, long uDecimal, int positions) {
        if (uDecimal == 0L) {
            return 0L;
        }
        if (positions >= 0) {
            return Shift.shiftRight(rounding, uDecimal, positions);
        }
        if (positions > -64) {
            try {
                return Shift.shiftLeftChecked(arith, rounding, uDecimal, -positions);
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        throw new ArithmeticException("Overflow: " + arith.toString(uDecimal) + " >> " + positions + " = " + arith.toString(uDecimal >> positions));
    }

    private Shift() {
    }
}

