/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;

enum SpecialMultiplicationResult {
    FACTOR_IS_ZERO{

        @Override
        final long multiply(DecimalArithmetic arithmetic, long uDecimal1, long uDecimal2) {
            return 0L;
        }
    }
    ,
    FACTOR_1_IS_ONE{

        @Override
        final long multiply(DecimalArithmetic arithmetic, long uDecimal1, long uDecimal2) {
            return uDecimal2;
        }
    }
    ,
    FACTOR_2_IS_ONE{

        @Override
        final long multiply(DecimalArithmetic arithmetic, long uDecimal1, long uDecimal2) {
            return uDecimal1;
        }
    }
    ,
    FACTOR_1_IS_MINUS_ONE{

        @Override
        final long multiply(DecimalArithmetic arithmetic, long uDecimal1, long uDecimal2) {
            return arithmetic.negate(uDecimal2);
        }
    }
    ,
    FACTOR_2_IS_MINUS_ONE{

        @Override
        final long multiply(DecimalArithmetic arithmetic, long uDecimal1, long uDecimal2) {
            return arithmetic.negate(uDecimal1);
        }
    }
    ,
    FACTORS_ARE_EQUAL{

        @Override
        final long multiply(DecimalArithmetic arithmetic, long uDecimal1, long uDecimal2) {
            return arithmetic.square(uDecimal1);
        }
    };


    abstract long multiply(DecimalArithmetic var1, long var2, long var4);

    static final SpecialMultiplicationResult getFor(DecimalArithmetic arithmetic, long uDecimal1, long uDecimal2) {
        if (uDecimal1 == 0L | uDecimal2 == 0L) {
            return FACTOR_IS_ZERO;
        }
        long one = arithmetic.one();
        if (uDecimal1 == one) {
            return FACTOR_1_IS_ONE;
        }
        if (uDecimal2 == one) {
            return FACTOR_2_IS_ONE;
        }
        if (uDecimal1 == -one) {
            return FACTOR_1_IS_MINUS_ONE;
        }
        if (uDecimal2 == -one) {
            return FACTOR_2_IS_MINUS_ONE;
        }
        if (uDecimal1 == uDecimal2) {
            return FACTORS_ARE_EQUAL;
        }
        return null;
    }
}

