/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;

enum SpecialPowResult {
    EXPONENT_IS_ZERO{

        @Override
        final long pow(DecimalArithmetic arithmetic, long uDecimal, int exponent) {
            return arithmetic.one();
        }
    }
    ,
    EXPONENT_IS_ONE{

        @Override
        final long pow(DecimalArithmetic arithmetic, long uDecimal, int exponent) {
            return uDecimal;
        }
    }
    ,
    BASE_IS_ZERO{

        @Override
        final long pow(DecimalArithmetic arithmetic, long uDecimal, int exponent) {
            if (exponent >= 0) {
                return 0L;
            }
            throw new ArithmeticException("Division by zero: " + arithmetic.toString(uDecimal) + "^" + exponent);
        }
    }
    ,
    BASE_IS_ONE{

        @Override
        final long pow(DecimalArithmetic arithmetic, long uDecimal, int exponent) {
            return uDecimal;
        }
    }
    ,
    BASE_IS_MINUS_ONE{

        @Override
        final long pow(DecimalArithmetic arithmetic, long uDecimal, int exponent) {
            return (exponent & 1) == 0 ? -uDecimal : uDecimal;
        }
    }
    ,
    EXPONENT_IS_MINUS_ONE{

        @Override
        final long pow(DecimalArithmetic arithmetic, long uDecimal, int exponent) {
            return arithmetic.invert(uDecimal);
        }
    }
    ,
    EXPONENT_IS_TWO{

        @Override
        final long pow(DecimalArithmetic arithmetic, long uDecimal, int exponent) {
            return arithmetic.square(uDecimal);
        }
    };


    abstract long pow(DecimalArithmetic var1, long var2, int var4);

    static final SpecialPowResult getFor(DecimalArithmetic arithmetic, long uDecimal, long n) {
        if (n == 0L) {
            return EXPONENT_IS_ZERO;
        }
        if (n == 1L) {
            return EXPONENT_IS_ONE;
        }
        if (uDecimal == 0L) {
            return BASE_IS_ZERO;
        }
        long one = arithmetic.one();
        if (uDecimal == one) {
            return BASE_IS_ONE;
        }
        if (uDecimal == -one) {
            return BASE_IS_MINUS_ONE;
        }
        if (n == -1L) {
            return EXPONENT_IS_MINUS_ONE;
        }
        if (n == 2L) {
            return EXPONENT_IS_TWO;
        }
        return null;
    }
}

