/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.Unsigned;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.truncate.DecimalRounding;
import org.decimal4j.truncate.TruncatedPart;

final class Sqrt {
    private static final long LONG_MASK = 0xFFFFFFFFL;

    public static final long sqrtLong(long lValue) {
        if (lValue < 0L) {
            throw new ArithmeticException("Square root of a negative value: " + lValue);
        }
        if ((lValue & 0xFFF0000000000000L) == 0L) {
            return (long)StrictMath.sqrt(lValue);
        }
        long result = (long)StrictMath.sqrt(2.0 * (double)(lValue >>> 1));
        return result * result - lValue > 0L ? result - 1L : result;
    }

    public static final long sqrtLong(DecimalRounding rounding, long lValue) {
        if (lValue < 0L) {
            throw new ArithmeticException("Square root of a negative value: " + lValue);
        }
        long rem = 0L;
        long root = 0L;
        int zerosHalf = Long.numberOfLeadingZeros(lValue) >> 1;
        long scaled = lValue << (zerosHalf << 1);
        for (int i = zerosHalf; i < 32; ++i) {
            root <<= 1;
            rem = (rem << 2) + (scaled >>> 62);
            scaled <<= 2;
            if (++root <= rem) {
                rem -= root;
                ++root;
                continue;
            }
            --root;
        }
        long truncated = root >>> 1;
        if (rem == 0L | rounding == DecimalRounding.DOWN | rounding == DecimalRounding.FLOOR) {
            return truncated;
        }
        return truncated + (long)Sqrt.getRoundingIncrement(rounding, truncated, rem);
    }

    public static final long sqrt(DecimalArithmetic arith, long uDecimal) {
        return Sqrt.sqrt(arith, DecimalRounding.DOWN, uDecimal);
    }

    public static final long sqrt(DecimalArithmetic arith, DecimalRounding rounding, long uDecimal) {
        int i;
        if (uDecimal < 0L) {
            throw new ArithmeticException("Square root of a negative value: " + arith.toString(uDecimal));
        }
        ScaleMetrics scaleMetrics = arith.getScaleMetrics();
        int lFactor = (int)(uDecimal & 0xFFFFFFFFL);
        int hFactor = (int)(uDecimal >>> 32);
        long product = scaleMetrics.mulloByScaleFactor(lFactor);
        long lScaled = product & 0xFFFFFFFFL;
        product = scaleMetrics.mulhiByScaleFactor(lFactor) + (product >>> 32);
        long hScaled = product >>> 32;
        product = scaleMetrics.mulloByScaleFactor(hFactor) + (product & 0xFFFFFFFFL);
        lScaled |= (product & 0xFFFFFFFFL) << 32;
        hScaled = scaleMetrics.mulhiByScaleFactor(hFactor) + hScaled + (product >>> 32);
        long rem = 0L;
        long root = 0L;
        int zerosHalf = Long.numberOfLeadingZeros(hScaled) >> 1;
        hScaled <<= zerosHalf << 1;
        for (i = zerosHalf; i < 32; ++i) {
            root <<= 1;
            rem = (rem << 2) + (hScaled >>> 62);
            hScaled <<= 2;
            if (++root <= rem) {
                rem -= root;
                ++root;
                continue;
            }
            --root;
        }
        zerosHalf = zerosHalf == 32 ? Long.numberOfLeadingZeros(lScaled) >> 1 : 0;
        lScaled <<= zerosHalf << 1;
        for (i = zerosHalf; i < 31; ++i) {
            root <<= 1;
            rem = (rem << 2) + (lScaled >>> 62);
            lScaled <<= 2;
            if (++root <= rem) {
                rem -= root;
                ++root;
                continue;
            }
            --root;
        }
        root <<= 1;
        rem = (rem << 2) + (lScaled >>> 62);
        lScaled <<= 2;
        if (Unsigned.isLessOrEqual(++root, rem)) {
            rem -= root;
            ++root;
        } else {
            --root;
        }
        long truncated = root >>> 1;
        if (rem == 0L | rounding == DecimalRounding.DOWN | rounding == DecimalRounding.FLOOR) {
            return truncated;
        }
        return truncated + (long)Sqrt.getRoundingIncrement(rounding, truncated, rem);
    }

    private static final int getRoundingIncrement(DecimalRounding rounding, long truncated, long rem) {
        if (truncated < rem) {
            return rounding.calculateRoundingIncrement(1, truncated, TruncatedPart.GREATER_THAN_HALF);
        }
        return rounding.calculateRoundingIncrement(1, truncated, TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO);
    }

    private Sqrt() {
    }
}

