/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.Checked;
import org.decimal4j.arithmetic.Exceptions;
import org.decimal4j.arithmetic.Rounding;
import org.decimal4j.scale.Scale9f;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.scale.Scales;
import org.decimal4j.truncate.DecimalRounding;

final class Square {
    private static final Scale9f SCALE9F = Scale9f.INSTANCE;
    static final long SQRT_MAX_VALUE = 3037000499L;

    private static final boolean doesSquareFitInLong(long uDecimal) {
        return -3037000499L <= uDecimal & uDecimal <= 3037000499L;
    }

    public static final long square(ScaleMetrics scaleMetrics, long uDecimal) {
        if (Square.doesSquareFitInLong(uDecimal)) {
            return scaleMetrics.divideByScaleFactor(uDecimal * uDecimal);
        }
        int scale = scaleMetrics.getScale();
        if (scale <= 9) {
            long i = scaleMetrics.divideByScaleFactor(uDecimal);
            long f = uDecimal - scaleMetrics.multiplyByScaleFactor(i);
            return scaleMetrics.multiplyByScaleFactor(i * i) + (i * f << 1) + scaleMetrics.divideByScaleFactor(f * f);
        }
        ScaleMetrics scaleDiff09 = Scales.getScaleMetrics(scale - 9);
        ScaleMetrics scaleDiff18 = Scales.getScaleMetrics(18 - scale);
        long h = SCALE9F.divideByScaleFactor(uDecimal);
        long l = uDecimal - SCALE9F.multiplyByScaleFactor(h);
        long hxl = h * l;
        long lxld = SCALE9F.divideByScaleFactor(l * l);
        long hxld = scaleDiff09.divideByScaleFactor(hxl);
        long hxlr = hxl - scaleDiff09.multiplyByScaleFactor(hxld);
        return scaleDiff18.multiplyByScaleFactor(h * h) + (hxld << 1) + scaleDiff09.divideByScaleFactor((hxlr << 1) + lxld);
    }

    public static final long square(ScaleMetrics scaleMetrics, DecimalRounding rounding, long uDecimal) {
        if (Square.doesSquareFitInLong(uDecimal)) {
            return Square.square32(scaleMetrics, rounding, uDecimal);
        }
        int scale = scaleMetrics.getScale();
        if (scale <= 9) {
            long i = scaleMetrics.divideByScaleFactor(uDecimal);
            long f = uDecimal - scaleMetrics.multiplyByScaleFactor(i);
            long fxf = f * f;
            long fxfd = scaleMetrics.divideByScaleFactor(fxf);
            long fxfr = fxf - scaleMetrics.multiplyByScaleFactor(fxfd);
            long unrounded = scaleMetrics.multiplyByScaleFactor(i * i) + (i * f << 1) + fxfd;
            return unrounded + (long)Rounding.calculateRoundingIncrement(rounding, unrounded, fxfr, scaleMetrics.getScaleFactor());
        }
        ScaleMetrics scaleDiff09 = Scales.getScaleMetrics(scale - 9);
        ScaleMetrics scaleDiff18 = Scales.getScaleMetrics(18 - scale);
        long h = SCALE9F.divideByScaleFactor(uDecimal);
        long l = uDecimal - SCALE9F.multiplyByScaleFactor(h);
        long hxl = h * l;
        long lxl = l * l;
        long lxld = SCALE9F.divideByScaleFactor(lxl);
        long hxld = scaleDiff09.divideByScaleFactor(hxl);
        long hxlr = hxl - scaleDiff09.multiplyByScaleFactor(hxld);
        long lxlr = lxl - SCALE9F.multiplyByScaleFactor(lxld);
        long hxlx2_lxl = (hxlr << 1) + lxld;
        long hxlx2_lxld = scaleDiff09.divideByScaleFactor(hxlx2_lxl);
        long hxlx2_lxlr = hxlx2_lxl - scaleDiff09.multiplyByScaleFactor(hxlx2_lxld);
        long unrounded = scaleDiff18.multiplyByScaleFactor(h * h) + (hxld << 1) + hxlx2_lxld;
        long remainder = SCALE9F.multiplyByScaleFactor(hxlx2_lxlr) + lxlr;
        return unrounded + (long)Rounding.calculateRoundingIncrement(rounding, unrounded, remainder, scaleMetrics.getScaleFactor());
    }

    private static final long square32(ScaleMetrics scaleMetrics, DecimalRounding rounding, long uDecimal) {
        long u2 = uDecimal * uDecimal;
        long u2d = scaleMetrics.divideByScaleFactor(u2);
        long u2r = u2 - scaleMetrics.multiplyByScaleFactor(u2d);
        return u2d + (long)Rounding.calculateRoundingIncrement(rounding, u2d, u2r, scaleMetrics.getScaleFactor());
    }

    public static final long squareChecked(DecimalArithmetic arith, long uDecimal) {
        ScaleMetrics scaleMetrics = arith.getScaleMetrics();
        if (Square.doesSquareFitInLong(uDecimal)) {
            return scaleMetrics.divideByScaleFactor(uDecimal * uDecimal);
        }
        int scale = scaleMetrics.getScale();
        try {
            if (scale <= 9) {
                long i = scaleMetrics.divideByScaleFactor(uDecimal);
                long f = uDecimal - scaleMetrics.multiplyByScaleFactor(i);
                long ixi = Checked.multiplyLong(i, i);
                long ixf = i * f;
                long fxf = scaleMetrics.divideByScaleFactor(f * f);
                if (ixf < 0L) {
                    throw new ArithmeticException("Overflow: " + ixf + "<<1");
                }
                long ixfx2 = ixf << 1;
                long result = scaleMetrics.multiplyByScaleFactorExact(ixi);
                result = Checked.addLong(result, ixfx2);
                result = Checked.addLong(result, fxf);
                return result;
            }
            ScaleMetrics scaleDiff09 = Scales.getScaleMetrics(scale - 9);
            ScaleMetrics scaleDiff18 = Scales.getScaleMetrics(18 - scale);
            long h = SCALE9F.divideByScaleFactor(uDecimal);
            long l = uDecimal - SCALE9F.multiplyByScaleFactor(h);
            long hxh = Checked.multiplyLong(h, h);
            long hxl = h * l;
            long lxld = SCALE9F.divideByScaleFactor(l * l);
            long hxld = scaleDiff09.divideByScaleFactor(hxl);
            long hxlr = hxl - scaleDiff09.multiplyByScaleFactor(hxld);
            if (hxld < 0L) {
                throw new ArithmeticException("Overflow: " + hxld + "<<1");
            }
            long hxldx2 = hxld << 1;
            long result = scaleDiff18.multiplyByScaleFactorExact(hxh);
            result = Checked.addLong(result, hxldx2);
            result = Checked.addLong(result, scaleDiff09.divideByScaleFactor((hxlr << 1) + lxld));
            return result;
        }
        catch (ArithmeticException e) {
            throw Exceptions.newArithmeticExceptionWithCause("Overflow: " + arith.toString(uDecimal) + "^2", e);
        }
    }

    public static final long squareChecked(DecimalArithmetic arith, DecimalRounding rounding, long uDecimal) {
        ScaleMetrics scaleMetrics = arith.getScaleMetrics();
        if (Square.doesSquareFitInLong(uDecimal)) {
            return Square.square32(scaleMetrics, rounding, uDecimal);
        }
        try {
            int scale = scaleMetrics.getScale();
            if (scale <= 9) {
                long i = scaleMetrics.divideByScaleFactor(uDecimal);
                long f = uDecimal - scaleMetrics.multiplyByScaleFactor(i);
                long ixi = Checked.multiplyLong(i, i);
                long fxf = f * f;
                long ixf = i * f;
                if (ixf < 0L) {
                    throw new ArithmeticException("Overflow: " + ixf + "<<1");
                }
                long ixfx2 = ixf << 1;
                long fxfd = scaleMetrics.divideByScaleFactor(fxf);
                long fxfr = fxf - scaleMetrics.multiplyByScaleFactor(fxfd);
                long unrounded = scaleMetrics.multiplyByScaleFactorExact(ixi);
                unrounded = Checked.addLong(unrounded, ixfx2);
                unrounded = Checked.addLong(unrounded, fxfd);
                return Checked.addLong(unrounded, Rounding.calculateRoundingIncrement(rounding, unrounded, fxfr, scaleMetrics.getScaleFactor()));
            }
            ScaleMetrics scaleDiff09 = Scales.getScaleMetrics(scale - 9);
            ScaleMetrics scaleDiff18 = Scales.getScaleMetrics(18 - scale);
            long h = SCALE9F.divideByScaleFactor(uDecimal);
            long l = uDecimal - SCALE9F.multiplyByScaleFactor(h);
            long hxh = Checked.multiplyLong(h, h);
            long hxl = h * l;
            long hxld = scaleDiff09.divideByScaleFactor(hxl);
            long hxlr = hxl - scaleDiff09.multiplyByScaleFactor(hxld);
            long hxldx2 = hxld << 1;
            long lxl = l * l;
            long lxld = SCALE9F.divideByScaleFactor(lxl);
            long lxlr = lxl - SCALE9F.multiplyByScaleFactor(lxld);
            long hxlx2_lxl = (hxlr << 1) + lxld;
            long hxlx2_lxld = scaleDiff09.divideByScaleFactor(hxlx2_lxl);
            long hxlx2_lxlr = hxlx2_lxl - scaleDiff09.multiplyByScaleFactor(hxlx2_lxld);
            long unrounded = scaleDiff18.multiplyByScaleFactorExact(hxh);
            unrounded = Checked.addLong(unrounded, hxldx2);
            unrounded = Checked.addLong(unrounded, hxlx2_lxld);
            long remainder = SCALE9F.multiplyByScaleFactor(hxlx2_lxlr) + lxlr;
            return Checked.addLong(unrounded, Rounding.calculateRoundingIncrement(rounding, unrounded, remainder, scaleMetrics.getScaleFactor()));
        }
        catch (ArithmeticException e) {
            Exceptions.rethrowIfRoundingNecessary(e);
            throw Exceptions.newArithmeticExceptionWithCause("Overflow: " + arith.toString(uDecimal) + "^2", e);
        }
    }

    private Square() {
    }
}

