/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.Checked;
import org.decimal4j.arithmetic.Exceptions;
import org.decimal4j.arithmetic.Pow10;
import org.decimal4j.arithmetic.Rounding;
import org.decimal4j.arithmetic.RoundingInverse;
import org.decimal4j.scale.Scale0f;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.scale.Scales;
import org.decimal4j.truncate.DecimalRounding;

final class Sub {
    public static final long subtractLongUnscaled(long lValue, long unscaled, int scale) {
        return Sub.subtractUnscaledUnscaled(Scale0f.INSTANCE, lValue, unscaled, scale);
    }

    public static final long subtractLongUnscaled(DecimalRounding rounding, long lValue, long unscaled, int scale) {
        return Sub.subtractUnscaledUnscaled(Scale0f.INSTANCE, rounding, lValue, unscaled, scale);
    }

    public static final long subtractUnscaledLong(DecimalArithmetic arith, long uDecimal, long lValue) {
        return uDecimal - Pow10.multiplyByPowerOf10(lValue, arith.getScale());
    }

    public static final long subtractUnscaledLongChecked(DecimalArithmetic arith, long uDecimal, long lValue) {
        int scale;
        if (lValue == 0L | (scale = arith.getScale()) == 0) {
            return arith.subtract(uDecimal, lValue);
        }
        try {
            return Sub.subtractForNegativeScaleDiff(arith, uDecimal, lValue, -scale);
        }
        catch (ArithmeticException e) {
            throw Exceptions.newArithmeticExceptionWithCause("Overflow: " + arith.toString(uDecimal) + " - " + lValue, e);
        }
    }

    public static final long subtractUnscaledUnscaled(ScaleMetrics scaleMetrics, long uDecimal, long unscaled, int scale) {
        int scaleDiff;
        if (scale > 18) {
            throw new IllegalArgumentException("Illegal scale, must be <=18 but was " + scale);
        }
        if (unscaled == 0L | (scaleDiff = scale - scaleMetrics.getScale()) == 0) {
            return uDecimal - unscaled;
        }
        if (scaleDiff < 0) {
            return uDecimal - Pow10.divideByPowerOf10(unscaled, scaleDiff);
        }
        return Sub.subtractForPositiveScaleDiff(uDecimal, unscaled, scaleDiff);
    }

    public static final long subtractUnscaledUnscaled(ScaleMetrics scaleMetrics, DecimalRounding rounding, long uDecimal, long unscaled, int scale) {
        int scaleDiff;
        if (scale > 18) {
            throw new IllegalArgumentException("Illegal scale, must be <=18 but was " + scale);
        }
        if (unscaled == 0L | (scaleDiff = scale - scaleMetrics.getScale()) == 0) {
            return uDecimal - unscaled;
        }
        if (scaleDiff < 0) {
            return uDecimal - Pow10.divideByPowerOf10(unscaled, scaleDiff);
        }
        return Sub.subtractForPositiveScaleDiff(rounding, uDecimal, unscaled, scaleDiff);
    }

    public static final long subtractUnscaledUnscaledChecked(DecimalArithmetic arith, long uDecimal, long unscaled, int scale) {
        int scaleDiff;
        if (scale > 18) {
            throw new IllegalArgumentException("Illegal scale, must be <=18 but was " + scale);
        }
        if (unscaled == 0L | (scaleDiff = scale - arith.getScale()) == 0) {
            return arith.subtract(uDecimal, unscaled);
        }
        if (scaleDiff < 0) {
            try {
                return Sub.subtractForNegativeScaleDiff(arith, uDecimal, unscaled, scaleDiff);
            }
            catch (ArithmeticException e) {
                throw Exceptions.newArithmeticExceptionWithCause("Overflow: " + arith.toString(uDecimal) + " - " + unscaled + "*10^" + -scale, e);
            }
        }
        long diff = Sub.subtractForPositiveScaleDiff(uDecimal, unscaled, scaleDiff);
        if (!Checked.isSubtractOverflow(uDecimal, unscaled, diff)) {
            return diff;
        }
        throw new ArithmeticException("Overflow: " + arith.toString(uDecimal) + " - " + unscaled + "*10^" + -scale + "=" + diff);
    }

    public static final long subtractUnscaledUnscaledChecked(DecimalArithmetic arith, DecimalRounding rounding, long uDecimal, long unscaled, int scale) {
        int scaleDiff;
        if (scale > 18) {
            throw new IllegalArgumentException("Illegal scale, must be <=18 but was " + scale);
        }
        if (unscaled == 0L | (scaleDiff = scale - arith.getScale()) == 0) {
            return arith.subtract(uDecimal, unscaled);
        }
        if (scaleDiff < 0) {
            try {
                return Sub.subtractForNegativeScaleDiff(arith, uDecimal, unscaled, scaleDiff);
            }
            catch (ArithmeticException e) {
                throw Exceptions.newArithmeticExceptionWithCause("Overflow: " + arith.toString(uDecimal) + " - " + unscaled + "*10^" + -scale, e);
            }
        }
        long diff = Sub.subtractForPositiveScaleDiff(rounding, uDecimal, unscaled, scaleDiff);
        if (!Checked.isSubtractOverflow(uDecimal, unscaled, diff)) {
            return diff;
        }
        throw new ArithmeticException("Overflow: " + arith.toString(uDecimal) + " - " + unscaled + "*10^" + -scale + "=" + diff);
    }

    private static final long subtractForPositiveScaleDiff(long uDecimal, long unscaled, int scaleDiff) {
        ScaleMetrics diffMetrics;
        long trunc;
        long diff;
        if (uDecimal == 0L | (diff = uDecimal - (trunc = (diffMetrics = Scales.getScaleMetrics(scaleDiff)).divideByScaleFactor(unscaled))) == 0L | (uDecimal ^ unscaled) < 0L | (diff ^ unscaled) < 0L) {
            return diff;
        }
        long remainder = unscaled - diffMetrics.multiplyByScaleFactor(trunc);
        return diff - (long)Long.signum(remainder);
    }

    private static final long subtractForPositiveScaleDiff(DecimalRounding rounding, long uDecimal, long unscaled, int scaleDiff) {
        long diff;
        ScaleMetrics diffMetrics = Scales.getScaleMetrics(scaleDiff);
        long trunc = diffMetrics.divideByScaleFactor(unscaled);
        long remainder = unscaled - diffMetrics.multiplyByScaleFactor(trunc);
        if (uDecimal == 0L | (diff = uDecimal - trunc) == 0L | (uDecimal ^ unscaled) < 0L | (diff ^ unscaled) < 0L) {
            return diff + (long)Rounding.calculateRoundingIncrement(rounding, diff, -remainder, diffMetrics.getScaleFactor());
        }
        return diff + (long)Rounding.calculateRoundingIncrement(RoundingInverse.ADDITIVE_REVERSION.invert(rounding), diff, -remainder, diffMetrics.getScaleFactor());
    }

    private static final long subtractForNegativeScaleDiff(DecimalArithmetic arith, long uDecimal, long unscaled, int scaleDiff) {
        long half = Pow10.divideByPowerOf10Checked(arith, unscaled / 2L, scaleDiff);
        long halfReminder = (unscaled & 1L) == 0L ? 0L : Pow10.divideByPowerOf10Checked(arith, unscaled > 0L ? 5L : -5L, scaleDiff + 1);
        long result = uDecimal;
        result = arith.subtract(result, half);
        result = arith.subtract(result, half);
        result = arith.subtract(result, halfReminder);
        result = arith.subtract(result, halfReminder);
        return result;
    }

    private Sub() {
    }
}

