/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import java.math.RoundingMode;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.Checked;
import org.decimal4j.arithmetic.Rounding;
import org.decimal4j.scale.Scale18f;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.scale.Scales;
import org.decimal4j.truncate.DecimalRounding;
import org.decimal4j.truncate.OverflowMode;
import org.decimal4j.truncate.TruncatedPart;

final class UnsignedDecimal9i36f {
    static final ThreadLocal<UnsignedDecimal9i36f> THREAD_LOCAL_1 = new ThreadLocal<UnsignedDecimal9i36f>(){

        @Override
        protected UnsignedDecimal9i36f initialValue() {
            return new UnsignedDecimal9i36f();
        }
    };
    static final ThreadLocal<UnsignedDecimal9i36f> THREAD_LOCAL_2 = new ThreadLocal<UnsignedDecimal9i36f>(){

        @Override
        protected UnsignedDecimal9i36f initialValue() {
            return new UnsignedDecimal9i36f();
        }
    };
    private Norm norm;
    private int pow10;
    private long ival;
    private long val3;
    private long val2;
    private long val1;
    private long val0;
    private static final long[] LONG_TEN_POWERS_TABLE = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    private UnsignedDecimal9i36f() {
    }

    public final UnsignedDecimal9i36f initOne() {
        this.norm = Norm.NORMALIZED_18;
        this.pow10 = 0;
        this.ival = 1L;
        this.val3 = 0L;
        this.val2 = 0L;
        this.val1 = 0L;
        this.val0 = 0L;
        return this;
    }

    public final UnsignedDecimal9i36f init(UnsignedDecimal9i36f copy) {
        this.norm = copy.norm;
        this.pow10 = copy.pow10;
        this.ival = copy.ival;
        this.val3 = copy.val3;
        this.val2 = copy.val2;
        this.val1 = copy.val1;
        this.val0 = copy.val0;
        return this;
    }

    public final UnsignedDecimal9i36f init(long ival, long fval, ScaleMetrics scaleMetrics) {
        ScaleMetrics diffMetrics = Scales.getScaleMetrics(18 - scaleMetrics.getScale());
        this.normalizeAndRound(1, 0, ival, diffMetrics.multiplyByScaleFactor(fval), 0L, 0L, 0L, DecimalRounding.UNNECESSARY);
        return this;
    }

    public final int getPow10() {
        return this.pow10;
    }

    private final void normalizeAndRound(int sgn, int pow10, long ival, long val3, long val2, long val1, long val0, DecimalRounding rounding) {
        while (ival == 0L) {
            ival = val3;
            val3 = val2;
            val2 = val1;
            val1 = val0;
            val0 = 0L;
            pow10 -= 18;
        }
        if (ival >= 1000000000L) {
            int log10 = UnsignedDecimal9i36f.log10(ival);
            int div10 = log10 - 9;
            ScaleMetrics divScale = Scales.getScaleMetrics(div10);
            ScaleMetrics mulScale = Scales.getScaleMetrics(18 - div10);
            long ivHi = divScale.divideByScaleFactor(ival);
            long ivLo = ival - divScale.multiplyByScaleFactor(ivHi);
            ival = ivHi;
            long carry = mulScale.multiplyByScaleFactor(ivLo);
            if (val3 != 0L) {
                long v3Hi = divScale.divideByScaleFactor(val3);
                long v3Lo = val3 - divScale.multiplyByScaleFactor(v3Hi);
                val3 = v3Hi + carry;
                carry = mulScale.multiplyByScaleFactor(v3Lo);
            } else {
                val3 = carry;
                carry = 0L;
            }
            if (val2 != 0L) {
                long v2Hi = divScale.divideByScaleFactor(val2);
                long v2Lo = val2 - divScale.multiplyByScaleFactor(v2Hi);
                val2 = v2Hi + carry;
                carry = mulScale.multiplyByScaleFactor(v2Lo);
            } else {
                val2 = carry;
                carry = 0L;
            }
            if (val1 != 0L) {
                long v1Hi = divScale.divideByScaleFactor(val1);
                long v1Lo = val1 - divScale.multiplyByScaleFactor(v1Hi);
                val1 = v1Hi + carry;
                carry = mulScale.multiplyByScaleFactor(v1Lo);
            } else {
                val1 = carry;
                carry = 0L;
            }
            this.roundToVal2(sgn, pow10 + div10, ival, val3, val2, val1, val0 != 0L | carry != 0L, rounding);
        } else {
            this.roundToVal2(sgn, pow10, ival, val3, val2, val1, val0 != 0L, rounding);
        }
    }

    private final void roundToVal2(int sgn, int pow10, long ival, long val3, long val2, long val1, boolean nonZeroAfterVal1, DecimalRounding rounding) {
        int inc = UnsignedDecimal9i36f.getRoundingIncrement(sgn, val2, Scale18f.INSTANCE, val1, nonZeroAfterVal1, rounding);
        if (inc > 0 && ++val2 >= 1000000000000000000L) {
            val2 = 0L;
            if (++val3 >= 1000000000000000000L) {
                val3 = 0L;
                if (++ival >= 1000000000L) {
                    ival = 100000000L;
                    ++pow10;
                }
            }
        }
        this.norm = Norm.NORMALIZED_18;
        this.pow10 = pow10;
        this.ival = ival;
        this.val3 = val3;
        this.val2 = val2;
        this.val1 = 0L;
        this.val0 = 0L;
    }

    private final void normalize09() {
        long val3 = this.val3;
        long val2 = this.val2;
        long v3 = val3 / 1000000000L;
        long v2 = val3 - v3 * 1000000000L;
        long v1 = val2 / 1000000000L;
        long v0 = val2 - v1 * 1000000000L;
        this.norm = Norm.NORMALIZED_09;
        this.val3 = v3;
        this.val2 = v2;
        this.val1 = v1;
        this.val0 = v0;
    }

    public final void multiply(int sgn, UnsignedDecimal9i36f factor, DecimalRounding rounding) {
        if (this.norm != Norm.NORMALIZED_18) {
            this.normalizeAndRound(sgn, this.pow10, this.ival, this.val3, this.val2, this.val1, this.val0, rounding);
        }
        this.multiply(sgn, this.val3, this.val2, factor, rounding);
    }

    private final void multiply(int sgn, long val3, long val2, UnsignedDecimal9i36f factor, DecimalRounding rounding) {
        if (this.norm != Norm.NORMALIZED_09) {
            this.normalize09();
        }
        long lhs4 = this.ival;
        long lhs3 = this.val3;
        long lhs2 = this.val2;
        long lhs1 = this.val1;
        long lhs0 = this.val0;
        if (factor.norm != Norm.NORMALIZED_09) {
            factor.normalize09();
        }
        long rhs4 = factor.ival;
        long rhs3 = factor.val3;
        long rhs2 = factor.val2;
        long rhs1 = factor.val1;
        long rhs0 = factor.val0;
        long scale72 = lhs0 * rhs0;
        long scale63 = lhs1 * rhs0 + rhs1 * lhs0;
        long scale54 = lhs2 * rhs0 + rhs2 * lhs0 + lhs1 * rhs1;
        long scale45 = lhs3 * rhs0 + rhs3 * lhs0 + lhs2 * rhs1 + rhs2 * lhs1;
        long scale36 = lhs3 * rhs1 + rhs3 * lhs1 + lhs2 * rhs2 + lhs0 * rhs4 + rhs0 * lhs4;
        long scale27 = lhs3 * rhs2 + rhs3 * lhs2 + lhs1 * rhs4 + rhs1 * lhs4;
        long scale18 = lhs3 * rhs3 + lhs2 * rhs4 + rhs2 * lhs4;
        long scale09 = lhs3 * rhs4 + rhs3 * lhs4;
        long scale00 = lhs4 * rhs4;
        long carry = scale63 / 1000000000L;
        long val72 = (scale63 -= carry * 1000000000L) * 1000000000L + scale72;
        while (val72 >= 1000000000000000000L) {
            val72 -= 1000000000000000000L;
            ++carry;
        }
        scale54 += carry;
        carry = scale45 / 1000000000L;
        long val54 = (scale45 -= carry * 1000000000L) * 1000000000L + scale54;
        while (val54 >= 1000000000000000000L) {
            val54 -= 1000000000000000000L;
            ++carry;
        }
        scale36 += carry;
        carry = scale27 / 1000000000L;
        long val36 = (scale27 -= carry * 1000000000L) * 1000000000L + scale36;
        while (val36 >= 1000000000000000000L) {
            val36 -= 1000000000000000000L;
            ++carry;
        }
        scale18 += carry;
        carry = scale09 / 1000000000L;
        long val18 = (scale09 -= carry * 1000000000L) * 1000000000L + scale18;
        while (val18 >= 1000000000000000000L) {
            val18 -= 1000000000000000000L;
            ++carry;
        }
        this.norm = Norm.UNNORMALIZED;
        this.pow10 += factor.pow10;
        this.ival = scale00 += carry;
        this.val3 = val18;
        this.val2 = val36;
        this.val1 = val54;
        this.val0 = val72;
    }

    private static final int getRoundingIncrement(int sgn, long truncated, ScaleMetrics scaleMetrics, long remainder, boolean nonZeroAfterRemainder, DecimalRounding rounding) {
        if (rounding != DecimalRounding.DOWN & (remainder != 0L | nonZeroAfterRemainder)) {
            TruncatedPart truncatedPart = Rounding.truncatedPartFor(remainder, scaleMetrics.getScaleFactor());
            if (nonZeroAfterRemainder) {
                if (truncatedPart == TruncatedPart.ZERO) {
                    truncatedPart = TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO;
                } else if (truncatedPart == TruncatedPart.EQUAL_TO_HALF) {
                    truncatedPart = TruncatedPart.GREATER_THAN_HALF;
                }
            }
            return UnsignedDecimal9i36f.getRoundingIncrement(sgn, truncated, rounding, truncatedPart);
        }
        return 0;
    }

    private static final int getRoundingIncrement(int sgn, long absValue, DecimalRounding rounding, TruncatedPart truncatedPart) {
        if (sgn < 0) {
            return -rounding.calculateRoundingIncrement(-1, -absValue, truncatedPart);
        }
        return rounding.calculateRoundingIncrement(1, absValue, truncatedPart);
    }

    private final int getInvNormPow10() {
        int log10 = UnsignedDecimal9i36f.log10(this.ival);
        return this.ival >= Scales.getScaleMetrics(log10 - 1).getScaleFactor() * 3L ? log10 : log10 - 1;
    }

    private final long getInvNorm(int sgn, DecimalArithmetic arith, DecimalRounding rounding) {
        int pow10 = -this.getInvNormPow10();
        if (pow10 >= 0) {
            return UnsignedDecimal9i36f.getDecimal(sgn, pow10, this.ival, this.val3, this.val2, this.val1, this.val0, 0L, 0L, 0L, 0L, arith, rounding);
        }
        return UnsignedDecimal9i36f.getDecimal(sgn, pow10 + 18, 0L, this.ival, this.val3, this.val2, this.val1, this.val0, 0L, 0L, 0L, arith, rounding);
    }

    public final long getInverted(int sgn, DecimalArithmetic arith, DecimalRounding rounding, DecimalRounding powRounding) {
        DecimalArithmetic arith18 = Scale18f.INSTANCE.getArithmetic(rounding.getRoundingMode());
        long divisor = this.getInvNorm(sgn, arith18, powRounding);
        long inverted = arith18.invert(divisor);
        int pow10 = this.getPow10() + this.getInvNormPow10() + (18 - arith.getScale());
        return arith.multiplyByPowerOf10(inverted, -pow10);
    }

    public final long getDecimal(int sgn, DecimalArithmetic arith, DecimalRounding rounding) {
        if (this.pow10 >= 0) {
            if (this.pow10 <= 18) {
                return UnsignedDecimal9i36f.getDecimal(sgn, this.pow10, this.ival, this.val3, this.val2, this.val1, this.val0, 0L, 0L, 0L, 0L, arith, rounding);
            }
            if (arith.getOverflowMode().isChecked()) {
                return this.checkedMultiplyByPowerOf10AndRound(sgn, arith, rounding);
            }
            return this.multiplyByPowerOf10AndRound(sgn, arith, rounding);
        }
        return this.divideByPowerOf10AndRound(sgn, arith, rounding);
    }

    private final long multiplyByPowerOf10AndRound(int sgn, DecimalArithmetic arith, DecimalRounding rounding) {
        long iv = this.ival * 1000000000000000000L + this.val3;
        if (this.pow10 <= 36) {
            return UnsignedDecimal9i36f.getDecimal(sgn, this.pow10 - 18, iv, this.val2, this.val1, this.val0, 0L, 0L, 0L, 0L, 0L, arith, rounding);
        }
        iv *= 1000000000000000000L + this.val2;
        if (this.pow10 <= 54) {
            return UnsignedDecimal9i36f.getDecimal(sgn, this.pow10 - 36, iv, this.val1, this.val0, 0L, 0L, 0L, 0L, 0L, 0L, arith, rounding);
        }
        iv *= 1000000000000000000L + this.val1;
        if (this.pow10 <= 72) {
            return UnsignedDecimal9i36f.getDecimal(sgn, this.pow10 - 54, iv, this.val0, 0L, 0L, 0L, 0L, 0L, 0L, 0L, arith, rounding);
        }
        iv *= 1000000000000000000L + this.val0;
        int pow = this.pow10 - 72;
        while (pow > 18 & iv != 0L) {
            iv *= 1000000000000000000L;
            pow -= 18;
        }
        if (iv != 0L) {
            long absVal = arith.fromLong(iv);
            return sgn >= 0 ? absVal : -absVal;
        }
        return 0L;
    }

    private final long checkedMultiplyByPowerOf10AndRound(int sgn, DecimalArithmetic arith, DecimalRounding rounding) {
        DecimalArithmetic arith18 = Scale18f.INSTANCE.getCheckedArithmetic(RoundingMode.DOWN);
        long iv = arith18.add(arith18.fromLong(this.ival), this.val3);
        if (this.pow10 <= 36) {
            return UnsignedDecimal9i36f.getDecimal(sgn, this.pow10 - 18, iv, this.val2, this.val1, this.val0, 0L, 0L, 0L, 0L, 0L, arith, rounding);
        }
        iv = arith18.add(arith18.fromLong(iv), this.val2);
        if (this.pow10 <= 54) {
            return UnsignedDecimal9i36f.getDecimal(sgn, this.pow10 - 36, iv, this.val1, this.val0, 0L, 0L, 0L, 0L, 0L, 0L, arith, rounding);
        }
        iv = arith18.add(arith18.fromLong(iv), this.val1);
        if (this.pow10 <= 72) {
            return UnsignedDecimal9i36f.getDecimal(sgn, this.pow10 - 54, iv, this.val0, 0L, 0L, 0L, 0L, 0L, 0L, 0L, arith, rounding);
        }
        iv = arith18.add(arith18.fromLong(iv), this.val0);
        int pow = this.pow10 - 72;
        while (pow > 18 & iv != 0L) {
            iv = arith18.fromLong(iv);
            pow -= 18;
        }
        if (iv != 0L) {
            long absVal = arith.fromLong(iv);
            return sgn >= 0 ? absVal : arith.negate(absVal);
        }
        return 0L;
    }

    private final long divideByPowerOf10AndRound(int sgn, DecimalArithmetic arith, DecimalRounding rounding) {
        if (this.pow10 >= -18) {
            return UnsignedDecimal9i36f.getDecimal(sgn, this.pow10 + 18, 0L, this.ival, this.val3, this.val2, this.val1, this.val0, 0L, 0L, 0L, arith, rounding);
        }
        if (this.pow10 >= -36) {
            return UnsignedDecimal9i36f.getDecimal(sgn, this.pow10 + 36, 0L, 0L, this.ival, this.val3, this.val2, this.val1, this.val0, 0L, 0L, arith, rounding);
        }
        if (rounding != DecimalRounding.DOWN & (this.ival != 0L | this.val3 != 0L | this.val2 != 0L | this.val1 != 0L | this.val0 != 0L)) {
            return rounding.calculateRoundingIncrement(sgn, 0L, TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO);
        }
        return 0L;
    }

    private static final long getDecimal(int sgn, int pow10, long ival, long val3, long val2, long val1, long val0, long rem1, long rem2, long rem3, long rem4, DecimalArithmetic arith, DecimalRounding rounding) {
        long rem18;
        long fra18;
        long int18;
        OverflowMode overflowMode = arith.getOverflowMode();
        if (pow10 > 0) {
            ScaleMetrics mul10Scale = Scales.getScaleMetrics(pow10);
            ScaleMetrics div10Scale = Scales.getScaleMetrics(18 - pow10);
            long hiVal3 = div10Scale.divideByScaleFactor(val3);
            long loVal3 = val3 - div10Scale.multiplyByScaleFactor(hiVal3);
            long hiVal2 = div10Scale.divideByScaleFactor(val2);
            long loVal2 = val2 - div10Scale.multiplyByScaleFactor(hiVal2);
            int18 = UnsignedDecimal9i36f.add(UnsignedDecimal9i36f.mulByScaleFactor(mul10Scale, ival, overflowMode), hiVal3, overflowMode);
            fra18 = mul10Scale.multiplyByScaleFactor(loVal3) + hiVal2;
            rem18 = loVal2;
        } else {
            int18 = ival;
            fra18 = val3;
            rem18 = val2;
        }
        ScaleMetrics diffMetrics = Scales.getScaleMetrics(18 - arith.getScale());
        long fraVal = diffMetrics.divideByScaleFactor(fra18);
        long fraRem = fra18 - diffMetrics.multiplyByScaleFactor(fraVal);
        int inc = UnsignedDecimal9i36f.getRoundingIncrement(sgn, fraVal, diffMetrics, fraRem, rem18 != 0L | val1 != 0L | val0 != 0L | rem1 != 0L | rem2 != 0L | rem3 != 0L | rem4 != 0L, rounding);
        long fraRnd = fraVal + (long)inc;
        long absVal = UnsignedDecimal9i36f.add(arith.fromLong(int18), fraRnd, overflowMode);
        return sgn >= 0 ? absVal : arith.negate(absVal);
    }

    private static final long add(long l1, long l2, OverflowMode overflowMode) {
        return overflowMode == OverflowMode.UNCHECKED ? l1 + l2 : Checked.addLong(l1, l2);
    }

    private static final long mulByScaleFactor(ScaleMetrics scaleMetrics, long val, OverflowMode overflowMode) {
        return val == 0L ? 0L : (overflowMode == OverflowMode.UNCHECKED ? scaleMetrics.multiplyByScaleFactor(val) : scaleMetrics.multiplyByScaleFactorExact(val));
    }

    private static final int log10(long absVal) {
        long[] tab;
        if (absVal < 10L) {
            return 1;
        }
        int r = (64 - Long.numberOfLeadingZeros(absVal) + 1) * 1233 >>> 12;
        return r >= (tab = LONG_TEN_POWERS_TABLE).length || absVal < tab[r] ? r : r + 1;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.ival);
        sb.append('.');
        int len = sb.length();
        sb.append(this.val3);
        sb.insert(len, "000000000000000000", 0, len + 18 - sb.length());
        len = sb.length();
        sb.append(this.val2);
        sb.insert(len, "000000000000000000", 0, len + 18 - sb.length());
        if (this.val1 != 0L | this.val0 != 0L) {
            sb.append("..");
        }
        sb.append("*10^").append(this.pow10);
        return sb.toString();
    }

    private static enum Norm {
        UNNORMALIZED,
        NORMALIZED_18,
        NORMALIZED_09;

    }
}

