/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.base;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.MutableDecimal;
import org.decimal4j.arithmetic.Exceptions;
import org.decimal4j.base.AbstractDecimal;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.scale.Scales;

public abstract class AbstractMutableDecimal<S extends ScaleMetrics, D extends AbstractMutableDecimal<S, D>>
extends AbstractDecimal<S, D>
implements MutableDecimal<S> {
    private long unscaled;

    public AbstractMutableDecimal(long unscaled) {
        this.unscaled = unscaled;
    }

    @Override
    public final long unscaledValue() {
        return this.unscaled;
    }

    @Override
    protected D createOrAssign(long unscaled) {
        this.unscaled = unscaled;
        return (D)((AbstractMutableDecimal)this.self());
    }

    @Override
    public MutableDecimal<?> scale(int scale) {
        return this.scale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public <S extends ScaleMetrics> MutableDecimal<S> scale(S scaleMetrics) {
        return this.scale((ScaleMetrics)scaleMetrics, RoundingMode.HALF_UP);
    }

    @Override
    public MutableDecimal<?> scale(int scale, RoundingMode roundingMode) {
        int myScale = this.getScale();
        if (scale == myScale) {
            return this;
        }
        ScaleMetrics targetMetrics = Scales.getScaleMetrics(scale);
        try {
            long targetUnscaled = targetMetrics.getArithmetic(roundingMode).fromUnscaled(this.unscaled, myScale);
            return this.getFactory().deriveFactory(scale).newMutable().setUnscaled(targetUnscaled);
        }
        catch (IllegalArgumentException e) {
            throw Exceptions.newArithmeticExceptionWithCause("Overflow: cannot convert " + this + " to scale " + scale, e);
        }
    }

    @Override
    public <S extends ScaleMetrics> MutableDecimal<S> scale(S scaleMetrics, RoundingMode roundingMode) {
        if (scaleMetrics == this.getScaleMetrics()) {
            AbstractMutableDecimal self = this;
            return self;
        }
        try {
            long targetUnscaled = scaleMetrics.getArithmetic(roundingMode).fromUnscaled(this.unscaled, this.getScale());
            return this.getFactory().deriveFactory(scaleMetrics).newMutable().setUnscaled(targetUnscaled);
        }
        catch (IllegalArgumentException e) {
            throw Exceptions.newArithmeticExceptionWithCause("Overflow: cannot convert " + this + " to scale " + scaleMetrics.getScale(), e);
        }
    }

    @Override
    public MutableDecimal<?> multiplyExact(Decimal<?> multiplicand) {
        int targetScale = this.getScale() + multiplicand.getScale();
        if (targetScale > 18) {
            throw new IllegalArgumentException("sum of scales exceeds max scale: " + targetScale + " > " + 18);
        }
        try {
            long unscaledProduct = this.getCheckedArithmeticFor(RoundingMode.DOWN).multiplyByLong(this.unscaled, multiplicand.unscaledValue());
            return this.getFactory().deriveFactory(targetScale).newMutable().setUnscaled(unscaledProduct);
        }
        catch (ArithmeticException e) {
            throw new ArithmeticException("Overflow: " + this + " * " + multiplicand);
        }
    }

    public D setZero() {
        this.unscaled = 0L;
        return (D)((AbstractMutableDecimal)this.self());
    }

    public D setOne() {
        this.unscaled = this.getScaleMetrics().getScaleFactor();
        return (D)((AbstractMutableDecimal)this.self());
    }

    public D setMinusOne() {
        this.unscaled = -this.getScaleMetrics().getScaleFactor();
        return (D)((AbstractMutableDecimal)this.self());
    }

    public D setUlp() {
        this.unscaled = 1L;
        return (D)((AbstractMutableDecimal)this.self());
    }

    public D set(Decimal<S> value) {
        return (D)this.setUnscaled(value.unscaledValue());
    }

    public D set(Decimal<?> value, RoundingMode roundingMode) {
        return (D)this.setUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public D set(long value) {
        this.unscaled = this.getDefaultCheckedArithmetic().fromLong(value);
        return (D)((AbstractMutableDecimal)this.self());
    }

    public D set(BigInteger value) {
        this.unscaled = this.getDefaultCheckedArithmetic().fromBigInteger(value);
        return (D)((AbstractMutableDecimal)this.self());
    }

    public D set(float value) {
        this.unscaled = this.getDefaultCheckedArithmetic().fromFloat(value);
        return (D)((AbstractMutableDecimal)this.self());
    }

    public D set(float value, RoundingMode roundingMode) {
        this.unscaled = this.getCheckedArithmeticFor(roundingMode).fromFloat(value);
        return (D)((AbstractMutableDecimal)this.self());
    }

    public D set(double value) {
        this.unscaled = this.getDefaultCheckedArithmetic().fromDouble(value);
        return (D)((AbstractMutableDecimal)this.self());
    }

    public D set(double value, RoundingMode roundingMode) {
        this.unscaled = this.getCheckedArithmeticFor(roundingMode).fromDouble(value);
        return (D)((AbstractMutableDecimal)this.self());
    }

    public D set(BigDecimal value) {
        this.unscaled = this.getDefaultCheckedArithmetic().fromBigDecimal(value);
        return (D)((AbstractMutableDecimal)this.self());
    }

    public D set(BigDecimal value, RoundingMode roundingMode) {
        this.unscaled = this.getCheckedArithmeticFor(roundingMode).fromBigDecimal(value);
        return (D)((AbstractMutableDecimal)this.self());
    }

    public D setUnscaled(long unscaledValue) {
        this.unscaled = unscaledValue;
        return (D)((AbstractMutableDecimal)this.self());
    }

    public D setUnscaled(long unscaledValue, int scale) {
        this.unscaled = this.getDefaultCheckedArithmetic().fromUnscaled(unscaledValue, scale);
        return (D)((AbstractMutableDecimal)this.self());
    }

    public D setUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        this.unscaled = this.getCheckedArithmeticFor(roundingMode).fromUnscaled(unscaledValue, scale);
        return (D)((AbstractMutableDecimal)this.self());
    }

    public D set(String value) {
        this.unscaled = this.getDefaultCheckedArithmetic().parse(value);
        return (D)((AbstractMutableDecimal)this.self());
    }

    public D set(String value, RoundingMode roundingMode) {
        this.unscaled = this.getCheckedArithmeticFor(roundingMode).parse(value);
        return (D)((AbstractMutableDecimal)this.self());
    }

    @Override
    public MutableDecimal<S> min(MutableDecimal<S> val) {
        return this.isLessThanOrEqualTo(val) ? this : val;
    }

    @Override
    public MutableDecimal<S> max(MutableDecimal<S> val) {
        return this.isGreaterThanOrEqualTo(val) ? this : val;
    }

    public abstract D clone();
}

