/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.factory;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.decimal4j.factory.DecimalFactory;
import org.decimal4j.factory.Factory0f;
import org.decimal4j.factory.Factory10f;
import org.decimal4j.factory.Factory11f;
import org.decimal4j.factory.Factory12f;
import org.decimal4j.factory.Factory13f;
import org.decimal4j.factory.Factory14f;
import org.decimal4j.factory.Factory15f;
import org.decimal4j.factory.Factory16f;
import org.decimal4j.factory.Factory17f;
import org.decimal4j.factory.Factory18f;
import org.decimal4j.factory.Factory1f;
import org.decimal4j.factory.Factory2f;
import org.decimal4j.factory.Factory3f;
import org.decimal4j.factory.Factory4f;
import org.decimal4j.factory.Factory5f;
import org.decimal4j.factory.Factory6f;
import org.decimal4j.factory.Factory7f;
import org.decimal4j.factory.Factory8f;
import org.decimal4j.factory.Factory9f;
import org.decimal4j.generic.GenericDecimalFactory;
import org.decimal4j.scale.ScaleMetrics;

public final class Factories {
    private static final DecimalFactory<?>[] FACTORIES = new DecimalFactory[]{Factory0f.INSTANCE, Factory1f.INSTANCE, Factory2f.INSTANCE, Factory3f.INSTANCE, Factory4f.INSTANCE, Factory5f.INSTANCE, Factory6f.INSTANCE, Factory7f.INSTANCE, Factory8f.INSTANCE, Factory9f.INSTANCE, Factory10f.INSTANCE, Factory11f.INSTANCE, Factory12f.INSTANCE, Factory13f.INSTANCE, Factory14f.INSTANCE, Factory15f.INSTANCE, Factory16f.INSTANCE, Factory17f.INSTANCE, Factory18f.INSTANCE};
    private static final GenericDecimalFactory<?>[] GENERIC_FACTORIES = Factories.initGenericFactories();
    public static final List<DecimalFactory<?>> VALUES = Collections.unmodifiableList(Arrays.asList(FACTORIES));

    private static final GenericDecimalFactory<?>[] initGenericFactories() {
        GenericDecimalFactory[] genericFactories = new GenericDecimalFactory[FACTORIES.length];
        for (int i = 0; i < FACTORIES.length; ++i) {
            genericFactories[i] = new GenericDecimalFactory(FACTORIES[i].getScaleMetrics());
        }
        return genericFactories;
    }

    public static final DecimalFactory<?> getDecimalFactory(int scale) {
        if (0 <= scale & scale <= 18) {
            return FACTORIES[scale];
        }
        throw new IllegalArgumentException("Illegal scale, must be in [0,18] but was: " + scale);
    }

    public static final <S extends ScaleMetrics> DecimalFactory<S> getDecimalFactory(S scaleMetrics) {
        DecimalFactory<int> factory = Factories.getDecimalFactory(scaleMetrics.getScale());
        return factory;
    }

    public static final GenericDecimalFactory<?> getGenericDecimalFactory(int scale) {
        if (0 <= scale & scale <= 18) {
            return GENERIC_FACTORIES[scale];
        }
        throw new IllegalArgumentException("Illegal scale, must be in [0,18] but was: " + scale);
    }

    public static final <S extends ScaleMetrics> GenericDecimalFactory<S> getGenericDecimalFactory(S scaleMetrics) {
        GenericDecimalFactory<int> factory = Factories.getGenericDecimalFactory(scaleMetrics.getScale());
        return factory;
    }

    private Factories() {
    }
}

