/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.generic;

import java.util.Objects;
import org.decimal4j.api.Decimal;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.factory.Factories;
import org.decimal4j.generic.GenericDecimalFactory;
import org.decimal4j.generic.GenericMutableDecimal;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.scale.Scales;

public final class GenericImmutableDecimal<S extends ScaleMetrics>
extends AbstractImmutableDecimal<S, GenericImmutableDecimal<S>> {
    private static final long serialVersionUID = 1L;
    private final S scaleMetrics;

    public GenericImmutableDecimal(S scaleMetrics, long unscaledValue) {
        super(unscaledValue);
        this.scaleMetrics = (ScaleMetrics)Objects.requireNonNull(scaleMetrics, "scaleMetrics cannot be null");
    }

    public GenericImmutableDecimal(Decimal<S> decimal) {
        this(decimal.getScaleMetrics(), decimal.unscaledValue());
    }

    public static <S extends ScaleMetrics> GenericImmutableDecimal<S> valueOf(Decimal<S> decimal) {
        return new GenericImmutableDecimal<S>(decimal);
    }

    public static <S extends ScaleMetrics> GenericImmutableDecimal<S> valueOfUnscaled(S scaleMetrics, long unscaled) {
        return new GenericImmutableDecimal<S>(scaleMetrics, unscaled);
    }

    public static GenericImmutableDecimal<?> valueOfUnscaled(int scale, long unscaled) {
        return GenericImmutableDecimal.valueOfUnscaled(Scales.getScaleMetrics(scale), unscaled);
    }

    @Override
    public S getScaleMetrics() {
        return this.scaleMetrics;
    }

    @Override
    public int getScale() {
        return this.scaleMetrics.getScale();
    }

    @Override
    public GenericDecimalFactory<S> getFactory() {
        return Factories.getGenericDecimalFactory(this.scaleMetrics);
    }

    @Override
    protected GenericImmutableDecimal<S> self() {
        return this;
    }

    @Override
    protected GenericImmutableDecimal<S> createOrAssign(long unscaled) {
        return this.unscaledValue() == unscaled ? this : this.create(unscaled);
    }

    @Override
    protected GenericImmutableDecimal<S> create(long unscaled) {
        return new GenericImmutableDecimal<S>(this.scaleMetrics, unscaled);
    }

    protected GenericImmutableDecimal<S>[] createArray(int length) {
        return new GenericImmutableDecimal[length];
    }

    @Override
    public GenericMutableDecimal<S> toMutableDecimal() {
        return new GenericMutableDecimal(this);
    }

    @Override
    public GenericImmutableDecimal<S> toImmutableDecimal() {
        return this;
    }
}

