/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.generic;

import java.util.Objects;
import org.decimal4j.api.Decimal;
import org.decimal4j.base.AbstractMutableDecimal;
import org.decimal4j.factory.Factories;
import org.decimal4j.generic.GenericDecimalFactory;
import org.decimal4j.generic.GenericImmutableDecimal;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.scale.Scales;

public final class GenericMutableDecimal<S extends ScaleMetrics>
extends AbstractMutableDecimal<S, GenericMutableDecimal<S>>
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private final S scaleMetrics;

    public GenericMutableDecimal(S scaleMetrics) {
        this(scaleMetrics, 0L);
    }

    public GenericMutableDecimal(Decimal<S> decimal) {
        this(decimal.getScaleMetrics(), decimal.unscaledValue());
    }

    public GenericMutableDecimal(S scaleMetrics, long unscaledValue) {
        super(unscaledValue);
        this.scaleMetrics = (ScaleMetrics)Objects.requireNonNull(scaleMetrics, "scaleMetrics cannot be null");
    }

    public static <S extends ScaleMetrics> GenericMutableDecimal<S> valueOf(Decimal<S> decimal) {
        return new GenericMutableDecimal<S>(decimal);
    }

    public static <S extends ScaleMetrics> GenericMutableDecimal<S> valueOfUnscaled(S scaleMetrics, long unscaled) {
        return new GenericMutableDecimal<S>(scaleMetrics, unscaled);
    }

    public static GenericMutableDecimal<?> valueOfUnscaled(int scale, long unscaled) {
        return GenericMutableDecimal.valueOfUnscaled(Scales.getScaleMetrics(scale), unscaled);
    }

    @Override
    protected GenericMutableDecimal<S> create(long unscaled) {
        return new GenericMutableDecimal<S>(this.scaleMetrics, unscaled);
    }

    protected GenericMutableDecimal<S>[] createArray(int length) {
        return new GenericMutableDecimal[length];
    }

    @Override
    protected GenericMutableDecimal<S> self() {
        return this;
    }

    @Override
    public S getScaleMetrics() {
        return this.scaleMetrics;
    }

    @Override
    public int getScale() {
        return this.scaleMetrics.getScale();
    }

    @Override
    public GenericDecimalFactory<S> getFactory() {
        return Factories.getGenericDecimalFactory(this.scaleMetrics);
    }

    @Override
    public GenericMutableDecimal<S> clone() {
        return new GenericMutableDecimal<S>(this.scaleMetrics, this.unscaledValue());
    }

    @Override
    public GenericImmutableDecimal<S> toImmutableDecimal() {
        return new GenericImmutableDecimal(this);
    }

    @Override
    public GenericMutableDecimal<S> toMutableDecimal() {
        return this;
    }
}

