/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable0f;
import org.decimal4j.factory.Factory0f;
import org.decimal4j.mutable.MutableDecimal0f;
import org.decimal4j.scale.Scale0f;

public final class Decimal0f
extends AbstractImmutableDecimal<Scale0f, Decimal0f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 0;
    public static final Scale0f METRICS = Scale0f.INSTANCE;
    public static final Factory0f FACTORY = Factory0f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal0f ZERO = new Decimal0f(0L);
    public static final Decimal0f ULP = new Decimal0f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal0f[] POS_CONST = new Decimal0f[11];
    private static final Decimal0f[] NEG_CONST = new Decimal0f[11];
    public static final Decimal0f ONE;
    public static final Decimal0f TWO;
    public static final Decimal0f THREE;
    public static final Decimal0f FOUR;
    public static final Decimal0f FIVE;
    public static final Decimal0f SIX;
    public static final Decimal0f SEVEN;
    public static final Decimal0f EIGHT;
    public static final Decimal0f NINE;
    public static final Decimal0f TEN;
    public static final Decimal0f HUNDRED;
    public static final Decimal0f THOUSAND;
    public static final Decimal0f MILLION;
    public static final Decimal0f BILLION;
    public static final Decimal0f TRILLION;
    public static final Decimal0f QUADRILLION;
    public static final Decimal0f QUINTILLION;
    public static final Decimal0f MINUS_ONE;
    public static final Decimal0f MAX_VALUE;
    public static final Decimal0f MAX_INTEGER_VALUE;
    public static final Decimal0f MIN_VALUE;
    public static final Decimal0f MIN_INTEGER_VALUE;

    private Decimal0f(long unscaled) {
        super(unscaled);
    }

    public Decimal0f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale0f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 0;
    }

    public final Factory0f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal0f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal0f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal0f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal0f valueOf(float value) {
        return Decimal0f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal0f valueOf(float value, RoundingMode roundingMode) {
        return Decimal0f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal0f valueOf(double value) {
        return Decimal0f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal0f valueOf(double value, RoundingMode roundingMode) {
        return Decimal0f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal0f valueOf(BigInteger value) {
        return Decimal0f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal0f valueOf(BigDecimal value) {
        return Decimal0f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal0f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal0f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal0f valueOf(Decimal<?> value) {
        if (value instanceof Decimal0f) {
            return (Decimal0f)value;
        }
        return Decimal0f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal0f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal0f) {
            return (Decimal0f)value;
        }
        return Decimal0f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal0f valueOf(String value) {
        return Decimal0f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal0f valueOf(String value, RoundingMode roundingMode) {
        return Decimal0f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal0f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal0f(unscaledValue);
    }

    public static Decimal0f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal0f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal0f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal0f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal0f createOrAssign(long unscaled) {
        return Decimal0f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal0f create(long unscaled) {
        return Decimal0f.valueOfUnscaled(unscaled);
    }

    protected Decimal0f[] createArray(int length) {
        return new Decimal0f[length];
    }

    public Multipliable0f multiplyExact() {
        return new Multipliable0f(this);
    }

    public MutableDecimal0f toMutableDecimal() {
        return new MutableDecimal0f(this);
    }

    public Decimal0f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal0f.POS_CONST[i] = new Decimal0f(ONE_UNSCALED * (long)i);
            Decimal0f.NEG_CONST[i] = new Decimal0f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal0f.valueOf(1L);
        TWO = Decimal0f.valueOf(2L);
        THREE = Decimal0f.valueOf(3L);
        FOUR = Decimal0f.valueOf(4L);
        FIVE = Decimal0f.valueOf(5L);
        SIX = Decimal0f.valueOf(6L);
        SEVEN = Decimal0f.valueOf(7L);
        EIGHT = Decimal0f.valueOf(8L);
        NINE = Decimal0f.valueOf(9L);
        TEN = Decimal0f.valueOf(10L);
        HUNDRED = new Decimal0f(100L * ONE_UNSCALED);
        THOUSAND = new Decimal0f(1000L * ONE_UNSCALED);
        MILLION = new Decimal0f(1000000L * ONE_UNSCALED);
        BILLION = new Decimal0f(1000000000L * ONE_UNSCALED);
        TRILLION = new Decimal0f(1000000000000L * ONE_UNSCALED);
        QUADRILLION = new Decimal0f(1000000000000000L * ONE_UNSCALED);
        QUINTILLION = new Decimal0f(1000000000000000000L * ONE_UNSCALED);
        MINUS_ONE = Decimal0f.valueOf(-1L);
        MAX_VALUE = new Decimal0f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal0f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal0f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal0f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

