/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable10f;
import org.decimal4j.factory.Factory10f;
import org.decimal4j.mutable.MutableDecimal10f;
import org.decimal4j.scale.Scale10f;

public final class Decimal10f
extends AbstractImmutableDecimal<Scale10f, Decimal10f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 10;
    public static final Scale10f METRICS = Scale10f.INSTANCE;
    public static final Factory10f FACTORY = Factory10f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal10f ZERO = new Decimal10f(0L);
    public static final Decimal10f ULP = new Decimal10f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal10f[] POS_CONST = new Decimal10f[11];
    private static final Decimal10f[] NEG_CONST = new Decimal10f[11];
    public static final Decimal10f ONE;
    public static final Decimal10f TWO;
    public static final Decimal10f THREE;
    public static final Decimal10f FOUR;
    public static final Decimal10f FIVE;
    public static final Decimal10f SIX;
    public static final Decimal10f SEVEN;
    public static final Decimal10f EIGHT;
    public static final Decimal10f NINE;
    public static final Decimal10f TEN;
    public static final Decimal10f HUNDRED;
    public static final Decimal10f THOUSAND;
    public static final Decimal10f MILLION;
    public static final Decimal10f MINUS_ONE;
    public static final Decimal10f HALF;
    public static final Decimal10f TENTH;
    public static final Decimal10f HUNDREDTH;
    public static final Decimal10f THOUSANDTH;
    public static final Decimal10f MILLIONTH;
    public static final Decimal10f BILLIONTH;
    public static final Decimal10f MAX_VALUE;
    public static final Decimal10f MAX_INTEGER_VALUE;
    public static final Decimal10f MIN_VALUE;
    public static final Decimal10f MIN_INTEGER_VALUE;

    private Decimal10f(long unscaled) {
        super(unscaled);
    }

    public Decimal10f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale10f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 10;
    }

    public final Factory10f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal10f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal10f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal10f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal10f valueOf(float value) {
        return Decimal10f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal10f valueOf(float value, RoundingMode roundingMode) {
        return Decimal10f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal10f valueOf(double value) {
        return Decimal10f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal10f valueOf(double value, RoundingMode roundingMode) {
        return Decimal10f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal10f valueOf(BigInteger value) {
        return Decimal10f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal10f valueOf(BigDecimal value) {
        return Decimal10f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal10f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal10f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal10f valueOf(Decimal<?> value) {
        if (value instanceof Decimal10f) {
            return (Decimal10f)value;
        }
        return Decimal10f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal10f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal10f) {
            return (Decimal10f)value;
        }
        return Decimal10f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal10f valueOf(String value) {
        return Decimal10f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal10f valueOf(String value, RoundingMode roundingMode) {
        return Decimal10f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal10f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal10f(unscaledValue);
    }

    public static Decimal10f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal10f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal10f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal10f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal10f createOrAssign(long unscaled) {
        return Decimal10f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal10f create(long unscaled) {
        return Decimal10f.valueOfUnscaled(unscaled);
    }

    protected Decimal10f[] createArray(int length) {
        return new Decimal10f[length];
    }

    public Multipliable10f multiplyExact() {
        return new Multipliable10f(this);
    }

    public MutableDecimal10f toMutableDecimal() {
        return new MutableDecimal10f(this);
    }

    public Decimal10f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal10f.POS_CONST[i] = new Decimal10f(ONE_UNSCALED * (long)i);
            Decimal10f.NEG_CONST[i] = new Decimal10f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal10f.valueOf(1L);
        TWO = Decimal10f.valueOf(2L);
        THREE = Decimal10f.valueOf(3L);
        FOUR = Decimal10f.valueOf(4L);
        FIVE = Decimal10f.valueOf(5L);
        SIX = Decimal10f.valueOf(6L);
        SEVEN = Decimal10f.valueOf(7L);
        EIGHT = Decimal10f.valueOf(8L);
        NINE = Decimal10f.valueOf(9L);
        TEN = Decimal10f.valueOf(10L);
        HUNDRED = new Decimal10f(100L * ONE_UNSCALED);
        THOUSAND = new Decimal10f(1000L * ONE_UNSCALED);
        MILLION = new Decimal10f(1000000L * ONE_UNSCALED);
        MINUS_ONE = Decimal10f.valueOf(-1L);
        HALF = new Decimal10f(ONE_UNSCALED / 2L);
        TENTH = new Decimal10f(ONE_UNSCALED / 10L);
        HUNDREDTH = new Decimal10f(ONE_UNSCALED / 100L);
        THOUSANDTH = new Decimal10f(ONE_UNSCALED / 1000L);
        MILLIONTH = new Decimal10f(ONE_UNSCALED / 1000000L);
        BILLIONTH = new Decimal10f(ONE_UNSCALED / 1000000000L);
        MAX_VALUE = new Decimal10f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal10f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal10f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal10f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

