/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable12f;
import org.decimal4j.factory.Factory12f;
import org.decimal4j.mutable.MutableDecimal12f;
import org.decimal4j.scale.Scale12f;

public final class Decimal12f
extends AbstractImmutableDecimal<Scale12f, Decimal12f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 12;
    public static final Scale12f METRICS = Scale12f.INSTANCE;
    public static final Factory12f FACTORY = Factory12f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal12f ZERO = new Decimal12f(0L);
    public static final Decimal12f ULP = new Decimal12f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal12f[] POS_CONST = new Decimal12f[11];
    private static final Decimal12f[] NEG_CONST = new Decimal12f[11];
    public static final Decimal12f ONE;
    public static final Decimal12f TWO;
    public static final Decimal12f THREE;
    public static final Decimal12f FOUR;
    public static final Decimal12f FIVE;
    public static final Decimal12f SIX;
    public static final Decimal12f SEVEN;
    public static final Decimal12f EIGHT;
    public static final Decimal12f NINE;
    public static final Decimal12f TEN;
    public static final Decimal12f HUNDRED;
    public static final Decimal12f THOUSAND;
    public static final Decimal12f MILLION;
    public static final Decimal12f MINUS_ONE;
    public static final Decimal12f HALF;
    public static final Decimal12f TENTH;
    public static final Decimal12f HUNDREDTH;
    public static final Decimal12f THOUSANDTH;
    public static final Decimal12f MILLIONTH;
    public static final Decimal12f BILLIONTH;
    public static final Decimal12f TRILLIONTH;
    public static final Decimal12f MAX_VALUE;
    public static final Decimal12f MAX_INTEGER_VALUE;
    public static final Decimal12f MIN_VALUE;
    public static final Decimal12f MIN_INTEGER_VALUE;

    private Decimal12f(long unscaled) {
        super(unscaled);
    }

    public Decimal12f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale12f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 12;
    }

    public final Factory12f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal12f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal12f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal12f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal12f valueOf(float value) {
        return Decimal12f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal12f valueOf(float value, RoundingMode roundingMode) {
        return Decimal12f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal12f valueOf(double value) {
        return Decimal12f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal12f valueOf(double value, RoundingMode roundingMode) {
        return Decimal12f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal12f valueOf(BigInteger value) {
        return Decimal12f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal12f valueOf(BigDecimal value) {
        return Decimal12f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal12f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal12f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal12f valueOf(Decimal<?> value) {
        if (value instanceof Decimal12f) {
            return (Decimal12f)value;
        }
        return Decimal12f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal12f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal12f) {
            return (Decimal12f)value;
        }
        return Decimal12f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal12f valueOf(String value) {
        return Decimal12f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal12f valueOf(String value, RoundingMode roundingMode) {
        return Decimal12f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal12f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal12f(unscaledValue);
    }

    public static Decimal12f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal12f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal12f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal12f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal12f createOrAssign(long unscaled) {
        return Decimal12f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal12f create(long unscaled) {
        return Decimal12f.valueOfUnscaled(unscaled);
    }

    protected Decimal12f[] createArray(int length) {
        return new Decimal12f[length];
    }

    public Multipliable12f multiplyExact() {
        return new Multipliable12f(this);
    }

    public MutableDecimal12f toMutableDecimal() {
        return new MutableDecimal12f(this);
    }

    public Decimal12f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal12f.POS_CONST[i] = new Decimal12f(ONE_UNSCALED * (long)i);
            Decimal12f.NEG_CONST[i] = new Decimal12f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal12f.valueOf(1L);
        TWO = Decimal12f.valueOf(2L);
        THREE = Decimal12f.valueOf(3L);
        FOUR = Decimal12f.valueOf(4L);
        FIVE = Decimal12f.valueOf(5L);
        SIX = Decimal12f.valueOf(6L);
        SEVEN = Decimal12f.valueOf(7L);
        EIGHT = Decimal12f.valueOf(8L);
        NINE = Decimal12f.valueOf(9L);
        TEN = Decimal12f.valueOf(10L);
        HUNDRED = new Decimal12f(100L * ONE_UNSCALED);
        THOUSAND = new Decimal12f(1000L * ONE_UNSCALED);
        MILLION = new Decimal12f(1000000L * ONE_UNSCALED);
        MINUS_ONE = Decimal12f.valueOf(-1L);
        HALF = new Decimal12f(ONE_UNSCALED / 2L);
        TENTH = new Decimal12f(ONE_UNSCALED / 10L);
        HUNDREDTH = new Decimal12f(ONE_UNSCALED / 100L);
        THOUSANDTH = new Decimal12f(ONE_UNSCALED / 1000L);
        MILLIONTH = new Decimal12f(ONE_UNSCALED / 1000000L);
        BILLIONTH = new Decimal12f(ONE_UNSCALED / 1000000000L);
        TRILLIONTH = new Decimal12f(ONE_UNSCALED / 1000000000000L);
        MAX_VALUE = new Decimal12f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal12f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal12f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal12f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

