/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable14f;
import org.decimal4j.factory.Factory14f;
import org.decimal4j.mutable.MutableDecimal14f;
import org.decimal4j.scale.Scale14f;

public final class Decimal14f
extends AbstractImmutableDecimal<Scale14f, Decimal14f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 14;
    public static final Scale14f METRICS = Scale14f.INSTANCE;
    public static final Factory14f FACTORY = Factory14f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal14f ZERO = new Decimal14f(0L);
    public static final Decimal14f ULP = new Decimal14f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal14f[] POS_CONST = new Decimal14f[11];
    private static final Decimal14f[] NEG_CONST = new Decimal14f[11];
    public static final Decimal14f ONE;
    public static final Decimal14f TWO;
    public static final Decimal14f THREE;
    public static final Decimal14f FOUR;
    public static final Decimal14f FIVE;
    public static final Decimal14f SIX;
    public static final Decimal14f SEVEN;
    public static final Decimal14f EIGHT;
    public static final Decimal14f NINE;
    public static final Decimal14f TEN;
    public static final Decimal14f HUNDRED;
    public static final Decimal14f THOUSAND;
    public static final Decimal14f MINUS_ONE;
    public static final Decimal14f HALF;
    public static final Decimal14f TENTH;
    public static final Decimal14f HUNDREDTH;
    public static final Decimal14f THOUSANDTH;
    public static final Decimal14f MILLIONTH;
    public static final Decimal14f BILLIONTH;
    public static final Decimal14f TRILLIONTH;
    public static final Decimal14f MAX_VALUE;
    public static final Decimal14f MAX_INTEGER_VALUE;
    public static final Decimal14f MIN_VALUE;
    public static final Decimal14f MIN_INTEGER_VALUE;

    private Decimal14f(long unscaled) {
        super(unscaled);
    }

    public Decimal14f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale14f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 14;
    }

    public final Factory14f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal14f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal14f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal14f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal14f valueOf(float value) {
        return Decimal14f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal14f valueOf(float value, RoundingMode roundingMode) {
        return Decimal14f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal14f valueOf(double value) {
        return Decimal14f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal14f valueOf(double value, RoundingMode roundingMode) {
        return Decimal14f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal14f valueOf(BigInteger value) {
        return Decimal14f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal14f valueOf(BigDecimal value) {
        return Decimal14f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal14f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal14f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal14f valueOf(Decimal<?> value) {
        if (value instanceof Decimal14f) {
            return (Decimal14f)value;
        }
        return Decimal14f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal14f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal14f) {
            return (Decimal14f)value;
        }
        return Decimal14f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal14f valueOf(String value) {
        return Decimal14f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal14f valueOf(String value, RoundingMode roundingMode) {
        return Decimal14f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal14f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal14f(unscaledValue);
    }

    public static Decimal14f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal14f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal14f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal14f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal14f createOrAssign(long unscaled) {
        return Decimal14f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal14f create(long unscaled) {
        return Decimal14f.valueOfUnscaled(unscaled);
    }

    protected Decimal14f[] createArray(int length) {
        return new Decimal14f[length];
    }

    public Multipliable14f multiplyExact() {
        return new Multipliable14f(this);
    }

    public MutableDecimal14f toMutableDecimal() {
        return new MutableDecimal14f(this);
    }

    public Decimal14f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal14f.POS_CONST[i] = new Decimal14f(ONE_UNSCALED * (long)i);
            Decimal14f.NEG_CONST[i] = new Decimal14f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal14f.valueOf(1L);
        TWO = Decimal14f.valueOf(2L);
        THREE = Decimal14f.valueOf(3L);
        FOUR = Decimal14f.valueOf(4L);
        FIVE = Decimal14f.valueOf(5L);
        SIX = Decimal14f.valueOf(6L);
        SEVEN = Decimal14f.valueOf(7L);
        EIGHT = Decimal14f.valueOf(8L);
        NINE = Decimal14f.valueOf(9L);
        TEN = Decimal14f.valueOf(10L);
        HUNDRED = new Decimal14f(100L * ONE_UNSCALED);
        THOUSAND = new Decimal14f(1000L * ONE_UNSCALED);
        MINUS_ONE = Decimal14f.valueOf(-1L);
        HALF = new Decimal14f(ONE_UNSCALED / 2L);
        TENTH = new Decimal14f(ONE_UNSCALED / 10L);
        HUNDREDTH = new Decimal14f(ONE_UNSCALED / 100L);
        THOUSANDTH = new Decimal14f(ONE_UNSCALED / 1000L);
        MILLIONTH = new Decimal14f(ONE_UNSCALED / 1000000L);
        BILLIONTH = new Decimal14f(ONE_UNSCALED / 1000000000L);
        TRILLIONTH = new Decimal14f(ONE_UNSCALED / 1000000000000L);
        MAX_VALUE = new Decimal14f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal14f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal14f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal14f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

