/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable16f;
import org.decimal4j.factory.Factory16f;
import org.decimal4j.mutable.MutableDecimal16f;
import org.decimal4j.scale.Scale16f;

public final class Decimal16f
extends AbstractImmutableDecimal<Scale16f, Decimal16f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 16;
    public static final Scale16f METRICS = Scale16f.INSTANCE;
    public static final Factory16f FACTORY = Factory16f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal16f ZERO = new Decimal16f(0L);
    public static final Decimal16f ULP = new Decimal16f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal16f[] POS_CONST = new Decimal16f[11];
    private static final Decimal16f[] NEG_CONST = new Decimal16f[11];
    public static final Decimal16f ONE;
    public static final Decimal16f TWO;
    public static final Decimal16f THREE;
    public static final Decimal16f FOUR;
    public static final Decimal16f FIVE;
    public static final Decimal16f SIX;
    public static final Decimal16f SEVEN;
    public static final Decimal16f EIGHT;
    public static final Decimal16f NINE;
    public static final Decimal16f TEN;
    public static final Decimal16f HUNDRED;
    public static final Decimal16f MINUS_ONE;
    public static final Decimal16f HALF;
    public static final Decimal16f TENTH;
    public static final Decimal16f HUNDREDTH;
    public static final Decimal16f THOUSANDTH;
    public static final Decimal16f MILLIONTH;
    public static final Decimal16f BILLIONTH;
    public static final Decimal16f TRILLIONTH;
    public static final Decimal16f QUADRILLIONTH;
    public static final Decimal16f MAX_VALUE;
    public static final Decimal16f MAX_INTEGER_VALUE;
    public static final Decimal16f MIN_VALUE;
    public static final Decimal16f MIN_INTEGER_VALUE;

    private Decimal16f(long unscaled) {
        super(unscaled);
    }

    public Decimal16f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale16f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 16;
    }

    public final Factory16f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal16f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal16f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal16f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal16f valueOf(float value) {
        return Decimal16f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal16f valueOf(float value, RoundingMode roundingMode) {
        return Decimal16f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal16f valueOf(double value) {
        return Decimal16f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal16f valueOf(double value, RoundingMode roundingMode) {
        return Decimal16f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal16f valueOf(BigInteger value) {
        return Decimal16f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal16f valueOf(BigDecimal value) {
        return Decimal16f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal16f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal16f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal16f valueOf(Decimal<?> value) {
        if (value instanceof Decimal16f) {
            return (Decimal16f)value;
        }
        return Decimal16f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal16f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal16f) {
            return (Decimal16f)value;
        }
        return Decimal16f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal16f valueOf(String value) {
        return Decimal16f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal16f valueOf(String value, RoundingMode roundingMode) {
        return Decimal16f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal16f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal16f(unscaledValue);
    }

    public static Decimal16f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal16f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal16f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal16f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal16f createOrAssign(long unscaled) {
        return Decimal16f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal16f create(long unscaled) {
        return Decimal16f.valueOfUnscaled(unscaled);
    }

    protected Decimal16f[] createArray(int length) {
        return new Decimal16f[length];
    }

    public Multipliable16f multiplyExact() {
        return new Multipliable16f(this);
    }

    public MutableDecimal16f toMutableDecimal() {
        return new MutableDecimal16f(this);
    }

    public Decimal16f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal16f.POS_CONST[i] = new Decimal16f(ONE_UNSCALED * (long)i);
            Decimal16f.NEG_CONST[i] = new Decimal16f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal16f.valueOf(1L);
        TWO = Decimal16f.valueOf(2L);
        THREE = Decimal16f.valueOf(3L);
        FOUR = Decimal16f.valueOf(4L);
        FIVE = Decimal16f.valueOf(5L);
        SIX = Decimal16f.valueOf(6L);
        SEVEN = Decimal16f.valueOf(7L);
        EIGHT = Decimal16f.valueOf(8L);
        NINE = Decimal16f.valueOf(9L);
        TEN = Decimal16f.valueOf(10L);
        HUNDRED = new Decimal16f(100L * ONE_UNSCALED);
        MINUS_ONE = Decimal16f.valueOf(-1L);
        HALF = new Decimal16f(ONE_UNSCALED / 2L);
        TENTH = new Decimal16f(ONE_UNSCALED / 10L);
        HUNDREDTH = new Decimal16f(ONE_UNSCALED / 100L);
        THOUSANDTH = new Decimal16f(ONE_UNSCALED / 1000L);
        MILLIONTH = new Decimal16f(ONE_UNSCALED / 1000000L);
        BILLIONTH = new Decimal16f(ONE_UNSCALED / 1000000000L);
        TRILLIONTH = new Decimal16f(ONE_UNSCALED / 1000000000000L);
        QUADRILLIONTH = new Decimal16f(ONE_UNSCALED / 1000000000000000L);
        MAX_VALUE = new Decimal16f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal16f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal16f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal16f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

