/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable17f;
import org.decimal4j.factory.Factory17f;
import org.decimal4j.mutable.MutableDecimal17f;
import org.decimal4j.scale.Scale17f;

public final class Decimal17f
extends AbstractImmutableDecimal<Scale17f, Decimal17f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 17;
    public static final Scale17f METRICS = Scale17f.INSTANCE;
    public static final Factory17f FACTORY = Factory17f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal17f ZERO = new Decimal17f(0L);
    public static final Decimal17f ULP = new Decimal17f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal17f[] POS_CONST = new Decimal17f[11];
    private static final Decimal17f[] NEG_CONST = new Decimal17f[11];
    public static final Decimal17f ONE;
    public static final Decimal17f TWO;
    public static final Decimal17f THREE;
    public static final Decimal17f FOUR;
    public static final Decimal17f FIVE;
    public static final Decimal17f SIX;
    public static final Decimal17f SEVEN;
    public static final Decimal17f EIGHT;
    public static final Decimal17f NINE;
    public static final Decimal17f TEN;
    public static final Decimal17f MINUS_ONE;
    public static final Decimal17f HALF;
    public static final Decimal17f TENTH;
    public static final Decimal17f HUNDREDTH;
    public static final Decimal17f THOUSANDTH;
    public static final Decimal17f MILLIONTH;
    public static final Decimal17f BILLIONTH;
    public static final Decimal17f TRILLIONTH;
    public static final Decimal17f QUADRILLIONTH;
    public static final Decimal17f MAX_VALUE;
    public static final Decimal17f MAX_INTEGER_VALUE;
    public static final Decimal17f MIN_VALUE;
    public static final Decimal17f MIN_INTEGER_VALUE;

    private Decimal17f(long unscaled) {
        super(unscaled);
    }

    public Decimal17f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale17f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 17;
    }

    public final Factory17f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal17f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal17f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal17f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal17f valueOf(float value) {
        return Decimal17f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal17f valueOf(float value, RoundingMode roundingMode) {
        return Decimal17f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal17f valueOf(double value) {
        return Decimal17f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal17f valueOf(double value, RoundingMode roundingMode) {
        return Decimal17f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal17f valueOf(BigInteger value) {
        return Decimal17f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal17f valueOf(BigDecimal value) {
        return Decimal17f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal17f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal17f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal17f valueOf(Decimal<?> value) {
        if (value instanceof Decimal17f) {
            return (Decimal17f)value;
        }
        return Decimal17f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal17f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal17f) {
            return (Decimal17f)value;
        }
        return Decimal17f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal17f valueOf(String value) {
        return Decimal17f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal17f valueOf(String value, RoundingMode roundingMode) {
        return Decimal17f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal17f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal17f(unscaledValue);
    }

    public static Decimal17f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal17f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal17f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal17f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal17f createOrAssign(long unscaled) {
        return Decimal17f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal17f create(long unscaled) {
        return Decimal17f.valueOfUnscaled(unscaled);
    }

    protected Decimal17f[] createArray(int length) {
        return new Decimal17f[length];
    }

    public Multipliable17f multiplyExact() {
        return new Multipliable17f(this);
    }

    public MutableDecimal17f toMutableDecimal() {
        return new MutableDecimal17f(this);
    }

    public Decimal17f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal17f.POS_CONST[i] = new Decimal17f(ONE_UNSCALED * (long)i);
            Decimal17f.NEG_CONST[i] = new Decimal17f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal17f.valueOf(1L);
        TWO = Decimal17f.valueOf(2L);
        THREE = Decimal17f.valueOf(3L);
        FOUR = Decimal17f.valueOf(4L);
        FIVE = Decimal17f.valueOf(5L);
        SIX = Decimal17f.valueOf(6L);
        SEVEN = Decimal17f.valueOf(7L);
        EIGHT = Decimal17f.valueOf(8L);
        NINE = Decimal17f.valueOf(9L);
        TEN = Decimal17f.valueOf(10L);
        MINUS_ONE = Decimal17f.valueOf(-1L);
        HALF = new Decimal17f(ONE_UNSCALED / 2L);
        TENTH = new Decimal17f(ONE_UNSCALED / 10L);
        HUNDREDTH = new Decimal17f(ONE_UNSCALED / 100L);
        THOUSANDTH = new Decimal17f(ONE_UNSCALED / 1000L);
        MILLIONTH = new Decimal17f(ONE_UNSCALED / 1000000L);
        BILLIONTH = new Decimal17f(ONE_UNSCALED / 1000000000L);
        TRILLIONTH = new Decimal17f(ONE_UNSCALED / 1000000000000L);
        QUADRILLIONTH = new Decimal17f(ONE_UNSCALED / 1000000000000000L);
        MAX_VALUE = new Decimal17f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal17f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal17f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal17f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

