/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable18f;
import org.decimal4j.factory.Factory18f;
import org.decimal4j.mutable.MutableDecimal18f;
import org.decimal4j.scale.Scale18f;

public final class Decimal18f
extends AbstractImmutableDecimal<Scale18f, Decimal18f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 18;
    public static final Scale18f METRICS = Scale18f.INSTANCE;
    public static final Factory18f FACTORY = Factory18f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal18f ZERO = new Decimal18f(0L);
    public static final Decimal18f ULP = new Decimal18f(1L);
    private static final int MAX_CONSTANT = 9;
    private static final Decimal18f[] POS_CONST = new Decimal18f[10];
    private static final Decimal18f[] NEG_CONST = new Decimal18f[10];
    public static final Decimal18f ONE;
    public static final Decimal18f TWO;
    public static final Decimal18f THREE;
    public static final Decimal18f FOUR;
    public static final Decimal18f FIVE;
    public static final Decimal18f SIX;
    public static final Decimal18f SEVEN;
    public static final Decimal18f EIGHT;
    public static final Decimal18f NINE;
    public static final Decimal18f MINUS_ONE;
    public static final Decimal18f HALF;
    public static final Decimal18f TENTH;
    public static final Decimal18f HUNDREDTH;
    public static final Decimal18f THOUSANDTH;
    public static final Decimal18f MILLIONTH;
    public static final Decimal18f BILLIONTH;
    public static final Decimal18f TRILLIONTH;
    public static final Decimal18f QUADRILLIONTH;
    public static final Decimal18f QUINTILLIONTH;
    public static final Decimal18f MAX_VALUE;
    public static final Decimal18f MAX_INTEGER_VALUE;
    public static final Decimal18f MIN_VALUE;
    public static final Decimal18f MIN_INTEGER_VALUE;

    private Decimal18f(long unscaled) {
        super(unscaled);
    }

    public Decimal18f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale18f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 18;
    }

    public final Factory18f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal18f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal18f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 9L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -9L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal18f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal18f valueOf(float value) {
        return Decimal18f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal18f valueOf(float value, RoundingMode roundingMode) {
        return Decimal18f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal18f valueOf(double value) {
        return Decimal18f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal18f valueOf(double value, RoundingMode roundingMode) {
        return Decimal18f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal18f valueOf(BigInteger value) {
        return Decimal18f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal18f valueOf(BigDecimal value) {
        return Decimal18f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal18f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal18f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal18f valueOf(Decimal<?> value) {
        if (value instanceof Decimal18f) {
            return (Decimal18f)value;
        }
        return Decimal18f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal18f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal18f) {
            return (Decimal18f)value;
        }
        return Decimal18f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal18f valueOf(String value) {
        return Decimal18f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal18f valueOf(String value, RoundingMode roundingMode) {
        return Decimal18f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal18f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal18f(unscaledValue);
    }

    public static Decimal18f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal18f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal18f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal18f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal18f createOrAssign(long unscaled) {
        return Decimal18f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal18f create(long unscaled) {
        return Decimal18f.valueOfUnscaled(unscaled);
    }

    protected Decimal18f[] createArray(int length) {
        return new Decimal18f[length];
    }

    public Multipliable18f multiplyExact() {
        return new Multipliable18f(this);
    }

    public MutableDecimal18f toMutableDecimal() {
        return new MutableDecimal18f(this);
    }

    public Decimal18f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 9; ++i) {
            Decimal18f.POS_CONST[i] = new Decimal18f(ONE_UNSCALED * (long)i);
            Decimal18f.NEG_CONST[i] = new Decimal18f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal18f.valueOf(1L);
        TWO = Decimal18f.valueOf(2L);
        THREE = Decimal18f.valueOf(3L);
        FOUR = Decimal18f.valueOf(4L);
        FIVE = Decimal18f.valueOf(5L);
        SIX = Decimal18f.valueOf(6L);
        SEVEN = Decimal18f.valueOf(7L);
        EIGHT = Decimal18f.valueOf(8L);
        NINE = Decimal18f.valueOf(9L);
        MINUS_ONE = Decimal18f.valueOf(-1L);
        HALF = new Decimal18f(ONE_UNSCALED / 2L);
        TENTH = new Decimal18f(ONE_UNSCALED / 10L);
        HUNDREDTH = new Decimal18f(ONE_UNSCALED / 100L);
        THOUSANDTH = new Decimal18f(ONE_UNSCALED / 1000L);
        MILLIONTH = new Decimal18f(ONE_UNSCALED / 1000000L);
        BILLIONTH = new Decimal18f(ONE_UNSCALED / 1000000000L);
        TRILLIONTH = new Decimal18f(ONE_UNSCALED / 1000000000000L);
        QUADRILLIONTH = new Decimal18f(ONE_UNSCALED / 1000000000000000L);
        QUINTILLIONTH = new Decimal18f(ONE_UNSCALED / 1000000000000000000L);
        MAX_VALUE = new Decimal18f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal18f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal18f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal18f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

