/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable3f;
import org.decimal4j.factory.Factory3f;
import org.decimal4j.mutable.MutableDecimal3f;
import org.decimal4j.scale.Scale3f;

public final class Decimal3f
extends AbstractImmutableDecimal<Scale3f, Decimal3f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 3;
    public static final Scale3f METRICS = Scale3f.INSTANCE;
    public static final Factory3f FACTORY = Factory3f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal3f ZERO = new Decimal3f(0L);
    public static final Decimal3f ULP = new Decimal3f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal3f[] POS_CONST = new Decimal3f[11];
    private static final Decimal3f[] NEG_CONST = new Decimal3f[11];
    public static final Decimal3f ONE;
    public static final Decimal3f TWO;
    public static final Decimal3f THREE;
    public static final Decimal3f FOUR;
    public static final Decimal3f FIVE;
    public static final Decimal3f SIX;
    public static final Decimal3f SEVEN;
    public static final Decimal3f EIGHT;
    public static final Decimal3f NINE;
    public static final Decimal3f TEN;
    public static final Decimal3f HUNDRED;
    public static final Decimal3f THOUSAND;
    public static final Decimal3f MILLION;
    public static final Decimal3f BILLION;
    public static final Decimal3f TRILLION;
    public static final Decimal3f QUADRILLION;
    public static final Decimal3f MINUS_ONE;
    public static final Decimal3f HALF;
    public static final Decimal3f TENTH;
    public static final Decimal3f HUNDREDTH;
    public static final Decimal3f THOUSANDTH;
    public static final Decimal3f MAX_VALUE;
    public static final Decimal3f MAX_INTEGER_VALUE;
    public static final Decimal3f MIN_VALUE;
    public static final Decimal3f MIN_INTEGER_VALUE;

    private Decimal3f(long unscaled) {
        super(unscaled);
    }

    public Decimal3f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale3f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 3;
    }

    public final Factory3f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal3f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal3f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal3f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal3f valueOf(float value) {
        return Decimal3f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal3f valueOf(float value, RoundingMode roundingMode) {
        return Decimal3f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal3f valueOf(double value) {
        return Decimal3f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal3f valueOf(double value, RoundingMode roundingMode) {
        return Decimal3f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal3f valueOf(BigInteger value) {
        return Decimal3f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal3f valueOf(BigDecimal value) {
        return Decimal3f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal3f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal3f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal3f valueOf(Decimal<?> value) {
        if (value instanceof Decimal3f) {
            return (Decimal3f)value;
        }
        return Decimal3f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal3f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal3f) {
            return (Decimal3f)value;
        }
        return Decimal3f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal3f valueOf(String value) {
        return Decimal3f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal3f valueOf(String value, RoundingMode roundingMode) {
        return Decimal3f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal3f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal3f(unscaledValue);
    }

    public static Decimal3f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal3f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal3f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal3f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal3f createOrAssign(long unscaled) {
        return Decimal3f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal3f create(long unscaled) {
        return Decimal3f.valueOfUnscaled(unscaled);
    }

    protected Decimal3f[] createArray(int length) {
        return new Decimal3f[length];
    }

    public Multipliable3f multiplyExact() {
        return new Multipliable3f(this);
    }

    public MutableDecimal3f toMutableDecimal() {
        return new MutableDecimal3f(this);
    }

    public Decimal3f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal3f.POS_CONST[i] = new Decimal3f(ONE_UNSCALED * (long)i);
            Decimal3f.NEG_CONST[i] = new Decimal3f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal3f.valueOf(1L);
        TWO = Decimal3f.valueOf(2L);
        THREE = Decimal3f.valueOf(3L);
        FOUR = Decimal3f.valueOf(4L);
        FIVE = Decimal3f.valueOf(5L);
        SIX = Decimal3f.valueOf(6L);
        SEVEN = Decimal3f.valueOf(7L);
        EIGHT = Decimal3f.valueOf(8L);
        NINE = Decimal3f.valueOf(9L);
        TEN = Decimal3f.valueOf(10L);
        HUNDRED = new Decimal3f(100L * ONE_UNSCALED);
        THOUSAND = new Decimal3f(1000L * ONE_UNSCALED);
        MILLION = new Decimal3f(1000000L * ONE_UNSCALED);
        BILLION = new Decimal3f(1000000000L * ONE_UNSCALED);
        TRILLION = new Decimal3f(1000000000000L * ONE_UNSCALED);
        QUADRILLION = new Decimal3f(1000000000000000L * ONE_UNSCALED);
        MINUS_ONE = Decimal3f.valueOf(-1L);
        HALF = new Decimal3f(ONE_UNSCALED / 2L);
        TENTH = new Decimal3f(ONE_UNSCALED / 10L);
        HUNDREDTH = new Decimal3f(ONE_UNSCALED / 100L);
        THOUSANDTH = new Decimal3f(ONE_UNSCALED / 1000L);
        MAX_VALUE = new Decimal3f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal3f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal3f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal3f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

