/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable4f;
import org.decimal4j.factory.Factory4f;
import org.decimal4j.mutable.MutableDecimal4f;
import org.decimal4j.scale.Scale4f;

public final class Decimal4f
extends AbstractImmutableDecimal<Scale4f, Decimal4f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 4;
    public static final Scale4f METRICS = Scale4f.INSTANCE;
    public static final Factory4f FACTORY = Factory4f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal4f ZERO = new Decimal4f(0L);
    public static final Decimal4f ULP = new Decimal4f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal4f[] POS_CONST = new Decimal4f[11];
    private static final Decimal4f[] NEG_CONST = new Decimal4f[11];
    public static final Decimal4f ONE;
    public static final Decimal4f TWO;
    public static final Decimal4f THREE;
    public static final Decimal4f FOUR;
    public static final Decimal4f FIVE;
    public static final Decimal4f SIX;
    public static final Decimal4f SEVEN;
    public static final Decimal4f EIGHT;
    public static final Decimal4f NINE;
    public static final Decimal4f TEN;
    public static final Decimal4f HUNDRED;
    public static final Decimal4f THOUSAND;
    public static final Decimal4f MILLION;
    public static final Decimal4f BILLION;
    public static final Decimal4f TRILLION;
    public static final Decimal4f MINUS_ONE;
    public static final Decimal4f HALF;
    public static final Decimal4f TENTH;
    public static final Decimal4f HUNDREDTH;
    public static final Decimal4f THOUSANDTH;
    public static final Decimal4f MAX_VALUE;
    public static final Decimal4f MAX_INTEGER_VALUE;
    public static final Decimal4f MIN_VALUE;
    public static final Decimal4f MIN_INTEGER_VALUE;

    private Decimal4f(long unscaled) {
        super(unscaled);
    }

    public Decimal4f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale4f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 4;
    }

    public final Factory4f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal4f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal4f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal4f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal4f valueOf(float value) {
        return Decimal4f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal4f valueOf(float value, RoundingMode roundingMode) {
        return Decimal4f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal4f valueOf(double value) {
        return Decimal4f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal4f valueOf(double value, RoundingMode roundingMode) {
        return Decimal4f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal4f valueOf(BigInteger value) {
        return Decimal4f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal4f valueOf(BigDecimal value) {
        return Decimal4f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal4f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal4f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal4f valueOf(Decimal<?> value) {
        if (value instanceof Decimal4f) {
            return (Decimal4f)value;
        }
        return Decimal4f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal4f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal4f) {
            return (Decimal4f)value;
        }
        return Decimal4f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal4f valueOf(String value) {
        return Decimal4f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal4f valueOf(String value, RoundingMode roundingMode) {
        return Decimal4f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal4f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal4f(unscaledValue);
    }

    public static Decimal4f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal4f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal4f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal4f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal4f createOrAssign(long unscaled) {
        return Decimal4f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal4f create(long unscaled) {
        return Decimal4f.valueOfUnscaled(unscaled);
    }

    protected Decimal4f[] createArray(int length) {
        return new Decimal4f[length];
    }

    public Multipliable4f multiplyExact() {
        return new Multipliable4f(this);
    }

    public MutableDecimal4f toMutableDecimal() {
        return new MutableDecimal4f(this);
    }

    public Decimal4f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal4f.POS_CONST[i] = new Decimal4f(ONE_UNSCALED * (long)i);
            Decimal4f.NEG_CONST[i] = new Decimal4f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal4f.valueOf(1L);
        TWO = Decimal4f.valueOf(2L);
        THREE = Decimal4f.valueOf(3L);
        FOUR = Decimal4f.valueOf(4L);
        FIVE = Decimal4f.valueOf(5L);
        SIX = Decimal4f.valueOf(6L);
        SEVEN = Decimal4f.valueOf(7L);
        EIGHT = Decimal4f.valueOf(8L);
        NINE = Decimal4f.valueOf(9L);
        TEN = Decimal4f.valueOf(10L);
        HUNDRED = new Decimal4f(100L * ONE_UNSCALED);
        THOUSAND = new Decimal4f(1000L * ONE_UNSCALED);
        MILLION = new Decimal4f(1000000L * ONE_UNSCALED);
        BILLION = new Decimal4f(1000000000L * ONE_UNSCALED);
        TRILLION = new Decimal4f(1000000000000L * ONE_UNSCALED);
        MINUS_ONE = Decimal4f.valueOf(-1L);
        HALF = new Decimal4f(ONE_UNSCALED / 2L);
        TENTH = new Decimal4f(ONE_UNSCALED / 10L);
        HUNDREDTH = new Decimal4f(ONE_UNSCALED / 100L);
        THOUSANDTH = new Decimal4f(ONE_UNSCALED / 1000L);
        MAX_VALUE = new Decimal4f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal4f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal4f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal4f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

