/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable6f;
import org.decimal4j.factory.Factory6f;
import org.decimal4j.mutable.MutableDecimal6f;
import org.decimal4j.scale.Scale6f;

public final class Decimal6f
extends AbstractImmutableDecimal<Scale6f, Decimal6f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 6;
    public static final Scale6f METRICS = Scale6f.INSTANCE;
    public static final Factory6f FACTORY = Factory6f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal6f ZERO = new Decimal6f(0L);
    public static final Decimal6f ULP = new Decimal6f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal6f[] POS_CONST = new Decimal6f[11];
    private static final Decimal6f[] NEG_CONST = new Decimal6f[11];
    public static final Decimal6f ONE;
    public static final Decimal6f TWO;
    public static final Decimal6f THREE;
    public static final Decimal6f FOUR;
    public static final Decimal6f FIVE;
    public static final Decimal6f SIX;
    public static final Decimal6f SEVEN;
    public static final Decimal6f EIGHT;
    public static final Decimal6f NINE;
    public static final Decimal6f TEN;
    public static final Decimal6f HUNDRED;
    public static final Decimal6f THOUSAND;
    public static final Decimal6f MILLION;
    public static final Decimal6f BILLION;
    public static final Decimal6f TRILLION;
    public static final Decimal6f MINUS_ONE;
    public static final Decimal6f HALF;
    public static final Decimal6f TENTH;
    public static final Decimal6f HUNDREDTH;
    public static final Decimal6f THOUSANDTH;
    public static final Decimal6f MILLIONTH;
    public static final Decimal6f MAX_VALUE;
    public static final Decimal6f MAX_INTEGER_VALUE;
    public static final Decimal6f MIN_VALUE;
    public static final Decimal6f MIN_INTEGER_VALUE;

    private Decimal6f(long unscaled) {
        super(unscaled);
    }

    public Decimal6f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale6f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 6;
    }

    public final Factory6f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal6f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal6f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal6f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal6f valueOf(float value) {
        return Decimal6f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal6f valueOf(float value, RoundingMode roundingMode) {
        return Decimal6f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal6f valueOf(double value) {
        return Decimal6f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal6f valueOf(double value, RoundingMode roundingMode) {
        return Decimal6f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal6f valueOf(BigInteger value) {
        return Decimal6f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal6f valueOf(BigDecimal value) {
        return Decimal6f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal6f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal6f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal6f valueOf(Decimal<?> value) {
        if (value instanceof Decimal6f) {
            return (Decimal6f)value;
        }
        return Decimal6f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal6f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal6f) {
            return (Decimal6f)value;
        }
        return Decimal6f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal6f valueOf(String value) {
        return Decimal6f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal6f valueOf(String value, RoundingMode roundingMode) {
        return Decimal6f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal6f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal6f(unscaledValue);
    }

    public static Decimal6f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal6f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal6f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal6f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal6f createOrAssign(long unscaled) {
        return Decimal6f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal6f create(long unscaled) {
        return Decimal6f.valueOfUnscaled(unscaled);
    }

    protected Decimal6f[] createArray(int length) {
        return new Decimal6f[length];
    }

    public Multipliable6f multiplyExact() {
        return new Multipliable6f(this);
    }

    public MutableDecimal6f toMutableDecimal() {
        return new MutableDecimal6f(this);
    }

    public Decimal6f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal6f.POS_CONST[i] = new Decimal6f(ONE_UNSCALED * (long)i);
            Decimal6f.NEG_CONST[i] = new Decimal6f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal6f.valueOf(1L);
        TWO = Decimal6f.valueOf(2L);
        THREE = Decimal6f.valueOf(3L);
        FOUR = Decimal6f.valueOf(4L);
        FIVE = Decimal6f.valueOf(5L);
        SIX = Decimal6f.valueOf(6L);
        SEVEN = Decimal6f.valueOf(7L);
        EIGHT = Decimal6f.valueOf(8L);
        NINE = Decimal6f.valueOf(9L);
        TEN = Decimal6f.valueOf(10L);
        HUNDRED = new Decimal6f(100L * ONE_UNSCALED);
        THOUSAND = new Decimal6f(1000L * ONE_UNSCALED);
        MILLION = new Decimal6f(1000000L * ONE_UNSCALED);
        BILLION = new Decimal6f(1000000000L * ONE_UNSCALED);
        TRILLION = new Decimal6f(1000000000000L * ONE_UNSCALED);
        MINUS_ONE = Decimal6f.valueOf(-1L);
        HALF = new Decimal6f(ONE_UNSCALED / 2L);
        TENTH = new Decimal6f(ONE_UNSCALED / 10L);
        HUNDREDTH = new Decimal6f(ONE_UNSCALED / 100L);
        THOUSANDTH = new Decimal6f(ONE_UNSCALED / 1000L);
        MILLIONTH = new Decimal6f(ONE_UNSCALED / 1000000L);
        MAX_VALUE = new Decimal6f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal6f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal6f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal6f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

