/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.immutable;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.base.AbstractImmutableDecimal;
import org.decimal4j.exact.Multipliable7f;
import org.decimal4j.factory.Factory7f;
import org.decimal4j.mutable.MutableDecimal7f;
import org.decimal4j.scale.Scale7f;

public final class Decimal7f
extends AbstractImmutableDecimal<Scale7f, Decimal7f> {
    private static final long serialVersionUID = 1L;
    public static final int SCALE = 7;
    public static final Scale7f METRICS = Scale7f.INSTANCE;
    public static final Factory7f FACTORY = Factory7f.INSTANCE;
    public static final DecimalArithmetic DEFAULT_ARITHMETIC = METRICS.getDefaultArithmetic();
    public static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC = METRICS.getDefaultCheckedArithmetic();
    public static final long ONE_UNSCALED = METRICS.getScaleFactor();
    public static final Decimal7f ZERO = new Decimal7f(0L);
    public static final Decimal7f ULP = new Decimal7f(1L);
    private static final int MAX_CONSTANT = 10;
    private static final Decimal7f[] POS_CONST = new Decimal7f[11];
    private static final Decimal7f[] NEG_CONST = new Decimal7f[11];
    public static final Decimal7f ONE;
    public static final Decimal7f TWO;
    public static final Decimal7f THREE;
    public static final Decimal7f FOUR;
    public static final Decimal7f FIVE;
    public static final Decimal7f SIX;
    public static final Decimal7f SEVEN;
    public static final Decimal7f EIGHT;
    public static final Decimal7f NINE;
    public static final Decimal7f TEN;
    public static final Decimal7f HUNDRED;
    public static final Decimal7f THOUSAND;
    public static final Decimal7f MILLION;
    public static final Decimal7f BILLION;
    public static final Decimal7f MINUS_ONE;
    public static final Decimal7f HALF;
    public static final Decimal7f TENTH;
    public static final Decimal7f HUNDREDTH;
    public static final Decimal7f THOUSANDTH;
    public static final Decimal7f MILLIONTH;
    public static final Decimal7f MAX_VALUE;
    public static final Decimal7f MAX_INTEGER_VALUE;
    public static final Decimal7f MIN_VALUE;
    public static final Decimal7f MIN_INTEGER_VALUE;

    private Decimal7f(long unscaled) {
        super(unscaled);
    }

    public Decimal7f(String value) {
        super(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    @Override
    public final Scale7f getScaleMetrics() {
        return METRICS;
    }

    @Override
    public final int getScale() {
        return 7;
    }

    public final Factory7f getFactory() {
        return FACTORY;
    }

    @Override
    protected final Decimal7f self() {
        return this;
    }

    @Override
    protected final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    protected final DecimalArithmetic getRoundingDownArithmetic() {
        return METRICS.getRoundingDownArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingFloorArithmetic() {
        return METRICS.getRoundingFloorArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return METRICS.getRoundingHalfEvenArithmetic();
    }

    @Override
    protected final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return METRICS.getRoundingUnnecessaryArithmetic();
    }

    public static Decimal7f valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value > 0L & value <= 10L) {
            return POS_CONST[(int)value];
        }
        if (value < 0L & value >= -10L) {
            return NEG_CONST[(int)(-value)];
        }
        return Decimal7f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromLong(value));
    }

    public static Decimal7f valueOf(float value) {
        return Decimal7f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromFloat(value));
    }

    public static Decimal7f valueOf(float value, RoundingMode roundingMode) {
        return Decimal7f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromFloat(value));
    }

    public static Decimal7f valueOf(double value) {
        return Decimal7f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromDouble(value));
    }

    public static Decimal7f valueOf(double value, RoundingMode roundingMode) {
        return Decimal7f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromDouble(value));
    }

    public static Decimal7f valueOf(BigInteger value) {
        return Decimal7f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigInteger(value));
    }

    public static Decimal7f valueOf(BigDecimal value) {
        return Decimal7f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromBigDecimal(value));
    }

    public static Decimal7f valueOf(BigDecimal value, RoundingMode roundingMode) {
        return Decimal7f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromBigDecimal(value));
    }

    public static Decimal7f valueOf(Decimal<?> value) {
        if (value instanceof Decimal7f) {
            return (Decimal7f)value;
        }
        return Decimal7f.valueOfUnscaled(value.unscaledValue(), value.getScale());
    }

    public static Decimal7f valueOf(Decimal<?> value, RoundingMode roundingMode) {
        if (value instanceof Decimal7f) {
            return (Decimal7f)value;
        }
        return Decimal7f.valueOfUnscaled(value.unscaledValue(), value.getScale(), roundingMode);
    }

    public static Decimal7f valueOf(String value) {
        return Decimal7f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.parse(value));
    }

    public static Decimal7f valueOf(String value, RoundingMode roundingMode) {
        return Decimal7f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).parse(value));
    }

    public static Decimal7f valueOfUnscaled(long unscaledValue) {
        if (unscaledValue == 0L) {
            return ZERO;
        }
        if (unscaledValue == 1L) {
            return ULP;
        }
        if (unscaledValue == ONE_UNSCALED) {
            return ONE;
        }
        if (unscaledValue == -ONE_UNSCALED) {
            return MINUS_ONE;
        }
        return new Decimal7f(unscaledValue);
    }

    public static Decimal7f valueOfUnscaled(long unscaledValue, int scale) {
        return Decimal7f.valueOfUnscaled(DEFAULT_CHECKED_ARITHMETIC.fromUnscaled(unscaledValue, scale));
    }

    public static Decimal7f valueOfUnscaled(long unscaledValue, int scale, RoundingMode roundingMode) {
        return Decimal7f.valueOfUnscaled(METRICS.getCheckedArithmetic(roundingMode).fromUnscaled(unscaledValue, scale));
    }

    @Override
    protected Decimal7f createOrAssign(long unscaled) {
        return Decimal7f.valueOfUnscaled(unscaled);
    }

    @Override
    protected Decimal7f create(long unscaled) {
        return Decimal7f.valueOfUnscaled(unscaled);
    }

    protected Decimal7f[] createArray(int length) {
        return new Decimal7f[length];
    }

    public Multipliable7f multiplyExact() {
        return new Multipliable7f(this);
    }

    public MutableDecimal7f toMutableDecimal() {
        return new MutableDecimal7f(this);
    }

    public Decimal7f toImmutableDecimal() {
        return this;
    }

    static {
        for (int i = 1; i <= 10; ++i) {
            Decimal7f.POS_CONST[i] = new Decimal7f(ONE_UNSCALED * (long)i);
            Decimal7f.NEG_CONST[i] = new Decimal7f(-ONE_UNSCALED * (long)i);
        }
        ONE = Decimal7f.valueOf(1L);
        TWO = Decimal7f.valueOf(2L);
        THREE = Decimal7f.valueOf(3L);
        FOUR = Decimal7f.valueOf(4L);
        FIVE = Decimal7f.valueOf(5L);
        SIX = Decimal7f.valueOf(6L);
        SEVEN = Decimal7f.valueOf(7L);
        EIGHT = Decimal7f.valueOf(8L);
        NINE = Decimal7f.valueOf(9L);
        TEN = Decimal7f.valueOf(10L);
        HUNDRED = new Decimal7f(100L * ONE_UNSCALED);
        THOUSAND = new Decimal7f(1000L * ONE_UNSCALED);
        MILLION = new Decimal7f(1000000L * ONE_UNSCALED);
        BILLION = new Decimal7f(1000000000L * ONE_UNSCALED);
        MINUS_ONE = Decimal7f.valueOf(-1L);
        HALF = new Decimal7f(ONE_UNSCALED / 2L);
        TENTH = new Decimal7f(ONE_UNSCALED / 10L);
        HUNDREDTH = new Decimal7f(ONE_UNSCALED / 100L);
        THOUSANDTH = new Decimal7f(ONE_UNSCALED / 1000L);
        MILLIONTH = new Decimal7f(ONE_UNSCALED / 1000000L);
        MAX_VALUE = new Decimal7f(Long.MAX_VALUE);
        MAX_INTEGER_VALUE = new Decimal7f(Long.MAX_VALUE / ONE_UNSCALED * ONE_UNSCALED);
        MIN_VALUE = new Decimal7f(Long.MIN_VALUE);
        MIN_INTEGER_VALUE = new Decimal7f(Long.MIN_VALUE / ONE_UNSCALED * ONE_UNSCALED);
    }
}

