/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.scale;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.CheckedScaleNfRoundingArithmetic;
import org.decimal4j.arithmetic.CheckedScaleNfTruncatingArithmetic;
import org.decimal4j.arithmetic.UncheckedScaleNfRoundingArithmetic;
import org.decimal4j.arithmetic.UncheckedScaleNfTruncatingArithmetic;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.truncate.DecimalRounding;
import org.decimal4j.truncate.OverflowMode;
import org.decimal4j.truncate.TruncationPolicy;

public enum Scale15f implements ScaleMetrics
{
    INSTANCE;

    private static final long LONG_MASK = 0xFFFFFFFFL;
    public static final int SCALE = 15;
    public static final long SCALE_FACTOR = 1000000000000000L;
    private static final int NLZ_SCALE_FACTOR = 14;
    private static final long SCALE_FACTOR_HIGH_BITS = 232830L;
    private static final long SCALE_FACTOR_LOW_BITS = 2764472320L;
    private static final long MAX_INTEGER_VALUE = 9223L;
    private static final long MIN_INTEGER_VALUE = -9223L;
    private static final BigInteger BI_SCALE_FACTOR;
    private static final BigDecimal BD_SCALE_FACTOR;
    private static final DecimalArithmetic[] UNCHECKED_ARITHMETIC;
    private static final DecimalArithmetic[] CHECKED_ARITHMETIC;
    private static final DecimalArithmetic DEFAULT_ARITHMETIC;
    private static final DecimalArithmetic DEFAULT_CHECKED_ARITHMETIC;
    private static final DecimalArithmetic ROUNDING_DOWN_ARITHMETIC;
    private static final DecimalArithmetic ROUNDING_FLOOR_ARITHMETIC;
    private static final DecimalArithmetic ROUNDING_HALF_EVEN_ARITHMETIC;
    private static final DecimalArithmetic ROUNDING_UNNECESSARY_ARITHMETIC;

    private static final DecimalArithmetic[] initArithmetic(OverflowMode overflowMode) {
        boolean checked = overflowMode == OverflowMode.CHECKED;
        DecimalArithmetic[] arith = new DecimalArithmetic[DecimalRounding.VALUES.size()];
        for (DecimalRounding dr : DecimalRounding.VALUES) {
            int index = dr.getRoundingMode().ordinal();
            if (dr == DecimalRounding.DOWN) {
                arith[index] = checked ? new CheckedScaleNfTruncatingArithmetic(INSTANCE) : new UncheckedScaleNfTruncatingArithmetic(INSTANCE);
                continue;
            }
            arith[index] = checked ? new CheckedScaleNfRoundingArithmetic((ScaleMetrics)INSTANCE, dr) : new UncheckedScaleNfRoundingArithmetic((ScaleMetrics)INSTANCE, dr);
        }
        return arith;
    }

    @Override
    public final int getScale() {
        return 15;
    }

    @Override
    public final long getScaleFactor() {
        return 1000000000000000L;
    }

    @Override
    public final int getScaleFactorNumberOfLeadingZeros() {
        return 14;
    }

    @Override
    public final long multiplyByScaleFactor(long factor) {
        return factor * 1000000000000000L;
    }

    @Override
    public final BigInteger getScaleFactorAsBigInteger() {
        return BI_SCALE_FACTOR;
    }

    @Override
    public final BigDecimal getScaleFactorAsBigDecimal() {
        return BD_SCALE_FACTOR;
    }

    @Override
    public final long getMaxIntegerValue() {
        return 9223L;
    }

    @Override
    public final long getMinIntegerValue() {
        return -9223L;
    }

    @Override
    public final boolean isValidIntegerValue(long value) {
        return -9223L <= value & value <= 9223L;
    }

    @Override
    public final long multiplyByScaleFactorExact(long factor) {
        long result = factor * 1000000000000000L;
        if (-9223L <= factor & factor <= 9223L) {
            return result;
        }
        throw new ArithmeticException("Overflow: " + factor + " * " + 1000000000000000L + " = " + result);
    }

    @Override
    public final long mulloByScaleFactor(int factor) {
        return ((long)factor & 0xFFFFFFFFL) * 2764472320L;
    }

    @Override
    public final long mulhiByScaleFactor(int factor) {
        return ((long)factor & 0xFFFFFFFFL) * 232830L;
    }

    @Override
    public final long divideByScaleFactor(long dividend) {
        return dividend / 1000000000000000L;
    }

    @Override
    public final long divideUnsignedByScaleFactor(long unsignedDividend) {
        return (unsignedDividend >>> 1) / 500000000000000L;
    }

    @Override
    public final long moduloByScaleFactor(long dividend) {
        return dividend % 1000000000000000L;
    }

    @Override
    public final String toString(long value) {
        return DEFAULT_ARITHMETIC.toString(value);
    }

    @Override
    public final DecimalArithmetic getDefaultArithmetic() {
        return DEFAULT_ARITHMETIC;
    }

    @Override
    public final DecimalArithmetic getDefaultCheckedArithmetic() {
        return DEFAULT_CHECKED_ARITHMETIC;
    }

    @Override
    public final DecimalArithmetic getRoundingDownArithmetic() {
        return ROUNDING_DOWN_ARITHMETIC;
    }

    @Override
    public final DecimalArithmetic getRoundingFloorArithmetic() {
        return ROUNDING_FLOOR_ARITHMETIC;
    }

    @Override
    public final DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return ROUNDING_HALF_EVEN_ARITHMETIC;
    }

    @Override
    public final DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return ROUNDING_UNNECESSARY_ARITHMETIC;
    }

    @Override
    public final DecimalArithmetic getArithmetic(RoundingMode roundingMode) {
        return UNCHECKED_ARITHMETIC[roundingMode.ordinal()];
    }

    @Override
    public final DecimalArithmetic getCheckedArithmetic(RoundingMode roundingMode) {
        return CHECKED_ARITHMETIC[roundingMode.ordinal()];
    }

    @Override
    public final DecimalArithmetic getArithmetic(TruncationPolicy truncationPolicy) {
        OverflowMode overflow = truncationPolicy.getOverflowMode();
        RoundingMode rounding = truncationPolicy.getRoundingMode();
        return (overflow == OverflowMode.UNCHECKED ? UNCHECKED_ARITHMETIC : CHECKED_ARITHMETIC)[rounding.ordinal()];
    }

    public final String toString() {
        return "Scale15f";
    }

    static {
        BI_SCALE_FACTOR = BigInteger.valueOf(1000000000000000L);
        BD_SCALE_FACTOR = BigDecimal.valueOf(1000000000000000L);
        UNCHECKED_ARITHMETIC = Scale15f.initArithmetic(OverflowMode.UNCHECKED);
        CHECKED_ARITHMETIC = Scale15f.initArithmetic(OverflowMode.CHECKED);
        DEFAULT_ARITHMETIC = UNCHECKED_ARITHMETIC[RoundingMode.HALF_UP.ordinal()];
        DEFAULT_CHECKED_ARITHMETIC = CHECKED_ARITHMETIC[RoundingMode.HALF_UP.ordinal()];
        ROUNDING_DOWN_ARITHMETIC = UNCHECKED_ARITHMETIC[RoundingMode.DOWN.ordinal()];
        ROUNDING_FLOOR_ARITHMETIC = UNCHECKED_ARITHMETIC[RoundingMode.FLOOR.ordinal()];
        ROUNDING_HALF_EVEN_ARITHMETIC = UNCHECKED_ARITHMETIC[RoundingMode.HALF_EVEN.ordinal()];
        ROUNDING_UNNECESSARY_ARITHMETIC = UNCHECKED_ARITHMETIC[RoundingMode.UNNECESSARY.ordinal()];
    }
}

