/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.scale;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.decimal4j.scale.Scale0f;
import org.decimal4j.scale.Scale10f;
import org.decimal4j.scale.Scale11f;
import org.decimal4j.scale.Scale12f;
import org.decimal4j.scale.Scale13f;
import org.decimal4j.scale.Scale14f;
import org.decimal4j.scale.Scale15f;
import org.decimal4j.scale.Scale16f;
import org.decimal4j.scale.Scale17f;
import org.decimal4j.scale.Scale18f;
import org.decimal4j.scale.Scale1f;
import org.decimal4j.scale.Scale2f;
import org.decimal4j.scale.Scale3f;
import org.decimal4j.scale.Scale4f;
import org.decimal4j.scale.Scale5f;
import org.decimal4j.scale.Scale6f;
import org.decimal4j.scale.Scale7f;
import org.decimal4j.scale.Scale8f;
import org.decimal4j.scale.Scale9f;
import org.decimal4j.scale.ScaleMetrics;

public final class Scales {
    private static final ScaleMetrics[] SCALES = new ScaleMetrics[]{Scale0f.INSTANCE, Scale1f.INSTANCE, Scale2f.INSTANCE, Scale3f.INSTANCE, Scale4f.INSTANCE, Scale5f.INSTANCE, Scale6f.INSTANCE, Scale7f.INSTANCE, Scale8f.INSTANCE, Scale9f.INSTANCE, Scale10f.INSTANCE, Scale11f.INSTANCE, Scale12f.INSTANCE, Scale13f.INSTANCE, Scale14f.INSTANCE, Scale15f.INSTANCE, Scale16f.INSTANCE, Scale17f.INSTANCE, Scale18f.INSTANCE};
    public static final List<ScaleMetrics> VALUES = Collections.unmodifiableList(Arrays.asList(SCALES));
    public static final int MIN_SCALE = 0;
    public static final int MAX_SCALE = 18;
    private static final long[] SCALE_FACTORS = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    public static final ScaleMetrics getScaleMetrics(int scale) {
        if (0 <= scale & scale <= 18) {
            return SCALES[scale];
        }
        throw new IllegalArgumentException("illegal scale, must be in [0,18] but was: " + scale);
    }

    public static final ScaleMetrics findByScaleFactor(long scaleFactor) {
        int index = Arrays.binarySearch(SCALE_FACTORS, scaleFactor);
        return index < 0 ? null : VALUES.get(index);
    }

    private Scales() {
    }
}

