/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.truncate;

import java.math.RoundingMode;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.decimal4j.truncate.OverflowMode;
import org.decimal4j.truncate.TruncationPolicy;
import org.decimal4j.truncate.UncheckedRounding;

public enum CheckedRounding implements TruncationPolicy
{
    UP{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.UP;
        }

        @Override
        public final UncheckedRounding toUncheckedRounding() {
            return UncheckedRounding.UP;
        }
    }
    ,
    DOWN{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.DOWN;
        }

        @Override
        public final UncheckedRounding toUncheckedRounding() {
            return UncheckedRounding.DOWN;
        }
    }
    ,
    CEILING{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.CEILING;
        }

        @Override
        public final UncheckedRounding toUncheckedRounding() {
            return UncheckedRounding.CEILING;
        }
    }
    ,
    FLOOR{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.FLOOR;
        }

        @Override
        public final UncheckedRounding toUncheckedRounding() {
            return UncheckedRounding.FLOOR;
        }
    }
    ,
    HALF_UP{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.HALF_UP;
        }

        @Override
        public final UncheckedRounding toUncheckedRounding() {
            return UncheckedRounding.HALF_UP;
        }
    }
    ,
    HALF_DOWN{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.HALF_DOWN;
        }

        @Override
        public final UncheckedRounding toUncheckedRounding() {
            return UncheckedRounding.HALF_DOWN;
        }
    }
    ,
    HALF_EVEN{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.HALF_EVEN;
        }

        @Override
        public final UncheckedRounding toUncheckedRounding() {
            return UncheckedRounding.HALF_EVEN;
        }
    }
    ,
    UNNECESSARY{

        @Override
        public final RoundingMode getRoundingMode() {
            return RoundingMode.UNNECESSARY;
        }

        @Override
        public final UncheckedRounding toUncheckedRounding() {
            return UncheckedRounding.UNNECESSARY;
        }
    };

    public static final Set<CheckedRounding> VALUES;

    @Override
    public final OverflowMode getOverflowMode() {
        return OverflowMode.CHECKED;
    }

    public abstract UncheckedRounding toUncheckedRounding();

    public final String toString() {
        return "CHECKED/" + this.name();
    }

    public static final CheckedRounding valueOf(RoundingMode roundingMode) {
        return ByRoundingMode.VALUES_BY_ROUNDING_MODE_ORDINAL[roundingMode.ordinal()];
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(CheckedRounding.class));
    }

    private static class ByRoundingMode {
        private static final CheckedRounding[] VALUES_BY_ROUNDING_MODE_ORDINAL = ByRoundingMode.sortByRoundingModeOrdinal();

        private ByRoundingMode() {
        }

        private static final CheckedRounding[] sortByRoundingModeOrdinal() {
            CheckedRounding[] sorted = new CheckedRounding[VALUES.size()];
            Iterator<CheckedRounding> i$ = VALUES.iterator();
            while (i$.hasNext()) {
                CheckedRounding dr;
                sorted[dr.getRoundingMode().ordinal()] = dr = i$.next();
            }
            return sorted;
        }
    }
}

