/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import kd.bos.script.jsengine.def.KDyWrapper;
import kd.bos.util.resource.Resources;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.KInterfaceDefaultMethodInvoker;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ObjectConverter;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.VMBridge;
import org.mozilla.javascript.VMBridge_custom;
import org.mozilla.javascript.WrapFactory;

public class InterfaceAdapter {
    private final Object proxyHelper;

    static Object create(Context cx, Class<?> cl, ScriptableObject object) {
        if (!cl.isInterface()) {
            throw new IllegalArgumentException();
        }
        Scriptable topScope = ScriptRuntime.getTopCallScope(cx);
        ClassCache cache = ClassCache.get(topScope);
        InterfaceAdapter adapter = (InterfaceAdapter)cache.getInterfaceAdapter(cl);
        ContextFactory cf = cx.getFactory();
        if (adapter == null) {
            Method[] methods = cl.getMethods();
            if (object instanceof Callable) {
                int length = methods.length;
                if (length == 0) {
                    throw Context.reportRuntimeError1("msg.no.empty.interface.conversion", cl.getName());
                }
                if (length > 1) {
                    String methodName = methods[0].getName();
                    for (int i = 1; i < length; ++i) {
                        if (methodName.equals(methods[i].getName())) continue;
                        throw Context.reportRuntimeError1("msg.no.function.interface.conversion", cl.getName());
                    }
                }
            }
            adapter = new InterfaceAdapter(cf, cl);
            cache.cacheInterfaceAdapter(cl, adapter);
        }
        return VMBridge.instance.newInterfaceProxy(adapter.proxyHelper, cf, adapter, object, topScope);
    }

    private InterfaceAdapter(ContextFactory cf, Class<?> cl) {
        this.proxyHelper = VMBridge.instance.getInterfaceProxyHelper(cf, new Class[]{cl});
    }

    public Object invoke(ContextFactory cf, final Object target, final Scriptable topScope, final Object thisObject, final Method method, final Object[] args) {
        ContextAction action = new ContextAction(){

            @Override
            public Object run(Context cx) {
                return InterfaceAdapter.this.invokeImpl(cx, target, topScope, thisObject, method, args);
            }
        };
        return cf.call(action);
    }

    Object invokeImpl(Context cx, Object target, Scriptable topScope, Object thisObject, Method method, Object[] args) {
        Scriptable prototype;
        Callable function;
        boolean functionAdaptFromJava = false;
        if (target instanceof Callable) {
            function = (Callable)target;
        } else {
            Scriptable targetScriptable = (Scriptable)target;
            String methodName = method.getName();
            Object value = targetScriptable.get(methodName, targetScriptable);
            if (value instanceof NativeFunction) {
                int len;
                NativeFunction func = (NativeFunction)value;
                int n = len = args == null ? 0 : args.length;
                if (func.getArity() != len && method.isDefault()) {
                    value = ScriptableObject.NOT_FOUND;
                }
            }
            if (value == ScriptableObject.NOT_FOUND) {
                if (!method.isDefault()) {
                    if (value == ScriptableObject.NOT_FOUND) {
                        value = ScriptableObject.getProperty(targetScriptable, methodName);
                        functionAdaptFromJava = true;
                    }
                    if (value == ScriptableObject.NOT_FOUND) {
                        throw new RuntimeException(Resources.getString((String)"\u63a5\u53e3\u65b9\u6cd5\u672a\u5b9e\u73b0\uff1a", (String)"InterfaceAdapter_0", (String)"bos-serverscript", (Object[])new Object[0]) + method.getDeclaringClass().getName() + "#" + method.getName() + Resources.getString((String)"(\u53c2\u6570=", (String)"InterfaceAdapter_1", (String)"bos-serverscript", (Object[])new Object[0]) + (args == null ? 0 : args.length) + "), this=" + thisObject + ", target=" + target);
                    }
                } else {
                    try {
                        Object ret = KInterfaceDefaultMethodInvoker.invokeDefaultMethod(thisObject, method, args);
                        Class<?> resultType = method.getReturnType();
                        if (resultType == Void.TYPE) {
                            return null;
                        }
                        return Context.jsToJava(ret, resultType);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(Resources.getString((String)"\u63a5\u53e3\u7f3a\u7701\u65b9\u6cd5\u8c03\u7528\u9519\u8bef\uff1a", (String)"InterfaceAdapter_2", (String)"bos-serverscript", (Object[])new Object[0]) + e.getMessage(), e);
                    }
                }
            }
            if (!(value instanceof Callable)) {
                throw Context.reportRuntimeError1("msg.not.function.interface", methodName);
            }
            function = (Callable)value;
        }
        WrapFactory wf = cx.getWrapFactory();
        if (args == null) {
            args = ScriptRuntime.emptyArgs;
        } else {
            int N = args.length;
            for (int i = 0; i != N; ++i) {
                Object arg = args[i];
                if (arg instanceof String || arg instanceof Number || arg instanceof Boolean) continue;
                args[i] = wf.wrap(cx, topScope, arg, null);
            }
        }
        Scriptable thisObj = Proxy.isProxyClass(thisObject.getClass()) ? (Scriptable)VMBridge_custom.getInterfaceProxyTarget(thisObject) : wf.wrapAsJavaObject(cx, topScope, thisObject, null);
        if (functionAdaptFromJava && (prototype = thisObj.getPrototype()) instanceof KDyWrapper) {
            Class beanCls = ((KDyWrapper)prototype).getNativeClass();
            String beanClsName = beanCls.getName();
            StackTraceElement[] sts = Thread.currentThread().getStackTrace();
            int n = sts.length;
            for (int i = 8; i < n; ++i) {
                StackTraceElement st = sts[i];
                String callerClassName = st.getClassName();
                String callerMethod = st.getMethodName();
                if (callerClassName.equals(beanClsName) && callerMethod.equals(method.getName()) && args.length == method.getParameterCount()) {
                    return ObjectConverter.convert(null, method.getReturnType());
                }
                if (callerClassName.equals("org.mozilla.javascript.ScriptRuntime") && callerMethod.equals("doTopCall")) break;
            }
        }
        Object result = function.call(cx, topScope, thisObj, args);
        Class<?> javaResultType = method.getReturnType();
        if (javaResultType == Void.TYPE) {
            result = null;
        } else {
            if (result == Scriptable.NOT_FOUND || result == Undefined.instance) {
                return null;
            }
            result = Context.jsToJava(result, javaResultType);
        }
        return result;
    }
}

