/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import kd.bos.util.JavaVersion;

public class KInterfaceDefaultMethodInvoker {
    public static Object invokeDefaultMethod(Method method, Object[] args) throws Throwable {
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{method.getDeclaringClass()}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        });
        return KInterfaceDefaultMethodInvoker.invokeDefaultMethod(proxy, method, args);
    }

    public static Object invokeDefaultMethod(Object proxy, Method method, Object[] args) throws Throwable {
        if (JavaVersion.isJava17OrLater()) {
            return KInterfaceDefaultMethodInvoker.invokeDefaultMethod17OrLater(proxy, method, args);
        }
        return KInterfaceDefaultMethodInvoker.invokeDefaultMethod8(proxy, method, args);
    }

    private static Object invokeDefaultMethod17OrLater(Object proxy, Method method, Object[] args) throws Throwable {
        Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Class.class, Integer.TYPE);
        constructor.setAccessible(true);
        Class<?> declaringClass = method.getDeclaringClass();
        int allModes = 15;
        return ((MethodHandles.Lookup)constructor.newInstance(declaringClass, null, allModes)).unreflectSpecial(method, declaringClass).bindTo(proxy).invokeWithArguments(args);
    }

    private static Object invokeDefaultMethod8(Object proxy, Method method, Object[] args) throws Throwable {
        Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
        constructor.setAccessible(true);
        Class<?> declaringClass = method.getDeclaringClass();
        int allModes = 15;
        return ((MethodHandles.Lookup)constructor.newInstance(declaringClass, allModes)).unreflectSpecial(method, declaringClass).bindTo(proxy).invokeWithArguments(args);
    }
}

