/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Field;
import kd.bos.script.ScriptException;
import kd.bos.script.ScriptTracker;
import kd.bos.script.jsengine.KRuntime;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.VMBridge;
import org.mozilla.javascript.VMBridge_custom;

public class KVMBridge {
    private static Field enterCount;

    private KVMBridge() {
    }

    public static int getEnterCount() {
        Object helper = VMBridge.instance.getThreadContextHelper();
        Context cx = VMBridge.instance.getContext(helper);
        try {
            return cx == null ? 0 : enterCount.getInt(cx);
        }
        catch (Exception e) {
            throw KRuntime.wrapRuntimeException((Throwable)e);
        }
    }

    public static void doExist() {
        Object helper = VMBridge.instance.getThreadContextHelper();
        Context cx = VMBridge.instance.getContext(helper);
        KVMBridge._doExit(cx, helper);
    }

    public static void doExist(Thread ctxThread) {
        VMBridge_custom custom = (VMBridge_custom)VMBridge.instance;
        Object helper = custom.getThreadContextHelper(ctxThread);
        Context cx = custom.getContext(ctxThread);
        KVMBridge._doExit(cx, helper);
    }

    private static void _doExit(Context cx, Object helper) {
        if (cx != null) {
            try {
                enterCount.set(cx, 0);
            }
            catch (Exception e) {
                throw new ScriptException((Throwable)e);
            }
            cx.getFactory().onContextReleased(cx);
            ScriptTracker.track((String)("KVMBridge _doExit cx=" + KVMBridge.getEnterCount() + ", " + cx));
            VMBridge.instance.setContext(helper, null);
        }
    }

    static {
        try {
            enterCount = Context.class.getDeclaredField("enterCount");
            enterCount.setAccessible(true);
        }
        catch (Exception e) {
            throw new ScriptException((Throwable)e);
        }
    }
}

