/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.EnumMap;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class TopLevel
extends IdScriptableObject {
    static final long serialVersionUID = -4648046356662472260L;
    private EnumMap<Builtins, BaseFunction> ctors;
    private EnumMap<NativeErrors, BaseFunction> errors;

    @Override
    public String getClassName() {
        return "global";
    }

    public void cacheBuiltins() {
        Object value;
        this.ctors = new EnumMap(Builtins.class);
        Enum[] enumArray = Builtins.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Builtins builtin = enumArray[n2];
            value = ScriptableObject.getProperty((Scriptable)this, builtin.name());
            if (value instanceof BaseFunction) {
                this.ctors.put(builtin, (BaseFunction)value);
            }
            ++n2;
        }
        this.errors = new EnumMap(NativeErrors.class);
        enumArray = NativeErrors.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum error = enumArray[n2];
            value = ScriptableObject.getProperty((Scriptable)this, error.name());
            if (value instanceof BaseFunction) {
                this.errors.put((NativeErrors)error, (BaseFunction)value);
            }
            ++n2;
        }
    }

    public static Function getBuiltinCtor(Context cx, Scriptable scope, Builtins type) {
        BaseFunction result;
        assert (scope.getParentScope() == null);
        if (scope instanceof TopLevel && (result = ((TopLevel)scope).getBuiltinCtor(type)) != null) {
            return result;
        }
        return ScriptRuntime.getExistingCtor(cx, scope, type.name());
    }

    static Function getNativeErrorCtor(Context cx, Scriptable scope, NativeErrors type) {
        BaseFunction result;
        assert (scope.getParentScope() == null);
        if (scope instanceof TopLevel && (result = ((TopLevel)scope).getNativeErrorCtor(type)) != null) {
            return result;
        }
        return ScriptRuntime.getExistingCtor(cx, scope, type.name());
    }

    public static Scriptable getBuiltinPrototype(Scriptable scope, Builtins type) {
        Scriptable result;
        assert (scope.getParentScope() == null);
        if (scope instanceof TopLevel && (result = ((TopLevel)scope).getBuiltinPrototype(type)) != null) {
            return result;
        }
        return ScriptableObject.getClassPrototype(scope, type.name());
    }

    public BaseFunction getBuiltinCtor(Builtins type) {
        return this.ctors != null ? this.ctors.get((Object)type) : null;
    }

    BaseFunction getNativeErrorCtor(NativeErrors type) {
        return this.errors != null ? this.errors.get((Object)type) : null;
    }

    public Scriptable getBuiltinPrototype(Builtins type) {
        BaseFunction func = this.getBuiltinCtor(type);
        Object proto = func != null ? func.getPrototypeProperty() : null;
        return proto instanceof Scriptable ? (Scriptable)proto : null;
    }

    public static enum Builtins {
        Object,
        Array,
        Function,
        String,
        Number,
        Boolean,
        RegExp,
        Error;

    }

    static enum NativeErrors {
        Error,
        EvalError,
        RangeError,
        ReferenceError,
        SyntaxError,
        TypeError,
        URIError,
        InternalError,
        JavaException;

    }
}

