/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.InterfaceAdapter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.jdk15.VMBridge_jdk15;

public class VMBridge_custom
extends VMBridge_jdk15 {
    public static Object getInterfaceProxyTarget(Object interfaceProxy) {
        try {
            return Proxy.getInvocationHandler(interfaceProxy).invoke(null, null, null);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object newInterfaceProxy(Object proxyHelper, final ContextFactory cf, final InterfaceAdapter adapter, final Object target, final Scriptable topScope) {
        Object proxy;
        Constructor c = (Constructor)proxyHelper;
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                if (method == null) {
                    return target;
                }
                if (method.getDeclaringClass() == Object.class) {
                    String methodName = method.getName();
                    if (methodName.equals("equals")) {
                        Object other = args[0];
                        return proxy == other;
                    }
                    if (methodName.equals("hashCode")) {
                        return target.hashCode();
                    }
                    if (methodName.equals("toString")) {
                        return "Proxy[" + target.toString() + "]";
                    }
                }
                if (args != null && args.length == 1 && args[0].getClass() == Object[].class && method.getParameterCount() == 1 && method.getParameterTypes()[0] == Object[].class) {
                    args = (Object[])args[0];
                }
                return adapter.invoke(cf, target, topScope, proxy, method, args);
            }
        };
        try {
            proxy = c.newInstance(handler);
        }
        catch (InvocationTargetException ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
        catch (IllegalAccessException ex) {
            throw Kit.initCause(new IllegalStateException(), ex);
        }
        catch (InstantiationException ex) {
            throw Kit.initCause(new IllegalStateException(), ex);
        }
        return proxy;
    }

    public Object getThreadContextHelper(Thread t) {
        return this.contextLocal.get(t);
    }

    public Context getContext(Thread t) {
        Object contextHelper = this.getThreadContextHelper(t);
        return contextHelper == null ? null : this.getContext(contextHelper);
    }
}

