/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.math.BigDecimal;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class NumberLiteral
extends AstNode {
    private String value;
    private BigDecimal number;

    public NumberLiteral() {
        this.type = 40;
    }

    public NumberLiteral(int pos) {
        super(pos);
        this.type = 40;
    }

    public NumberLiteral(int pos, int len) {
        super(pos, len);
        this.type = 40;
    }

    public NumberLiteral(int pos, String value) {
        super(pos);
        this.type = 40;
        this.setValue(value);
        this.setLength(value.length());
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.assertNotNull(value);
        this.value = value;
        this.number = null;
    }

    public BigDecimal getNumber() {
        if (this.number == null) {
            this.number = this.value == null ? BigDecimal.ZERO : new BigDecimal(this.value);
        }
        return this.number;
    }

    public void setNumber(BigDecimal value) {
        this.number = value;
        this.value = String.valueOf(value);
    }

    @Override
    public String toSource(int depth) {
        return this.makeIndent(depth) + (this.value == null ? "<null>" : this.value);
    }

    @Override
    public void visit(NodeVisitor v) {
        v.visit(this);
    }
}

