/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk;

import com.cloud.sdk.Request;
import com.cloud.sdk.annotation.NotThreadSafe;
import com.cloud.sdk.http.HttpMethodName;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotThreadSafe
public class DefaultRequest<T>
implements Request<T> {
    private String resourcePath;
    private Map<String, List<String>> parameters = new LinkedHashMap<String, List<String>>();
    private Map<String, String> headers = new HashMap<String, String>();
    private URI endpoint;
    private HttpMethodName httpMethod = HttpMethodName.POST;
    private InputStream content;
    private int timeOffset;

    @Override
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public void addParameter(String name, String value) {
        List<String> paramList = this.parameters.get(name);
        if (paramList == null) {
            paramList = new ArrayList<String>();
            this.parameters.put(name, paramList);
        }
        paramList.add(value);
    }

    @Override
    public void addParameters(String name, List<String> values) {
        if (values == null) {
            return;
        }
        for (String value : values) {
            this.addParameter(name, value);
        }
    }

    @Override
    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    @Override
    public Request<T> withParameter(String name, String value) {
        this.addParameter(name, value);
        return this;
    }

    @Override
    public HttpMethodName getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public void setHttpMethod(HttpMethodName httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Override
    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public InputStream getContent() {
        return this.content;
    }

    @Override
    public void setContent(InputStream content) {
        this.content = content;
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }

    @Override
    public void setParameters(Map<String, List<String>> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    @Override
    public int getTimeOffset() {
        return this.timeOffset;
    }

    @Override
    public void setTimeOffset(int timeOffset) {
        this.timeOffset = timeOffset;
    }

    @Override
    public Request<T> withTimeOffset(int timeOffset) {
        this.setTimeOffset(timeOffset);
        return this;
    }

    public String toString() {
        Object value;
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.getHttpMethod()).append(" ");
        builder.append(this.getEndpoint()).append(" ");
        String resourcePath = this.getResourcePath();
        if (resourcePath == null) {
            builder.append("/");
        } else {
            if (!resourcePath.startsWith("/")) {
                builder.append("/");
            }
            builder.append(resourcePath);
        }
        builder.append(" ");
        if (!this.getParameters().isEmpty()) {
            builder.append("Parameters: (");
            for (String key : this.getParameters().keySet()) {
                value = this.getParameters().get(key);
                builder.append(key).append(": ").append(String.join((CharSequence)";", (Iterable<? extends CharSequence>)value)).append(", ");
            }
            builder.append(") ");
        }
        if (!this.getHeaders().isEmpty()) {
            builder.append("Headers: (");
            for (String key : this.getHeaders().keySet()) {
                value = this.getHeaders().get(key);
                builder.append(key).append(": ").append((String)value).append(", ");
            }
            builder.append(") ");
        }
        return builder.toString();
    }
}

