/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.auth.signer.internal;

import com.cloud.sdk.Request;
import com.cloud.sdk.auth.signer.internal.SignerUtils;

public final class SignerRequestParams {
    private final Request<?> request;
    private final long signingDateTimeMilli;
    private final String formattedSigningDateTime;
    private final String formattedSigningDate;
    private final String signingAlgorithm;

    public SignerRequestParams(Request<?> request, String signingAlgorithm) {
        this(request, signingAlgorithm, null);
    }

    public SignerRequestParams(Request<?> request, String signingAlgorithm, String signDate) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (signingAlgorithm == null) {
            throw new IllegalArgumentException("Signing Algorithm cannot be null");
        }
        this.signingDateTimeMilli = null == signDate ? this.getSigningDate(request) : this.getSigningDate(signDate);
        this.request = request;
        this.formattedSigningDate = SignerUtils.formatDateStamp(this.signingDateTimeMilli);
        this.formattedSigningDateTime = SignerUtils.formatTimestamp(this.signingDateTimeMilli);
        this.signingAlgorithm = signingAlgorithm;
    }

    private final long getSigningDate(Request<?> request) {
        return System.currentTimeMillis() - (long)(request.getTimeOffset() * 1000);
    }

    private final long getSigningDate(String signDate) {
        return SignerUtils.parseMillis(signDate);
    }

    public Request<?> getRequest() {
        return this.request;
    }

    public String getFormattedSigningDateTime() {
        return this.formattedSigningDateTime;
    }

    public long getSigningDateTimeMilli() {
        return this.signingDateTimeMilli;
    }

    public String getFormattedSigningDate() {
        return this.formattedSigningDate;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }
}

