/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.websocket;

import com.tongweb.web.InstanceManager;
import com.tongweb.web.util.res.StringManager;
import com.tongweb.web.websocket.ClientEndpointHolder;
import com.tongweb.web.websocket.pojo.PojoEndpointClient;
import javax.naming.NamingException;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;

public class PojoClassHolder
implements ClientEndpointHolder {
    private static final StringManager sm = StringManager.getManager(PojoClassHolder.class);
    private final Class<?> pojoClazz;
    private final ClientEndpointConfig clientEndpointConfig;

    public PojoClassHolder(Class<?> pojoClazz, ClientEndpointConfig clientEndpointConfig) {
        this.pojoClazz = pojoClazz;
        this.clientEndpointConfig = clientEndpointConfig;
    }

    @Override
    public String getClassName() {
        return this.pojoClazz.getName();
    }

    @Override
    public Endpoint getInstance(InstanceManager instanceManager) throws DeploymentException {
        try {
            Object pojo = instanceManager == null ? this.pojoClazz.getConstructor(new Class[0]).newInstance(new Object[0]) : instanceManager.newInstance(this.pojoClazz);
            return new PojoEndpointClient(pojo, this.clientEndpointConfig.getDecoders(), instanceManager);
        }
        catch (ReflectiveOperationException | SecurityException | NamingException e) {
            throw new DeploymentException(sm.getString("clientEndpointHolder.instanceCreationFailed"), e);
        }
    }
}

