/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.core;

import com.tongweb.container.Context;
import com.tongweb.container.LifecycleState;
import com.tongweb.container.core.StandardContext;
import com.tongweb.container.util.SessionConfig;
import com.tongweb.web.util.res.StringManager;
import javax.servlet.SessionCookieConfig;
import javax.servlet.http.Cookie;

public class ApplicationSessionCookieConfig
implements SessionCookieConfig {
    private static final StringManager sm = StringManager.getManager(ApplicationSessionCookieConfig.class);
    private boolean httpOnly;
    private boolean secure;
    private int maxAge = -1;
    private String comment;
    private String domain;
    private String name;
    private String path;
    private StandardContext context;

    public ApplicationSessionCookieConfig(StandardContext context) {
        this.context = context;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public int getMaxAge() {
        return this.maxAge;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void setComment(String comment) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", "comment", this.context.getPath()));
        }
        this.comment = comment;
    }

    @Override
    public void setDomain(String domain) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", "domain name", this.context.getPath()));
        }
        this.domain = domain;
    }

    @Override
    public void setHttpOnly(boolean httpOnly) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", "HttpOnly", this.context.getPath()));
        }
        this.httpOnly = httpOnly;
    }

    @Override
    public void setMaxAge(int maxAge) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", "max age", this.context.getPath()));
        }
        this.maxAge = maxAge;
    }

    @Override
    public void setName(String name) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", "name", this.context.getPath()));
        }
        this.name = name;
    }

    @Override
    public void setPath(String path) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", "path", this.context.getPath()));
        }
        this.path = path;
    }

    @Override
    public void setSecure(boolean secure) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", "secure", this.context.getPath()));
        }
        this.secure = secure;
    }

    public static Cookie createSessionCookie(Context context, String sessionId, boolean secure) {
        SessionCookieConfig scc = context.getServletContext().getSessionCookieConfig();
        Cookie cookie = new Cookie(SessionConfig.getSessionCookieName(context), sessionId);
        cookie.setMaxAge(scc.getMaxAge());
        cookie.setComment(scc.getComment());
        if (context.getSessionCookieDomain() == null) {
            if (scc.getDomain() != null) {
                cookie.setDomain(scc.getDomain());
            }
        } else {
            cookie.setDomain(context.getSessionCookieDomain());
        }
        if (scc.isSecure() || secure) {
            cookie.setSecure(true);
        }
        if (scc.isHttpOnly() || context.getUseHttpOnly()) {
            cookie.setHttpOnly(true);
        }
        cookie.setPath(SessionConfig.getSessionCookiePath(context));
        return cookie;
    }
}

