/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.util;

import com.tongweb.web.util.ExceptionUtils;
import java.io.InputStream;
import java.util.Properties;

public class ServerInfo {
    private static final String serverInfo;
    private static final String serverBuilt;
    private static final String serverNumber;
    private static final String serverENumber;

    public static String getServerInfo() {
        return serverInfo;
    }

    public static String getServerBuilt() {
        return serverBuilt;
    }

    public static String getServerNumber() {
        return serverNumber;
    }

    public static String getServerENumber() {
        return serverENumber;
    }

    public static void main(String[] args) {
        System.out.println("Server version: " + ServerInfo.getServerInfo());
        System.out.println("Server built:   " + ServerInfo.getServerBuilt());
        System.out.println("Server number:  " + ServerInfo.getServerNumber());
        System.out.println("OS Name:        " + System.getProperty("os.name"));
        System.out.println("OS Version:     " + System.getProperty("os.version"));
        System.out.println("Architecture:   " + System.getProperty("os.arch"));
        System.out.println("JVM Version:    " + System.getProperty("java.runtime.version"));
        System.out.println("JVM Vendor:     " + System.getProperty("java.vm.vendor"));
    }

    static {
        String info = null;
        String built = null;
        String number = null;
        String eNumber = null;
        Properties props = new Properties();
        try (InputStream is = ServerInfo.class.getResourceAsStream("/com/tongweb/container/util/ServerInfo.properties");){
            props.load(is);
            info = props.getProperty("server.info");
            built = props.getProperty("server.built");
            number = props.getProperty("server.number");
            eNumber = props.getProperty("server.encrypt.number");
            System.setProperty("server.tongweb.license.productVersion", eNumber);
            System.setProperty("server.tongweb.license.tongWebEdition", "Embed");
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
        }
        if (info == null || info.equals("PRODUCT_VERSION")) {
            info = "TongWeb/7.0.E";
        }
        if (number == null || number.equals("VERSION_NUMBER")) {
            number = "7.0.E";
        }
        if (built == null || built.equals("VERSION_BUILT")) {
            built = "unknown";
        }
        serverInfo = info;
        serverBuilt = built;
        serverNumber = number;
        serverENumber = eNumber;
    }
}

