/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.net;

import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.web.jni.Address;
import com.tongweb.web.util.net.NioEndpoint;
import com.tongweb.web.util.net.SocketWrapperBase;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class DOSFilter {
    private static final Log log = LogFactory.getLog(NioEndpoint.class);
    public static boolean attackCheck = false;
    public static boolean logEnable = false;
    public static boolean interruptCurrentConnect = true;
    public static int completeMessageTimeout = -1;
    public static int maxAttackTimes = 3;
    public static int blackListExpired = 12;
    public static Map<String, AtomicInteger> blackList = new ConcurrentHashMap<String, AtomicInteger>();

    public static synchronized void addBlackList(String remoteAddress) {
        AtomicInteger value;
        if (remoteAddress == null || "".equals(remoteAddress)) {
            return;
        }
        if (remoteAddress.startsWith("/")) {
            remoteAddress = remoteAddress.substring(1);
        }
        if ((value = blackList.get(remoteAddress)) == null) {
            value = new AtomicInteger(1);
            blackList.put(remoteAddress, value);
        }
        int times = value.incrementAndGet();
        if (logEnable) {
            log.info("Join the blacklist ! IP address [" + remoteAddress + "] May be Slow HTTP Attack ! Times:" + times);
        }
    }

    public static void addBlackList(SocketWrapperBase<?> wrapper) {
        DOSFilter.addBlackList(DOSFilter.getRemoteAddress(wrapper));
    }

    public static boolean denySocket(String remoteAddress) {
        if (remoteAddress == null || "".equals(remoteAddress)) {
            return true;
        }
        boolean deny = false;
        if (remoteAddress.startsWith("/")) {
            remoteAddress = remoteAddress.substring(1);
        }
        if (!blackList.containsKey(remoteAddress)) {
            return false;
        }
        if (blackList.get(remoteAddress).get() > maxAttackTimes) {
            if (logEnable) {
                log.info("Connection Refused ! Too many slow http requests from same IP address [" + remoteAddress + "], May be Slow HTTP Attack ! ");
            }
            deny = true;
        }
        return deny;
    }

    public static boolean isDenyAprSocketOnConnect(long socket) {
        if (!attackCheck) {
            return false;
        }
        String remoteAddress = null;
        try {
            long sa = Address.get(1, socket);
            remoteAddress = Address.getip(sa);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DOSFilter.denySocket(remoteAddress);
    }

    public static boolean isDenyBioSocketOnConnect(Socket socket) {
        if (socket == null || !attackCheck) {
            return false;
        }
        InetAddress inetAddress = socket.getInetAddress();
        if (inetAddress == null) {
            return false;
        }
        String remoteAddress = inetAddress.toString();
        return DOSFilter.denySocket(remoteAddress);
    }

    public static boolean isDenyNio2SocketOnConnect(AsynchronousSocketChannel socket) {
        if (null == socket || !attackCheck) {
            return false;
        }
        SocketAddress socketAddress = null;
        String remoteAddr = null;
        try {
            socketAddress = socket.getRemoteAddress();
            if (socketAddress instanceof InetSocketAddress) {
                remoteAddr = ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return DOSFilter.denySocket(remoteAddr);
    }

    public static boolean isDenyNioSocketOnConnect(SocketChannel socket) {
        if (null == socket || !attackCheck) {
            return false;
        }
        return DOSFilter.isDenyBioSocketOnConnect(socket.socket());
    }

    public static boolean denySocketOnRead(SocketWrapperBase<?> wrapper) throws IOException {
        if (!attackCheck) {
            return false;
        }
        String ipAddr = DOSFilter.getRemoteAddress(wrapper);
        boolean isDeny = DOSFilter.denySocket(ipAddr);
        if (isDeny && interruptCurrentConnect && logEnable && log.isWarnEnabled()) {
            log.warn("Closing the socket on " + ipAddr + " May be Slow HTTP Attack !");
        }
        return isDeny;
    }

    private static String getRemoteAddress(SocketWrapperBase<?> wrapper) {
        if (null == wrapper) {
            return null;
        }
        return wrapper.getRemoteAddr();
    }

    public static void completeMessageTimeout(SocketWrapperBase<?> wrapper, long msgReadStartTime, boolean isFinished) {
        if (attackCheck) {
            long cost = System.currentTimeMillis() - msgReadStartTime;
            if (logEnable && log.isTraceEnabled()) {
                log.trace("Connection Http11InputBuffer socketWrapper.read" + wrapper.getRemoteAddr() + " costTime [" + cost + "]");
            }
            if (!isFinished && cost > (long)(completeMessageTimeout * 1000)) {
                DOSFilter.addBlackList(wrapper);
            }
        }
    }

    static {
        try {
            if (attackCheck && blackListExpired > 0) {
                Timer timer = new Timer(true);
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        blackList.clear();
                    }
                }, 0L, (long)(blackListExpired * 60 * 60 * 1000));
            }
        }
        catch (Exception ex) {
            attackCheck = false;
        }
    }
}

