/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.license.bean.cfg;

import com.tongweb.commons.license.bean.cfg.LicenseConfig;
import com.tongweb.commons.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LicenseRemoteConfig
extends LicenseConfig {
    public static final String IP_SEPARATOR = new String(",");
    private String licenseIps;
    private List<String> dynamicHosts = new ArrayList<String>();
    private Ssl ssl;
    private String publicKey;

    private LicenseRemoteConfig(Builder builder) {
        this.setTongwebEdition(builder.tongWebEdition);
        if (StringUtils.isNotEmpty(builder.tongWebName)) {
            this.setTongWebName(builder.tongWebName);
        }
        this.setProductVersion(builder.productVersion);
        this.setLicenseIps(builder.licenseIps);
        this.setSsl(builder.ssl);
        this.setPublickey(builder.publicKey);
    }

    private void setPublickey(String publicKey) {
        this.publicKey = publicKey;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public String getLicenseIps() {
        return this.licenseIps;
    }

    public void setLicenseIps(String licenseIps) {
        this.licenseIps = licenseIps;
        String[] ips = licenseIps.split(IP_SEPARATOR);
        this.dynamicHosts.addAll(Arrays.asList(ips));
    }

    public List<String> getDynamicHosts() {
        return this.dynamicHosts;
    }

    public String getTopDynamicHost() {
        return this.dynamicHosts.size() > 0 ? this.dynamicHosts.get(0) : null;
    }

    public void setDynamicHosts(List<String> dynamicHosts) {
        this.dynamicHosts = dynamicHosts;
    }

    public String generatorProductKey() {
        return this.getTongWebName() + "_" + this.getProductVersion() + "_" + this.getTongwebEdition();
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    @Override
    public String toString() {
        return "LicenseRemoteConfig{licenseIps='" + this.licenseIps + '\'' + ", ssl=" + this.ssl + "} " + super.toString();
    }

    public static class Ssl {
        private String keyStore;
        private String keyStorePassword;
        private String keyStoreType = "JKS";
        private String trustStore;
        private String trustStorePassword;
        private String trustStoreType = "JKS";

        public String getKeyStore() {
            return this.keyStore;
        }

        public void setKeyStore(String keyStore) {
            if (StringUtils.isEmpty(keyStore)) {
                return;
            }
            this.keyStore = keyStore;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public void setKeyStorePassword(String keyStorePassword) {
            if (StringUtils.isEmpty(keyStorePassword)) {
                return;
            }
            this.keyStorePassword = keyStorePassword;
        }

        public String getTrustStore() {
            return this.trustStore;
        }

        public void setTrustStore(String trustStore) {
            if (StringUtils.isEmpty(trustStore)) {
                return;
            }
            this.trustStore = trustStore;
        }

        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public void setTrustStorePassword(String trustStorePassword) {
            if (StringUtils.isEmpty(trustStorePassword)) {
                return;
            }
            this.trustStorePassword = trustStorePassword;
        }

        public String getTrustStoreType() {
            return this.trustStoreType;
        }

        public void setTrustStoreType(String trustStoreType) {
            if (StringUtils.isEmpty(trustStoreType)) {
                return;
            }
            this.trustStoreType = trustStoreType;
        }

        public String getKeyStoreType() {
            return this.keyStoreType;
        }

        public void setKeyStoreType(String keyStoreType) {
            if (StringUtils.isEmpty(keyStoreType)) {
                return;
            }
            this.keyStoreType = keyStoreType;
        }

        public String toString() {
            return "Ssl{keyStore='" + this.keyStore + '\'' + ", keyStorePassword='" + this.keyStorePassword + '\'' + ", keyStoreType='" + this.keyStoreType + '\'' + ", trustStore='" + this.trustStore + '\'' + ", trustStorePassword='" + this.trustStorePassword + '\'' + ", trustStoreType='" + this.trustStoreType + '\'' + '}';
        }
    }

    public static final class Builder {
        private String tongWebEdition;
        private String tongWebName;
        private String productVersion;
        private String publicKey;
        private String licenseIps;
        private Ssl ssl;

        public Builder productVersion(String val) {
            this.productVersion = val;
            return this;
        }

        public Builder licenseIps(String val) {
            this.licenseIps = val;
            return this;
        }

        public Builder ssl(Ssl val) {
            this.ssl = val;
            return this;
        }

        public LicenseRemoteConfig build() {
            return new LicenseRemoteConfig(this);
        }

        public Builder tongwebEdition(String val) {
            this.tongWebEdition = val;
            return this;
        }

        public Builder tongWebName(String val) {
            this.tongWebName = val;
            return this;
        }

        public Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }
    }
}

