/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.utils.strategy;

import com.tongweb.commons.utils.strategy.Strategy;
import com.tongweb.commons.utils.strategy.StrategyPattern;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class StrategyContext<In, Out> {
    Map<Integer, Strategy<In, Out>> context = new HashMap<Integer, Strategy<In, Out>>();
    TreeMap<Integer, StrategyPattern<In>> patternList = new TreeMap();

    public void register(StrategyPattern<In> pattern, Strategy<In, Out> strategy) {
        this.patternList.put(pattern.order(), pattern);
        this.context.put(pattern.order(), strategy);
    }

    public Out executeStrategy(In in) {
        return this.getStrategy(in).doOperation(in);
    }

    public Strategy<In, Out> getStrategy(In in) {
        for (Map.Entry<Integer, StrategyPattern<In>> entry : this.patternList.entrySet()) {
            if (!entry.getValue().match(in)) continue;
            return this.context.get(entry.getKey());
        }
        return this.context.get(this.patternList.lastKey());
    }
}

