/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.backport.java.util.concurrent;

import com.tongtech.backport.java.util.PriorityQueue;
import com.tongtech.backport.java.util.concurrent.locks.Condition;
import com.tongtech.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.Comparator;

public class BoundedPriorityBlockingQueue {
    private int bound;
    private final ReentrantLock lock = new ReentrantLock(true);
    private final Condition notFull = this.lock.newCondition();
    private PriorityQueue queue;

    public BoundedPriorityBlockingQueue(int bound) {
        this.queue = new PriorityQueue();
        this.bound = bound;
    }

    public BoundedPriorityBlockingQueue(int bound, Comparator comp) {
        this.queue = new PriorityQueue(comp);
        this.bound = bound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object obj) {
        this.lock.lock();
        try {
            while (this.queue.size() == this.bound) {
                this.notFull.await();
            }
            boolean bl = this.queue.offer(obj);
            return bl;
        }
        catch (InterruptedException e) {
            this.notFull.signal();
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean add(Object e) {
        return this.offer(e);
    }

    public boolean isFilled() {
        return this.queue.size() == this.bound;
    }

    public Object take() throws InterruptedException {
        this.lock.lock();
        try {
            Object obj = this.queue.poll();
            this.notFull.signal();
            Object object = obj;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }
}

