/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.protocol;

import com.tongtech.jms.protocol.TlqRemoteProtocolHandler;
import com.tongtech.remote.protocol.command.MonitorInfo;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.MessageConsumerImpl;
import com.tongtech.tmqi.jmsclient.MessageProducerImpl;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;

public class MonitorImpl {
    private TlqRemoteProtocolHandler handler;
    private Connection connMonitor;
    private static final int BROKER_INFO = 401;
    private static final int CONNECTION_INFO = 402;
    private static final int SESSION_INFO = 403;
    private static final int CONSUMER_INFO = 404;
    private static final int PRODUCER_INFO = 405;
    public static final String BROKER_TOTAL_CONNECTION = "AL";
    public static final String BROKER_FREE_CONNECTION_ID = "FC";
    public static final String BROKER_FREE_SESSION_ID = "FS";
    public static final String CONNECTION_THREAD_ID = "TI";
    public static final String CONNECTION_RECEIVE_BYTE_NUM = "RB";
    public static final String CONNECTION_SEND_BYTE_NUM = "SB";
    public static final String SESSION_PRODUCER_NUM = "PC";
    public static final String SESSION_CONSUMER_NUM = "CC";
    public static final String SESSION_SEND_MESSAGE_NUM = "SMC";
    public static final String SESSION_REC_MESSAGE_NUM = "RMC";
    public static final String PRODUCER_SEND_NUM = "RC";
    public static final String CONSUMER_RECEIVE_NUM = "SC";

    public MonitorImpl(ConnectionFactory qcf) throws Exception {
        this.connMonitor = qcf.createConnection();
        this.handler = (TlqRemoteProtocolHandler)((ConnectionImpl)this.connMonitor).getProtocolHandler();
    }

    public Properties lookBrokerInfo() throws Exception {
        MonitorInfo monitorInfo = new MonitorInfo();
        monitorInfo.setMonitorType(401);
        Properties propertyResult = new Properties();
        propertyResult = this.handler.monitor(monitorInfo);
        return propertyResult;
    }

    private void lookConnectionInfo() throws Exception {
        String connectionId = this.handler.getConnectinId();
        this.lookConnectionInfo(this.connMonitor);
    }

    public Properties lookConnectionInfo(Connection connection) throws Exception {
        MonitorInfo monitorInfo = new MonitorInfo();
        monitorInfo.setMonitorType(402);
        monitorInfo.setMonitorObjectID(((ConnectionImpl)connection).connectionID);
        Properties propertyResult = new Properties();
        propertyResult = this.handler.monitor(monitorInfo);
        return propertyResult;
    }

    public Properties lookSessionInfo(Session session) throws Exception {
        String sessionId = String.valueOf(((SessionImpl)session).getBrokerSessionID());
        String connectionId = this.getObjectId("ConnectionID=", session.toString());
        MonitorInfo monitorInfo = new MonitorInfo();
        monitorInfo.setMonitorType(403);
        monitorInfo.setMonitorObjectID(connectionId + ":" + sessionId);
        Properties propertyResult = new Properties();
        propertyResult = this.handler.monitor(monitorInfo);
        return propertyResult;
    }

    public Properties lookProducerInfo(MessageProducer producer) throws Exception {
        MessageProducerImpl mpi = (MessageProducerImpl)producer;
        MonitorInfo monitorInfo = new MonitorInfo();
        monitorInfo.setMonitorType(405);
        String allString = mpi.toString();
        String producerId = this.getObjectId("ProducerID=", allString);
        String sessionId = this.getObjectId("SessionID=", allString);
        String connectionId = this.getObjectId("ConnectionID=", allString);
        monitorInfo.setMonitorObjectID(connectionId + ":" + sessionId + ":" + producerId);
        Properties propertyResult = new Properties();
        propertyResult = this.handler.monitor(monitorInfo);
        return propertyResult;
    }

    public Properties lookConsumerInfo(MessageConsumer consumer) throws Exception {
        MessageConsumerImpl mci = (MessageConsumerImpl)consumer;
        String allString = mci.getSession().toString();
        long sessionId = mci.getSession().getBrokerSessionID();
        String connectionId = this.getObjectId("ConnectionID=", allString);
        MonitorInfo monitorInfo = new MonitorInfo();
        monitorInfo.setMonitorType(404);
        System.out.println(connectionId + ":" + sessionId + ":" + mci.getInterestId());
        monitorInfo.setMonitorObjectID(connectionId + ":" + sessionId + ":" + mci.getInterestId());
        Properties propertyResult = new Properties();
        propertyResult = this.handler.monitor(monitorInfo);
        return propertyResult;
    }

    private String getObjectId(String name, String allString) {
        String[] subString = allString.split(name);
        subString = subString[1].split(",");
        return subString[0].trim();
    }

    public static void main(String[] args) {
    }

    public void close() throws Exception {
        if (this.connMonitor != null) {
            this.connMonitor.close();
            this.connMonitor = null;
        }
    }
}

