/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.protocol;

import com.tongtech.backport.java.util.concurrent.ArrayBlockingQueue;
import com.tongtech.backport.java.util.concurrent.BlockingQueue;
import com.tongtech.backport.java.util.concurrent.TimeUnit;
import com.tongtech.backport.java.util.concurrent.locks.ReentrantLock;
import com.tongtech.jms.InvalidClientIDException;
import com.tongtech.jms.InvalidDestinationException;
import com.tongtech.jms.InvalidSelectorException;
import com.tongtech.jms.JMSException;
import com.tongtech.jms.JMSSecurityException;
import com.tongtech.jms.ResourceAllocationException;
import com.tongtech.jms.jni.TlqException;
import com.tongtech.jms.protocol.TlqLocalProtocolHandlerMBean;
import com.tongtech.jms.protocol.TlqLocalReadWritePacket;
import com.tongtech.jms.tlq.TlqWrapper;
import com.tongtech.jms.util.InjectorUtil;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.Destination;
import com.tongtech.tmqi.io.PacketType;
import com.tongtech.tmqi.io.ReadOnlyPacket;
import com.tongtech.tmqi.io.ReadWritePacket;
import com.tongtech.tmqi.io.SysMessageID;
import com.tongtech.tmqi.jmsclient.AckQueue;
import com.tongtech.tmqi.jmsclient.BrowserConsumer;
import com.tongtech.tmqi.jmsclient.BytesMessageImpl;
import com.tongtech.tmqi.jmsclient.ConnectionHandler;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.ConnectionResult;
import com.tongtech.tmqi.jmsclient.Consumer;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.FileMessageImpl;
import com.tongtech.tmqi.jmsclient.MapMessageImpl;
import com.tongtech.tmqi.jmsclient.MessageConsumerImpl;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.MessageProducerImpl;
import com.tongtech.tmqi.jmsclient.ObjectMessageImpl;
import com.tongtech.tmqi.jmsclient.ProtocolHandler;
import com.tongtech.tmqi.jmsclient.QueueReceiverImpl;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import com.tongtech.tmqi.jmsclient.StreamMessageImpl;
import com.tongtech.tmqi.jmsclient.TemporaryDestination;
import com.tongtech.tmqi.jmsclient.TextMessageImpl;
import com.tongtech.tmqi.jmsclient.TlqSysMessageID;
import com.tongtech.tmqi.jmsclient.TopicSubscriberImpl;
import com.tongtech.tmqi.jmsclient.Transaction;
import com.tongtech.tmqi.util.JMQXid;
import com.tongtech.tmqi.util.NextCounter;
import com.tongtech.tmqi.util.StringUtil;
import com.tongtech.tmqi.util.TongReentrantLock;
import com.tongtech.tmqi.util.TupleInput;
import com.tongtech.tmqi.util.UniqueID;
import com.tongtech.tmqi.util.selector.Selector;
import com.tongtech.tmqi.util.selector.SelectorFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.lang.constant.Constable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import javax.jms.Message;

public class TlqLocalProtocolHandler
implements Runnable,
ProtocolHandler,
TlqLocalProtocolHandlerMBean {
    static Logger logger = LoggerFactory.getLogger(TlqLocalProtocolHandler.class);
    public static final String SEPARATOR = "/";
    public static final char MSGID_SEPARATOR = '|';
    public static final String DEFAULT_TOPIC_NAME = "default";
    private BlockingQueue queue = new ArrayBlockingQueue(100);
    private ConnectionImpl connection = null;
    private boolean isClosed = false;
    private boolean ackEnabled = true;
    private boolean ackAck = true;
    protected static short prefix = (short)new Random().nextInt(Short.MAX_VALUE);
    private boolean setJMSXAppID = false;
    private boolean setJMSXUserID = false;
    private boolean setJMSXRcvTimestamp = false;
    private String jmsxAppID = null;
    private String jmsxUserID = null;
    private ConnectionHandler connectionHandler = null;
    private boolean debugInboundPkt = false;
    private boolean debugOutboundPkt = false;
    private String pktFilter = null;
    public int timeout = 0;
    public int stoppedCount = 0;
    private Object incObj = new Object();
    private static long nextAckID = 0L;
    private Thread recoverThread = null;
    public Hashtable requestMetaData = null;
    private boolean enableZip = Boolean.getBoolean("tmqi.zip.enable");
    protected boolean twoPhaseCommitFlag = false;
    private static java.util.logging.Logger inpktLogger = null;
    private static java.util.logging.Logger outpktLogger = null;
    private boolean ackEnabledFlag = false;
    private boolean produceAck = false;
    private TlqWrapper tlqWrapper = null;
    private Thread writeChannelThread = null;
    protected static final String iWriteChannel = "iWriteChannel-";
    private boolean readStatus;
    private boolean fatalErrorIsProcessed = false;
    private BlockingQueue ackQueue = new ArrayBlockingQueue(1);
    private BlockingQueue checkinQueue = new ArrayBlockingQueue(1);
    private volatile boolean sentSetClientID = false;
    static List lst = new ArrayList();
    Hashtable sessionStopTable = new Hashtable();
    ReentrantLock startLock = new ReentrantLock();
    TongReentrantLock writePacketNoAckLock = new TongReentrantLock();
    ReentrantLock fatalLock = new ReentrantLock();

    public BlockingQueue getCheckinQueue() {
        return this.checkinQueue;
    }

    public void closeConnection() throws javax.jms.JMSException {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("TlqLocalProtocolHandler: disConnection...");
            }
            if (lst.contains(this.connection.getCliID())) {
                lst.remove(this.connection.getCliID());
            }
            this.tlqWrapper.closeConnection();
        }
        catch (Exception ex) {
            throw new javax.jms.JMSException(ex.toString());
        }
    }

    public boolean getAuthenticated() {
        return false;
    }

    public boolean getTimeToPing() {
        return false;
    }

    public boolean isClientIDsent() {
        return this.sentSetClientID;
    }

    public void openConnection() throws javax.jms.JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler : open connection");
        }
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(300);
        TlqException ack = null;
        try {
            this.queue.put(pkt);
            ack = (TlqException)((Object)this.ackQueue.poll(60L, TimeUnit.SECONDS));
            if (ack == null) {
                throw new javax.jms.JMSException("connection timeout!");
            }
            if (ack.getTlqErrno() == 0) {
                if (logger.isTraceEnabled()) {
                    logger.trace("TlqLocalProtocolHandler : end of open connection");
                }
                return;
            }
            throw new javax.jms.JMSException(ack.getErrorCause());
        }
        catch (Exception ex) {
            throw new javax.jms.JMSException(ex.toString());
        }
    }

    public void setRecoverThread(Thread thread) {
    }

    public void setTimeToPing(boolean b) {
    }

    public void setTwoPhaseCommitFlag(boolean b) {
    }

    public void abort() {
    }

    public void acknowledge(ReadWritePacket msg) throws javax.jms.JMSException {
        if (logger.isDebugEnabled()) {
            logger.debug("TlqLocalProtocolHandler: acknowledge");
        }
        TupleInput is = new TupleInput(msg.getMessageBody());
        if (logger.isDebugEnabled()) {
            logger.debug("after TupleInput , acknowledge");
        }
        while (true) {
            block14: {
                try {
                    ReadWritePacket sendPacket;
                    block13: {
                        ReadOnlyPacket ack;
                        int statusCode;
                        do {
                            long consumerId = is.readLong();
                            if (logger.isDebugEnabled()) {
                                logger.debug("after is.readLong , acknowledge");
                            }
                            sendPacket = InjectorUtil.createReadWritePacket(1);
                            if (logger.isDebugEnabled()) {
                                logger.debug("after createReadWritePacket , acknowledge");
                            }
                            sendPacket.setConsumerID(consumerId);
                            sendPacket.setPacketType(24);
                            sendPacket.setMessageID(is.readString());
                            sendPacket.setIsQueue(is.readBoolean());
                            sendPacket.setDestination(is.readString());
                            sendPacket.setSrcNode(is.readString());
                            String subQueue = is.readString();
                            if (!sendPacket.getIsQueue() && subQueue != null && !subQueue.equals("")) {
                                sendPacket.setSubQueue(subQueue);
                            }
                            sendPacket.setTransactionID(msg.getTransactionID());
                            if (logger.isDebugEnabled()) {
                                logger.debug("msg.getSendAcknowledge()={}, ackAck={}, destination {}, txid {}", new Object[]{new Boolean(msg.getSendAcknowledge()), new Boolean(this.ackAck), sendPacket.getDestination(), new Long(msg.getTransactionID())});
                            }
                            logger.info("msg.getIsQueue()={}, srcNode={}, MessageID {}}", new Object[]{new Boolean(sendPacket.getIsQueue()), sendPacket.getSrcNode(), sendPacket.getMessageID()});
                            this.ackAck = false;
                            if (!msg.getSendAcknowledge() || !this.ackAck) break block13;
                            if (logger.isTraceEnabled()) {
                                logger.trace("need ack back ....");
                            }
                            ack = this.writePacketWithReply(sendPacket, 125, 0);
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("acknowledge send ackId:{}", new Long(sendPacket.getConsumerID()));
                        } while ((statusCode = TlqLocalProtocolHandler.getReplyStatus(ack)) == 200);
                        this.checkRemoteFailedStatus(statusCode, ack);
                        this.throwServerErrorException(ack);
                        break block14;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("acknowledge write ack ID:{}", (Object)sendPacket.getMessageID());
                    }
                    sendPacket.setSendAcknowledge(false);
                    this.writePacketNoAck(sendPacket, 0);
                }
                catch (IndexOutOfBoundsException e) {
                    break;
                }
                catch (Exception e) {
                    logger.error("", e);
                    break;
                }
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("TlqLocalProtocolHandler: end of acknowledge");
        }
    }

    public void acknowledgeUndeliverable(ReadWritePacket pkt, boolean sendToDMQ) throws javax.jms.JMSException {
    }

    public void checkin() throws javax.jms.JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:start checkin");
        }
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(117);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 117, 1);
        if (logger.isTraceEnabled()) {
            logger.trace("checkin send ackId:{}", pkt.getConsumerID());
        }
        int statusCode = TlqLocalProtocolHandler.getReplyStatus(ack);
        if (logger.isTraceEnabled()) {
            logger.trace("checkin, after call writePacketWithReply {}\uffc41\ufffd7OK={}", new Integer(statusCode), (Object)new Integer(200));
        }
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:end of checkin.");
        }
    }

    public void checkin(long id, long brokerSessionID) throws javax.jms.JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:start consumer checkin consumer {} ", id);
        }
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(200);
        pkt.setProducerID(id);
        Hashtable<String, Long> ht = new Hashtable<String, Long>();
        ht.put("JMS_TONG_SessionID", new Long(brokerSessionID));
        pkt.setProperties(ht);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 117, 0);
        if (logger.isTraceEnabled()) {
            logger.trace("consumer checkin send ackId:{}", pkt.getConsumerID());
        }
        int statusCode = TlqLocalProtocolHandler.getReplyStatus(ack);
        if (logger.isTraceEnabled()) {
            logger.trace("consumer checkin, after call writePacketWithReply {}\uffc41\ufffd7OK={}", new Integer(statusCode), (Object)new Integer(200));
        }
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:end of consumer checkin {}", id);
        }
    }

    public void checkout() throws javax.jms.JMSException {
        int statusCode;
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:checkout.");
        }
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(118);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 118, 0);
        if (logger.isTraceEnabled()) {
            logger.trace("checkout send ackId:{}", pkt.getConsumerID());
        }
        if ((statusCode = TlqLocalProtocolHandler.getReplyStatus(ack)) != 200) {
            this.throwServerErrorException(ack);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:end of checkout.");
        }
    }

    public String subMessage(Consumer consumer) throws javax.jms.JMSException {
        int statusCode;
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandlersubMessage consumerId:{}", consumer.getInterestId());
        }
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        Destination dest = (Destination)consumer.getDestination();
        pkt.setPacketType(210);
        pkt.setDestination(dest.getName());
        pkt.setIsQueue(dest.isQueue());
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        if (consumer.getDurable()) {
            props.put("JMS_TONG_DurableName", consumer.getDurableName());
            props.put("JMS_TONG_Share", this.connection.tmqiEnableSharedClientID);
            props.put("JMS_TONG_ClientID", this.connection.getClientID());
        } else {
            props.put("JMS_TONG_Share", this.connection.tmqiEnableSharedSubscriptions);
        }
        props.put("JMS_TONG_ConsumerID", consumer.getInterestId());
        pkt.setProperties(props);
        String subQueue = dest.getProperty("tmqiTopicSubQueueName");
        if (subQueue != null && !subQueue.equals("")) {
            pkt.setSubQueue(subQueue);
        }
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 210, 0);
        if (logger.isTraceEnabled()) {
            logger.trace("subMessage send ackId:{}", pkt.getConsumerID());
        }
        if ((statusCode = TlqLocalProtocolHandler.getReplyStatus(ack)) != 200) {
            this.throwServerErrorException(ack);
        }
        return ack.getFixedMessageID();
    }

    private void addConsumerToInterest(ReadWritePacket pkt, Consumer consumer) throws javax.jms.JMSException {
        try {
            this.connection.interestTable.addInterest(consumer);
            int prefectchMax = consumer.getPrefetchMaxMsgCount();
            this.connection.flowControl.addConsumerFlowControl(consumer);
            if (logger.isTraceEnabled()) {
                logger.trace("add consumer to interest, interid: {}, consumer:{}, prefetchMax: {}", new Object[]{consumer.getInterestId(), consumer, new Integer(prefectchMax)});
            }
            SessionImpl session = null;
            if (pkt.getPacketType() == 14) {
                if (consumer instanceof TopicSubscriberImpl) {
                    TopicSubscriberImpl ts = (TopicSubscriberImpl)consumer;
                    session = ts.getSession();
                    session.addMessageConsumer((MessageConsumerImpl)consumer);
                    if (logger.isTraceEnabled()) {
                        logger.trace("add consumer to interest, TopicSubscriberImpl");
                    }
                } else if (consumer instanceof QueueReceiverImpl) {
                    QueueReceiverImpl qr = (QueueReceiverImpl)consumer;
                    session = qr.getSession();
                    Hashtable<String, Long> ht = null;
                    if (pkt.getProperties() == null) {
                        ht = new Hashtable<String, Long>();
                        pkt.setProperties(ht);
                    } else {
                        ht = pkt.getProperties();
                    }
                    ht.put("JMS_TONG_SessionID", new Long(session.getBrokerSessionID()));
                    session.addMessageConsumer((MessageConsumerImpl)consumer);
                    if (logger.isTraceEnabled()) {
                        logger.trace("add consumer to interest, QueueReceiverImpl");
                    }
                }
            } else {
                BrowserConsumer bc = (BrowserConsumer)consumer;
                session = bc.getSession();
                session.addBrowserConsumer(bc);
                if (logger.isTraceEnabled()) {
                    logger.trace("add consumer to interest, BrowserConsumer");
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
        }
    }

    private void clearConsumerToInterest(ReadWritePacket pkt, Consumer consumer) throws javax.jms.JMSException {
        try {
            this.connection.interestTable.removeInterest(consumer);
            this.connection.flowControl.removeConsumerFlowControl(consumer);
            logger.warn("+++addInterest not ok, remove consumer from interest, interid: {}, consumer:{}", new Object[]{consumer.getInterestId(), consumer});
            SessionImpl session = null;
            if (pkt.getPacketType() == 14) {
                if (consumer instanceof TopicSubscriberImpl) {
                    TopicSubscriberImpl ts = (TopicSubscriberImpl)consumer;
                    session = ts.getSession();
                    session.removeMessageConsumer((MessageConsumerImpl)consumer);
                    if (logger.isTraceEnabled()) {
                        logger.trace("remove consumer to interest, TopicSubscriberImpl");
                    }
                } else if (consumer instanceof QueueReceiverImpl) {
                    QueueReceiverImpl qr = (QueueReceiverImpl)consumer;
                    session = qr.getSession();
                    session.removeMessageConsumer((MessageConsumerImpl)consumer);
                    if (logger.isTraceEnabled()) {
                        logger.trace("remove consumer to interest, QueueReceiverImpl");
                    }
                }
            } else {
                BrowserConsumer bc = (BrowserConsumer)consumer;
                session = bc.getSession();
                session.removeBrowserConsumer(bc);
                if (logger.isTraceEnabled()) {
                    logger.trace("remove consumer to interest, BrowserConsumer");
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
        }
    }

    public void addInterest(Consumer consumer) throws javax.jms.JMSException, javax.jms.InvalidSelectorException {
        String errorString;
        ReadWritePacket pkt;
        Hashtable<String, Object> props;
        Destination dest;
        block26: {
            TemporaryDestination tmpDest;
            if (logger.isTraceEnabled()) {
                logger.trace("TlqLocalProtocolHandler:addInterest.consumerId:{}", consumer.getInterestId());
            }
            String messageSelector = consumer.getMessageSelector();
            try {
                Selector sel = Selector.compile(messageSelector);
            }
            catch (SelectorFormatException e) {
                throw new javax.jms.InvalidSelectorException(messageSelector + "compile fail, because " + e.getMessage());
            }
            dest = (Destination)consumer.getDestination();
            if (dest.isTemporary() && !(tmpDest = (TemporaryDestination)dest).checkSendCreateDest(dest, this.connection)) {
                return;
            }
            props = new Hashtable<String, Object>();
            pkt = InjectorUtil.createReadWritePacket(1);
            pkt.setPacketType(14);
            pkt.setDestination(dest.getName());
            pkt.setIsQueue(dest.isQueue());
            if (consumer.getMessageSelector() != null) {
                props.put("JMS_TONG_Selector", consumer.getMessageSelector());
            }
            props.put("JMS_TONG_NoLocal", consumer.getNoLocal());
            props.put("JMS_TONG_Reconnect", Boolean.FALSE);
            if (consumer.acknowledgeMode > 0) {
                props.put("JMS_TONG_AckMode", new Integer(consumer.acknowledgeMode));
            }
            props.put("requestMetaData", consumer);
            props.put("JMS_TONG_Size", new Integer(consumer.getPrefetchMaxMsgCount()));
            consumer.setInterestId(this.getNextAckID());
            if (consumer.getInterestId() != null) {
                props.put("JMS_TONG_ConsumerID", consumer.getInterestId());
            }
            long tlqSessionId = -1L;
            if (consumer instanceof MessageConsumerImpl) {
                tlqSessionId = ((MessageConsumerImpl)consumer).getSession().getBrokerSessionID();
            }
            this.checkin(consumer.getInterestId(), tlqSessionId);
            if (!dest.isQueue()) {
                try {
                    Thread.sleep(1000L);
                    String subScriberId = this.subMessage(consumer);
                    if (logger.isTraceEnabled()) {
                        logger.trace("add Interest,subScriberId:{}", (Object)subScriberId);
                    }
                    pkt.setFixedMessageID(subScriberId);
                    String subQueue = dest.getProperty("tmqiTopicSubQueueName");
                    if (subQueue != null && !subQueue.equals("")) {
                        pkt.setSubQueue(subQueue);
                    }
                }
                catch (InterruptedException ex) {
                    if (!logger.isTraceEnabled()) break block26;
                    logger.trace("TlqLocalProtocolHandlersubMessage error!", ex);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandleradd consumer consumer :{} ,session :{},Destination:{}", new Object[]{consumer, consumer.getSession(), pkt.getDestination()});
        }
        pkt.setProperties(props);
        this.addConsumerToInterest(pkt, consumer);
        ReadOnlyPacket reply = this.writePacketWithReply(pkt, 15, 0);
        if (logger.isTraceEnabled()) {
            logger.trace("addInterest send ackId:{}", pkt.getConsumerID());
        }
        int statusCode = -1;
        try {
            Hashtable replyProps = reply.getProperties();
            statusCode = (Integer)replyProps.get("JMS_TONG_Status");
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        if (statusCode != 200) {
            this.clearConsumerToInterest(pkt, consumer);
        }
        if (statusCode == 400 && consumer.getMessageSelector() != null) {
            errorString = AdministeredObject.cr.getKString("C4022", consumer.getMessageSelector()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new InvalidSelectorException(errorString, "C4022")));
        }
        if (statusCode == 404) {
            errorString = AdministeredObject.cr.getKString("C4019", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new InvalidDestinationException(errorString, "C4019")));
        }
        if (statusCode == 403) {
            errorString = AdministeredObject.cr.getKString("C4079", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new JMSSecurityException(errorString, "C4079")));
        }
        if (statusCode == 405) {
            errorString = AdministeredObject.cr.getKString("C4020", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4020"));
        }
        if (statusCode == 409) {
            String destString = AdministeredObject.cr.getString(dest.isQueue() ? "L0950" : "L0951");
            String errorString2 = AdministeredObject.cr.getKString("C4073", destString, dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new ResourceAllocationException(errorString2, "C4073")));
        }
        if (statusCode != 200) {
            this.throwServerErrorException(reply);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:end of added interest, consumerID: {}", consumer.getInterestId());
        }
    }

    public void checkRemoteFailedStatus(int statusCode, ReadOnlyPacket ack) throws javax.jms.JMSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws javax.jms.JMSException {
        if (this.isClosed) {
            return;
        }
        try {
            block7: {
                try {
                    this.isClosed = true;
                    if (logger.isTraceEnabled()) {
                        logger.trace("TlqLocalProtocolHandler :start put WriteClose!");
                    }
                    TlqLocalReadWritePacket pkt = new TlqLocalReadWritePacket();
                    pkt.setPacketType(1000);
                    this.queue.put(pkt);
                    if (!logger.isTraceEnabled()) break block7;
                    logger.trace("TlqLocalProtocolHandler :end of put WriteClose!!");
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e, "C4004", true);
                    Object var3_4 = null;
                }
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            throw throwable;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("ConnectionHandler closed ...");
        }
    }

    public void commit(long transactionID, int xaflags, JMQXid xid) throws javax.jms.JMSException {
        this.commit(transactionID, xaflags, xid, false);
    }

    public void commit(long transactionID, int xaflags, JMQXid xid, boolean onePhasePropRequired) throws javax.jms.JMSException {
        int statusCode;
        if (logger.isDebugEnabled()) {
            logger.debug("TlqLocalProtocolHandler:commit Transaction transactionID:{}", new Long(transactionID));
        }
        if (transactionID < 0L) {
            throw new javax.jms.JMSException("txid error: " + transactionID);
        }
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dos = null;
        byte[] xidBody = null;
        pkt.setPacketType(46);
        Hashtable<String, Constable> ht = new Hashtable<String, Constable>(1);
        ht.put("JMS_TONG_TransactionID", new Long(transactionID));
        pkt.setTransactionID(transactionID);
        if (onePhasePropRequired) {
            ht.put("JMS_TONG_XAOnePhase", Boolean.TRUE);
        }
        if (xid != null) {
            ht.put("JMS_TONG_XAFlags", new Integer(xaflags));
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                dos = new DataOutputStream(byteArrayOutputStream);
                xid.write(dos);
                dos.flush();
                xidBody = byteArrayOutputStream.toByteArray();
                dos.close();
                byteArrayOutputStream.close();
                pkt.setMessageBody(xidBody);
            }
            catch (IOException ioe) {
                ExceptionHandler.handleException((Exception)ioe, "C4038");
            }
        }
        pkt.setProperties(ht);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 127, 0);
        if (logger.isDebugEnabled()) {
            logger.debug("commit send ackId:{}", new Long(pkt.getConsumerID()));
        }
        if ((statusCode = TlqLocalProtocolHandler.getReplyStatus(ack)) == 200) {
            return;
        }
        if (statusCode == 400 || statusCode == 503) {
            String errorString = AdministeredObject.cr.getKString("C4027", new Long(transactionID)) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4027"));
        }
        this.checkRemoteFailedStatus(statusCode, ack);
        this.throwServerErrorException(ack);
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:end of commit Transaction transactionID:{}", transactionID);
        }
    }

    public void commitHATransaction(long transactionID) throws javax.jms.JMSException {
    }

    public void createMessageProducer(MessageProducerImpl producer) throws javax.jms.JMSException {
        Destination dest = (Destination)producer.getDestination();
        this.createMessageProducer(producer, dest);
    }

    public void createMessageProducer(MessageProducerImpl producer, javax.jms.Destination destination) throws javax.jms.JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:create producer");
        }
        Destination dest = (Destination)destination;
        long producerId = UniqueID.generateID(prefix);
        producer.setProducerID(dest, producerId);
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:end of create producer");
        }
    }

    public void createSession(SessionImpl session) throws javax.jms.JMSException {
        long sessionID = -1L;
        sessionID = SessionImpl.genSessionId();
        session.setBrokerSessionID(sessionID);
        if (logger.isTraceEnabled()) {
            logger.trace("Added session, JMQSessionID: " + session.getBrokerSessionID());
        }
    }

    public void decStoppedCount() {
    }

    public void deleteMessageProducer(MessageProducerImpl impl, long producerID) throws javax.jms.JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("got delete producer reply ...");
        }
    }

    public void deleteSession(SessionImpl session) throws javax.jms.JMSException {
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(70);
        Hashtable<String, Long> props = new Hashtable<String, Long>(1);
        props.put("JMQSessionID", new Long(session.getBrokerSessionID()));
        pkt.setProperties(props);
        int statueCode = 200;
    }

    public void enableWriteAcknowledge(boolean state) {
        this.ackEnabled = state;
        this.ackEnabledFlag = true;
        if (logger.isTraceEnabled()) {
            logger.trace("Producer ack required: " + this.ackEnabled);
        }
    }

    public void endHATransaction(long transactionID) throws javax.jms.JMSException {
    }

    public void endTransaction(long transactionID, int xaflags, JMQXid xid) throws javax.jms.JMSException {
        if (logger.isDebugEnabled()) {
            logger.debug("start call endTranscation. {} {}", new Long(transactionID), (Object)new Integer(xaflags));
        }
    }

    public long generateUID() throws javax.jms.JMSException {
        return UniqueID.generateID();
    }

    public boolean getAckAck() {
        return this.ackAck;
    }

    public boolean getAckEnabled() {
        return this.ackEnabled;
    }

    public ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    public Integer getDestinationType(Destination destination) {
        int type = 0;
        type = destination.isQueue() ? 1 : 2;
        if (destination.isTemporary()) {
            type |= 0x10;
        }
        return new Integer(type);
    }

    public byte[] getIPAddress() {
        return null;
    }

    public long getInterestId(ReadWritePacket pkt) {
        return 0L;
    }

    public MessageImpl getJMSMessage(ReadOnlyPacket pkt) throws javax.jms.JMSException {
        MessageImpl message = null;
        int a = pkt.getPacketType();
        switch (a) {
            case 1: {
                message = new TextMessageImpl(1);
                break;
            }
            case 2: {
                message = new BytesMessageImpl(1);
                break;
            }
            case 4: {
                message = new StreamMessageImpl(1);
                break;
            }
            case 3: {
                message = new MapMessageImpl(1);
                break;
            }
            case 5: {
                message = new ObjectMessageImpl(1);
                break;
            }
            case 6: {
                message = new MessageImpl(1);
                break;
            }
            case 7: {
                message = new FileMessageImpl(1);
                break;
            }
            default: {
                throw new JMSException("not implemented.");
            }
        }
        ((ReadWritePacket)pkt).setTransactionID(-1L);
        message.setPacket((ReadWritePacket)pkt);
        message.getPropertiesFromPacket();
        message.getMessageBodyFromPacket();
        if (this.setJMSXRcvTimestamp) {
            message.setStringProperty("JMSXRcvTimestamp", String.valueOf(System.currentTimeMillis()));
        }
        message.setMessageReadMode(true);
        message.setPropertiesReadMode(true);
        message.setMessageID(pkt.getSysMessageID());
        message.setInterestID(pkt.getConsumerID());
        message.setMsgId(pkt.getMessageID());
        message.setFixedMessageID(pkt.getFixedMessageID());
        return message;
    }

    public Hashtable getLicense() throws javax.jms.JMSException {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public byte[] getMacAddress() {
        return null;
    }

    public int getStoppedCount() {
        return 0;
    }

    public int getTimeout() {
        return 0;
    }

    public void goodBye(boolean reply) throws javax.jms.JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:goodbye");
        }
        try {
            ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
            pkt.setPacketType(28);
            Hashtable props = new Hashtable();
            if (reply) {
                this.writePacketWithAck(pkt, 160, 1);
                if (logger.isTraceEnabled()) {
                    logger.trace("goodbye send ackId:{}", pkt.getConsumerID());
                }
            } else {
                this.writePacketNoAck(pkt, 1);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4001", true);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:end of goodbye");
        }
    }

    public void hello(String name, String password) throws javax.jms.JMSException {
    }

    public void hello(String name, String password, String connectionID) throws javax.jms.JMSException {
    }

    public void incStoppedCount() {
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void ping() throws javax.jms.JMSException {
    }

    public void pingReply(ReadOnlyPacket ping) throws javax.jms.JMSException {
    }

    public void prepare(long transactionID, JMQXid xid) throws javax.jms.JMSException {
    }

    public void prepare(long transactionID, JMQXid xid, boolean onePhase) throws javax.jms.JMSException {
    }

    public void prepareHATransaction(long transactionID) throws javax.jms.JMSException {
    }

    public ReadWritePacket readPacket(int readType) throws javax.jms.JMSException {
        ReadWritePacket pkt = null;
        try {
            this.readStatus = false;
            pkt = readType == 0 ? this.tlqWrapper.jmsAckRead() : this.tlqWrapper.jmsMessageRead();
            this.readStatus = true;
            pkt.dump(logger);
        }
        catch (Exception e) {
            if (!this.isClosed) {
                ExceptionHandler.handleException(e, "C4002", true);
            }
            throw new javax.jms.JMSException("ProtocolHandler is closed");
        }
        return pkt;
    }

    public JMQXid[] recover(int xaflags) throws javax.jms.JMSException {
        return null;
    }

    public void redeliver(ReadWritePacket msg, boolean flag, boolean isTransacted) throws javax.jms.JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:redeliver");
        }
        msg.setPacketType(32);
        TupleInput is = new TupleInput(msg.getMessageBody());
        if (logger.isDebugEnabled()) {
            logger.debug("after TupleInput , acknowledge");
        }
        while (true) {
            try {
                long consumerId = is.readLong();
                if (logger.isDebugEnabled()) {
                    logger.debug("after is.readLong , acknowledge");
                }
                ReadWritePacket sendPacket = InjectorUtil.createReadWritePacket(1);
                if (logger.isDebugEnabled()) {
                    logger.debug("after createReadWritePacket , acknowledge");
                }
                sendPacket.setConsumerID(consumerId);
                sendPacket.setPacketType(32);
                sendPacket.setMessageID(is.readString());
                sendPacket.setIsQueue(is.readBoolean());
                sendPacket.setDestination(is.readString());
                sendPacket.setSrcNode(is.readString());
                String subQueue = is.readString();
                if (!sendPacket.getIsQueue() && subQueue != null && !subQueue.equals("")) {
                    sendPacket.setSubQueue(subQueue);
                }
                sendPacket.setTransactionID(msg.getTransactionID());
                if (logger.isDebugEnabled()) {
                    logger.debug("msg.getSendAcknowledge()={}, ackAck={}, destination {}, txid {}", new Object[]{new Boolean(msg.getSendAcknowledge()), new Boolean(this.ackAck), sendPacket.getDestination(), new Long(msg.getTransactionID())});
                    logger.debug("msg.getIsQueue()={}, srcNode={}, MessageID {}}", new Object[]{new Boolean(sendPacket.getIsQueue()), sendPacket.getSrcNode(), sendPacket.getMessageID()});
                }
                Hashtable<String, Boolean> prop = new Hashtable<String, Boolean>(1);
                prop.put("JMS_TONG_SetRedelivered", flag);
                sendPacket.setProperties(prop);
                this.writePacketNoAck(sendPacket, 0);
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
            catch (Exception e) {
                logger.error("", e);
                break;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("TlqLocalProtocolHandler: end of redeliver");
        }
    }

    public void redirect(String url) throws javax.jms.JMSException {
    }

    public void removeInterest(Consumer consumer) throws javax.jms.JMSException {
        String errorString;
        int statusCode;
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:removeInterest,consumerId:{}", consumer.getInterestId());
        }
        Hashtable<String, Constable> props = new Hashtable<String, Constable>();
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(16);
        props.put("JMS_TONG_ConsumerID", consumer.getInterestId());
        props.put("JMS_TONG_Block", Boolean.TRUE);
        if (consumer instanceof MessageConsumerImpl) {
            props.put("JMS_TONG_BodyType", new Integer(0));
            props.put("JMS_TONG_RedeliverAll", Boolean.TRUE);
        }
        pkt.setProperties(props);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 118, 0);
        if (logger.isTraceEnabled()) {
            logger.trace("removeInterest send ackId:{}", pkt.getConsumerID());
        }
        if ((statusCode = TlqLocalProtocolHandler.getReplyStatus(ack)) == 403) {
            errorString = AdministeredObject.cr.getKString("C4080", consumer.getInterestId()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new JMSSecurityException(errorString, "C4080")));
        }
        if (statusCode == 404) {
            String cid = consumer.getInterestId().toString();
            String errorString2 = AdministeredObject.cr.getKString("C4085", cid) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new InvalidDestinationException(errorString2, "C4085")));
        }
        if (statusCode == 409 && consumer.getDurable()) {
            errorString = AdministeredObject.cr.getKString("C4007", consumer.getDurableName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new InvalidDestinationException(errorString, "C4007")));
        }
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:end of interest removed: {}", consumer.getInterestId());
        }
    }

    public void resend(ReadWritePacket pkt) throws javax.jms.JMSException {
    }

    public void resetClientID() throws javax.jms.JMSException {
    }

    public void resumeConsumerFlow(Consumer consumer, int maxMessages) throws javax.jms.JMSException {
        Long txId;
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:send resumer,ConsumerId:{},Size:{}", consumer.getInterestId(), (Object)new Integer(maxMessages));
        }
        if (null == consumer.getSession()) {
            logger.error("consumer's session is null ");
        }
        if (null != consumer.getSession().getTransaction() && null != this.sessionStopTable.get(txId = new Long(consumer.getSession().getTransaction().getTransactionID()))) {
            if (logger.isTraceEnabled()) {
                logger.trace("this session ( txid {}) in sessionStopTable ,so not need resumeFlow", txId);
            }
            return;
        }
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(65);
        Destination dest = (Destination)consumer.getDestination();
        pkt.setConsumerID(consumer.getInterestId().intValue());
        pkt.setDestination(dest.getName());
        pkt.setIsQueue(dest.isQueue());
        props.put("JMS_TONG_Size", new Integer(maxMessages));
        pkt.setProperties(props);
        this.writePacketNoAck(pkt, 0);
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:end of send resumer,ConsumerId:{},Size:{}", consumer.getInterestId(), (Object)new Integer(maxMessages));
        }
    }

    public void resumeFlow(int maxMessages) throws javax.jms.JMSException {
    }

    public void resumeMessageDelivery() throws javax.jms.JMSException {
    }

    public void resumeSession(SessionImpl session) throws javax.jms.JMSException {
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(20);
        Hashtable<String, Long> props = new Hashtable<String, Long>(1);
        props.put("JMQSessionID", new Long(session.getBrokerSessionID()));
        pkt.setProperties(props);
    }

    public void rollback(long transactionID, JMQXid xid) throws javax.jms.JMSException {
        this._rollbackXA(transactionID, xid, false, false);
    }

    public void rollback(long transactionID, JMQXid xid, boolean redeliver) throws javax.jms.JMSException {
        this._rollbackXA(transactionID, xid, redeliver, false);
    }

    public void rollback(long transactionID, JMQXid xid, boolean redeliver, boolean setIBit) throws javax.jms.JMSException {
        this._rollbackXA(transactionID, xid, redeliver, setIBit);
    }

    private void _rollbackXA(long transactionID, JMQXid xid, boolean setJMQRedeliver, boolean setIBit) throws javax.jms.JMSException {
        int statusCode;
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dos = null;
        byte[] xidBody = null;
        Hashtable<String, Constable> ht = null;
        pkt.setPacketType(48);
        if (setIBit) {
            pkt.setIndempotent(true);
        }
        if (transactionID != 0L || setJMQRedeliver) {
            ht = new Hashtable<String, Constable>(transactionID != 0L && setJMQRedeliver ? 2 : 1);
            if (transactionID != 0L) {
                ht.put("JMS_TONG_TransactionID", new Long(transactionID));
            }
            if (setJMQRedeliver) {
                ht.put("JMS_TONG_Redeliver", Boolean.valueOf(setJMQRedeliver));
            }
            pkt.setProperties(ht);
        }
        if (xid != null) {
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                dos = new DataOutputStream(byteArrayOutputStream);
                xid.write(dos);
                dos.flush();
                xidBody = byteArrayOutputStream.toByteArray();
                dos.close();
                byteArrayOutputStream.close();
                pkt.setMessageBody(xidBody);
            }
            catch (IOException ioe) {
                ExceptionHandler.handleException((Exception)ioe, "C4038");
            }
        }
        pkt.setTransactionID(transactionID);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 128, 0);
        if (logger.isTraceEnabled()) {
            logger.trace("_rollbackXA send ackId:{}", pkt.getConsumerID());
        }
        if ((statusCode = TlqLocalProtocolHandler.getReplyStatus(ack)) == 400) {
            String errorString = AdministeredObject.cr.getKString("C4027", new Long(transactionID)) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4027"));
        }
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
    }

    public void rollback(long transactionID) throws javax.jms.JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:rollback");
        }
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(48);
        Hashtable<String, Long> ht = new Hashtable<String, Long>(1);
        ht.put("JMS_TONG_TransactionID", new Long(transactionID));
        pkt.setTransactionID(transactionID);
        pkt.setProperties(ht);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 128, 0);
        if (logger.isDebugEnabled()) {
            logger.debug("rollback send ackId:{}", new Long(pkt.getConsumerID()));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:end of rollback");
        }
    }

    public void setAckAck(boolean state) {
    }

    public int checkClientID(String clientID) {
        return 200;
    }

    public void setClientID(String clientID) throws javax.jms.JMSException {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(50);
        props.put("JMQClientID", clientID);
        if (this.connection.useNamespace()) {
            props.put("JMQNamespace", this.connection.getRANamespaceUID());
        }
        props.put("JMQShare", new Boolean(this.connection.tmqiEnableSharedClientID));
        pkt.setProperties(props);
        if (logger.isTraceEnabled()) {
            logger.trace("before checkClientID id is " + clientID);
        }
        int statusCode = this.checkClientID(clientID);
        if (logger.isTraceEnabled()) {
            logger.trace("IN tlqlocalproticalhandler setclientID get statusCode  id ==" + statusCode);
        }
        if (statusCode != 200) {
            if (statusCode == 409) {
                String errorString = AdministeredObject.cr.getKString("C4052", clientID) + this.getUserBrokerInfo();
                ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new InvalidClientIDException(errorString, "C4052")));
            } else if (statusCode == 400) {
                String errorString = AdministeredObject.cr.getKString("C4087", clientID) + this.getUserBrokerInfo();
                ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new InvalidClientIDException(errorString, "C4087")));
            }
        }
        this.sentSetClientID = true;
    }

    public void setDebugInboundPkt(boolean flag) {
    }

    public void setDebugOutboundPkt(boolean flag) {
    }

    public void setPktFilter(String filterSpec) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws javax.jms.JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:start");
        }
        try {
            block6: {
                try {
                    this.startLock.lock();
                    if (this.stoppedCount != 0) break block6;
                    ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
                    pkt.setPacketType(20);
                    this.writePacketNoAck(pkt, 0);
                    if (!logger.isTraceEnabled()) break block6;
                    logger.trace("start send ackId:{}", pkt.getConsumerID());
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e, "C4001", true);
                    Object var3_4 = null;
                    this.startLock.unlock();
                }
            }
            Object var3_3 = null;
            this.startLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.startLock.unlock();
            throw throwable;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:end of start");
        }
    }

    public long startTransaction(long transactionID, int xaflags, JMQXid xid) throws javax.jms.JMSException {
        return this.startTransaction(transactionID, xaflags, xid, false, 0L);
    }

    public long startTransaction(long transactionID, int xaflags, JMQXid xid, long brokerSessionID) throws javax.jms.JMSException {
        return this.startTransaction(transactionID, xaflags, xid, true, brokerSessionID);
    }

    public long startTransaction(long transactionID, int xaflags, JMQXid xid, boolean setSessionID, long brokerSessionID) throws javax.jms.JMSException {
        if (logger.isDebugEnabled()) {
            logger.debug("TlqLocalProtocolHandler:start Transaction.transactionID:{}", new Long(transactionID));
        }
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dos = null;
        byte[] xidBody = null;
        pkt.setPacketType(44);
        Hashtable<String, Number> ht = new Hashtable<String, Number>(1);
        if (setSessionID) {
            ht.put("JMS_TONG_SessionID", new Long(brokerSessionID));
        }
        if (this.twoPhaseCommitFlag) {
            ht.put("JMS_TONG_AutoRollback", new Integer(2));
        }
        if (xaflags != -1) {
            ht.put("JMS_TONG_XAFlags", new Integer(xaflags));
            if (xid != null) {
                try {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    dos = new DataOutputStream(byteArrayOutputStream);
                    xid.write(dos);
                    dos.flush();
                    xidBody = byteArrayOutputStream.toByteArray();
                    dos.close();
                    byteArrayOutputStream.close();
                    pkt.setMessageBody(xidBody);
                }
                catch (IOException ioe) {
                    ExceptionHandler.handleException((Exception)ioe, "C4038");
                }
            }
        }
        pkt.setProperties(ht);
        int statusCode = -1;
        ReadOnlyPacket replypkt = null;
        int count = 0;
        while (count < 2000) {
            ++count;
            if (logger.isDebugEnabled()) {
                logger.debug("send startTransaction.{}", new Integer(count));
            }
            try {
                replypkt = this.writePacketWithReply(pkt, 126, 0);
                Hashtable replyProps = replypkt.getProperties();
                Integer value = (Integer)replyProps.get("JMS_TONG_Status");
                statusCode = value;
                Long lvalue = (Long)replyProps.get("JMS_TONG_TransactionID");
                if (lvalue != null) {
                    transactionID = lvalue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Start Transaction send ackId:{} transactionID\uff1a{}", new Long(pkt.getConsumerID()), (Object)lvalue);
                }
                if (transactionID >= 0L) break;
                Thread.sleep(100L);
            }
            catch (Exception e) {
                logger.error("startTransaction exception", e);
            }
        }
        if (statusCode == 409) {
            String errorString = AdministeredObject.cr.getKString("C4028", new Long(transactionID)) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4028"));
        }
        if (statusCode != 200) {
            this.throwServerErrorException(replypkt);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("TlqLocalProtocolHandler:end of  Transaction.transactionID:{}", new Long(transactionID));
        }
        return transactionID;
    }

    public void stop() throws javax.jms.JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:stop");
        }
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(22);
        this.writePacketWithAck(pkt, 120);
        if (logger.isTraceEnabled()) {
            logger.trace("stop send ackId:{}", pkt.getConsumerID());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:end of stop");
        }
    }

    public void stopSession(SessionImpl session) throws javax.jms.JMSException {
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(22);
        Hashtable<String, Long> props = new Hashtable<String, Long>(1);
        props.put("JMQSessionID", new Long(session.getBrokerSessionID()));
        pkt.setProperties(props);
    }

    public void suspendMessageDelivery() throws javax.jms.JMSException {
    }

    public void throwServerErrorException(ReadOnlyPacket ack) throws javax.jms.JMSException {
        String errorString = AdministeredObject.cr.getKString("C4036");
        try {
            Hashtable properties = TlqLocalProtocolHandler.getReplyProperties(ack);
            String reason = (String)properties.get("JMS_TONG_Error");
            Integer statusCode = (Integer)properties.get("JMS_TONG_Status");
            if (reason != null) {
                int type = ack.getPacketType();
                String pktName = PacketType.getString(type);
                errorString = "[" + pktName + "] " + errorString + " :[" + statusCode + "] " + reason;
                logger.error(errorString);
            }
            errorString = errorString + this.getUserBrokerInfo();
        }
        catch (Exception e) {
            logger.warn("", e);
        }
        ExceptionHandler.throwJMSException(new JMSException(errorString, "C4036"));
    }

    public void unsetClientID() throws javax.jms.JMSException {
    }

    public void unsubscribe(String durableName) throws javax.jms.JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(211);
        props.put("JMS_TONG_DurableName", durableName);
        props.put("JMS_TONG_ClientID", this.connection.getClientID());
        pkt.setProperties(props);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 8, 0);
        int statusCode = TlqLocalProtocolHandler.getReplyStatus(ack);
        if (statusCode == 404) {
            String errorString = AdministeredObject.cr.getKString("C4086", durableName) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new InvalidDestinationException(errorString, "C4086")));
        }
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
    }

    public int verifyHATransaction(long transactionID, int tstate) throws javax.jms.JMSException {
        return 0;
    }

    public int verifyHATransaction(long transactionID, int tstate, JMQXid xid) throws javax.jms.JMSException {
        return 0;
    }

    public void writeJMSMessage(Message message) throws javax.jms.JMSException {
        long jmsExpiration;
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:writeMessage {}", message);
        }
        ReadWritePacket pkt = null;
        MessageImpl messageImpl = null;
        messageImpl = (MessageImpl)message;
        long timetolive = jmsExpiration = message.getJMSExpiration();
        if (jmsExpiration != 0L) {
            message.setJMSExpiration(jmsExpiration += System.currentTimeMillis());
        }
        if (this.setJMSXAppID) {
            message.setStringProperty("JMSXAppID", this.jmsxAppID);
        }
        if (this.setJMSXUserID) {
            message.setStringProperty("JMSXUserID", this.jmsxUserID);
        }
        messageImpl.setMessageBodyToPacket();
        if (this.enableZip) {
            messageImpl.getPacket().setFlag(1024, true);
        } else if (messageImpl.shouldCompress) {
            messageImpl.getPacket().setFlag(1024, true);
        } else {
            messageImpl.getPacket().setFlag(1024, false);
        }
        messageImpl.setPropertiesToPacket();
        messageImpl.resetJMSMessageID();
        pkt = messageImpl.getPacket();
        pkt.setMessageID(null);
        pkt.setProducerID(messageImpl.getProducerID());
        pkt.setTimeToLive(timetolive);
        Destination dest = (Destination)messageImpl.getJMSDestination();
        pkt.setDestination(dest.getName());
        pkt.setDestinationClass(dest.getClass().getName());
        pkt.setIsQueue(dest.isQueue());
        if (!dest.isQueue()) {
            pkt.setPubQueue(dest.getProperty("tmqiTopicPubQueueName"));
            pkt.setSubQueue(dest.getProperty("tmqiTopicSubQueueName"));
        }
        if (message.getJMSReplyTo() != null) {
            Destination replyTo = (Destination)message.getJMSReplyTo();
            pkt.setReplyTo(replyTo.getName());
            pkt.setReplyToClass(replyTo.getClass().getName());
        }
        try {
            message.setJMSTimestamp(System.currentTimeMillis() / 1000L);
        }
        catch (Exception e) {
            logger.warn("set JMSTimestamp error !", e);
        }
        this.produceAck = this.ackEnabledFlag ? this.ackEnabled : message.getJMSDeliveryMode() == 2;
        if (this.produceAck) {
            int statusCode = -1;
            ReadOnlyPacket ack = null;
            ack = this.writePacketWithReply(pkt, 0, 0);
            if (ack != null) {
                pkt.setMessageID(ack.getMessageID());
            }
            statusCode = TlqLocalProtocolHandler.getReplyStatus(ack);
            if (ack != null) {
                pkt.setMessageID(ack.getMessageID());
            }
            if (statusCode != 200) {
                if (statusCode == 414) {
                    logger.warn("queue {] full, retry...", (Object)dest.getName());
                    String errorString = AdministeredObject.cr.getKString("C4096", dest.getName()) + this.getUserBrokerInfo();
                    ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new ResourceAllocationException(errorString, "C4096")));
                } else if (statusCode == 403) {
                    String errorString = AdministeredObject.cr.getKString("C4078", dest.getName()) + this.getUserBrokerInfo();
                    ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new JMSSecurityException(errorString, "C4078")));
                } else if (statusCode == 404) {
                    String errorString = AdministeredObject.cr.getKString("C4094", dest.getName()) + this.getUserBrokerInfo();
                    ExceptionHandler.throwJMSException(new JMSException(errorString, "C4094"));
                } else if (statusCode == 423) {
                    String errorString = AdministeredObject.cr.getKString("C4095", dest.getName()) + this.getUserBrokerInfo();
                    ExceptionHandler.throwJMSException(new JMSException(errorString, "C4095"));
                } else {
                    logger.error("error statusCode:[" + statusCode + "]");
                    this.throwServerErrorException(ack);
                }
            }
        } else {
            pkt.setSendAcknowledge(false);
            this.writePacketNoAck(pkt, 0);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:end of writeJMSMessage");
        }
    }

    public String getUserBrokerInfo() {
        String lname = this.connection.getUserName();
        if (lname == null) {
            lname = "null";
        } else if (lname.length() == 0) {
            lname = "empty/blank";
        }
        String info = null;
        info = this.connectionHandler == null ? "unavailable" : this.connectionHandler.getBrokerAddress();
        return " user=" + lname + ", broker=" + info;
    }

    public void setConnection(ConnectionImpl connection) throws javax.jms.JMSException {
        this.connection = connection;
        this.requestMetaData = connection.requestMetaData;
        this.tlqWrapper = new TlqWrapper(connection.initiator.getMqAddress().getServiceName());
        inpktLogger = java.util.logging.Logger.getLogger("com.tongtech.jms.pkt.in");
        outpktLogger = java.util.logging.Logger.getLogger("com.tongtech.jms.pkt.out");
        this.writeChannelThread = new Thread(this);
        this.writeChannelThread.setName(iWriteChannel + connection.getLocalID());
        this.writeChannelThread.start();
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandlerwriteChannel is begin!");
        }
        this.init(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(boolean isReconnect) throws javax.jms.JMSException {
        this.isClosed = false;
        try {
            block7: {
                try {
                    this.setTimeout();
                    this.connectionHandler = isReconnect ? this.connection.initiator.reconnect() : this.connection.initiator.createConnection();
                    this.setJMSXAppID = this.connection.connectionMetaData.setJMSXAppID;
                    if (this.setJMSXAppID) {
                        this.jmsxAppID = InetAddress.getLocalHost().getHostAddress() + "-" + System.currentTimeMillis();
                    }
                    this.setJMSXUserID = this.connection.connectionMetaData.setJMSXUserID;
                    if (this.setJMSXUserID) {
                        this.jmsxUserID = this.connection.getUserName();
                    }
                    this.setJMSXRcvTimestamp = this.connection.connectionMetaData.setJMSXRcvTimestamp;
                    if (!logger.isTraceEnabled()) break block7;
                    logger.trace("*** Connected to Tlq: {}", (Object)this.getUserBrokerInfo());
                }
                catch (javax.jms.JMSException jmse) {
                    throw jmse;
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e, "C4038", true);
                    Object var4_3 = null;
                }
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }

    public void verifyDestination(javax.jms.Destination destination, String selector, boolean browser) throws javax.jms.JMSException {
        try {
            Selector sel = Selector.compile(selector);
        }
        catch (SelectorFormatException e) {
            throw new javax.jms.InvalidSelectorException(selector + "compile fail, because " + e.getMessage());
        }
    }

    public SysMessageID[] browse(Consumer consumer) throws javax.jms.JMSException {
        SysMessageID[] ids;
        byte[] data;
        String errorString;
        Destination dest = (Destination)consumer.getDestination();
        String selector = consumer.getMessageSelector();
        ReadWritePacket pktsend = InjectorUtil.createReadWritePacket(1);
        pktsend.setPacketType(26);
        Hashtable<String, Object> props = new Hashtable<String, Object>(2);
        props.put("JMS_TONG_Destination", dest.getName());
        props.put("JMS_TONG_DestType", this.getDestinationType(dest));
        if (selector != null) {
            props.put("JMS_TONG_Selector", selector);
        }
        consumer.setInterestId(this.getNextAckID());
        if (consumer.getInterestId() != null) {
            props.put("JMS_TONG_ConsumerID", consumer.getInterestId());
        }
        props.put("requestMetaData", consumer);
        pktsend.setProperties(props);
        this.addConsumerToInterest(pktsend, consumer);
        ReadOnlyPacket pktrev = this.writePacketWithReply(pktsend, 123, 0);
        int statusCode = -1;
        try {
            Boolean autoCreate;
            Hashtable propsrev = pktrev.getProperties();
            statusCode = (Integer)propsrev.get("JMS_TONG_Status");
            if (statusCode == 404 && (autoCreate = (Boolean)propsrev.get("JMQCanCreate")) != null && autoCreate.booleanValue()) {
                return new SysMessageID[0];
            }
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e, "C4000", true);
        }
        if (statusCode == 400 && selector != null) {
            errorString = AdministeredObject.cr.getKString("C4022", selector) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new InvalidSelectorException(errorString, "C4022")));
        }
        if (statusCode == 404) {
            errorString = AdministeredObject.cr.getKString("C4019", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new InvalidDestinationException(errorString, "C4019")));
        }
        if (statusCode == 403) {
            errorString = AdministeredObject.cr.getKString("C4083", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new JMSSecurityException(errorString, "C4083")));
        }
        if (statusCode != 200) {
            this.clearConsumerToInterest(pktsend, consumer);
            this.throwServerErrorException(pktrev);
        }
        if ((data = ((ReadWritePacket)pktrev).getMessageBody()) == null || data.length == 0) {
            ids = new SysMessageID[]{};
        } else {
            String[] msgids = StringUtil.split(new String(data), '|');
            int numItems = msgids.length;
            ids = new TlqSysMessageID[numItems];
            for (int i = 0; i < numItems; ++i) {
                ids[i] = new TlqSysMessageID(msgids[i]);
            }
        }
        return ids;
    }

    public boolean deliver(ByteArrayOutputStream bos, Consumer consumer) throws javax.jms.JMSException {
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(42);
        Destination dest = (Destination)consumer.getDestination();
        Hashtable<String, Object> props = new Hashtable<String, Object>(2);
        props.put("JMS_TONG_ConsumerID", consumer.getInterestId());
        props.put("JMS_TONG_Destination", dest.getName());
        pkt.setProperties(props);
        String messageBody = null;
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(bos.toByteArray()));
        ArrayList<String> msgIds = new ArrayList<String>();
        try {
            while (true) {
                String id = is.readUTF();
                msgIds.add(id);
            }
        }
        catch (EOFException e) {
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        messageBody = StringUtil.join(msgIds.toArray(), '|');
        pkt.setMessageBody(messageBody.getBytes());
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 168, 0);
        int statusCode = TlqLocalProtocolHandler.getReplyStatus(ack);
        if (statusCode == 404) {
            return false;
        }
        if (statusCode == 200) {
            return true;
        }
        this.throwServerErrorException(ack);
        return false;
    }

    public void deleteDestination(javax.jms.Destination dest) throws javax.jms.JMSException {
        Destination destination = (Destination)dest;
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(36);
        Hashtable<String, Object> ht = new Hashtable<String, Object>(2);
        ht.put("JMS_TONG_Destination", destination.getName());
        Integer destinationType = this.getDestinationType(destination);
        ht.put("JMS_TONG_DestType", destinationType);
        pkt.setIsQueue(destination.isQueue());
        pkt.setDestination(destination.getName());
        pkt.setProperties(ht);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 37, 0);
        int statusCode = TlqLocalProtocolHandler.getReplyStatus(ack);
        if (statusCode != 200 && statusCode != 404) {
            this.throwServerErrorException(ack);
        }
        logger.trace("got delete destination reply ...");
    }

    public void createDestination(javax.jms.Destination dest) throws javax.jms.JMSException {
        String errorString;
        TemporaryDestination tmpDest;
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:create destination");
        }
        Destination destination = (Destination)dest;
        Integer destinationType = this.getDestinationType(destination);
        if (destination.isTemporary() && !(tmpDest = (TemporaryDestination)destination).checkSendCreateDest(destination, this.connection)) {
            return;
        }
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(34);
        Hashtable<String, Boolean> ht = new Hashtable<String, Boolean>(2);
        ht.put("JMS_TONG_ISTempDestination", new Boolean(destination.isTemporary()));
        pkt.setProperties(ht);
        pkt.setDestination(destination.getName());
        pkt.setIsQueue(destination.isQueue());
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 157, 0);
        if (logger.isTraceEnabled()) {
            logger.trace("create destination send ackId:{},destination:{}", new Long(pkt.getConsumerID()), (Object)destination);
        }
        int statusCode = TlqLocalProtocolHandler.getReplyStatus(ack);
        if (logger.isTraceEnabled()) {
            logger.trace("createDestination packetType.CREATE_DESTINATION_REPLY:{},statusCode:{}", new Integer(157), (Object)new Integer(statusCode));
        }
        if (statusCode == 404) {
            errorString = AdministeredObject.cr.getKString("C4019", destination.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new InvalidDestinationException(errorString, "C4019")));
        }
        if (statusCode == 403) {
            errorString = AdministeredObject.cr.getKString("C4077", destination.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new JMSSecurityException(errorString, "C4077")));
        }
        if (statusCode != 200 && statusCode != 409) {
            this.throwServerErrorException(ack);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:end of create destination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePacketNoAck(ReadWritePacket pkt, int writeType) throws javax.jms.JMSException {
        block5: {
            this.checkConnectionState(pkt);
            try {
                long start = System.currentTimeMillis();
                if (writeType == 0) {
                    this.queue.put(pkt);
                    break block5;
                }
                try {
                    this.tlqWrapper.jmsWrite(pkt);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    throw throwable;
                }
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e, "C4001", true);
            }
        }
    }

    private ReadOnlyPacket writePacketWithReply(ReadWritePacket pkt, int expectedReplyType, int writeType) throws javax.jms.JMSException {
        ReadOnlyPacket ack = this.writePacketWithAck(pkt, writeType);
        this.checkReplyType(ack, expectedReplyType, pkt);
        return ack;
    }

    private ReadOnlyPacket writePacketWithReply(ReadWritePacket pkt, int expectedReplyType, int altExpectedReplyType, int writeType) throws javax.jms.JMSException {
        ReadOnlyPacket ack = this.writePacketWithAck(pkt, writeType);
        int packetType = ack.getPacketType();
        if (packetType != expectedReplyType && packetType != altExpectedReplyType) {
            if (logger.isTraceEnabled()) {
                logger.trace("expected pkt type: {}, alt expected pkt type: {}, pkt type: {}", new Object[]{new Integer(expectedReplyType), new Integer(altExpectedReplyType), new Integer(packetType)});
            }
            String errorString = AdministeredObject.cr.getKString("C4000") + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4000"));
        }
        return ack;
    }

    private ReadOnlyPacket writePacketWithReply2(ReadWritePacket pkt, int expectedReplyType1, int expectedReplyType2, int writeType) throws javax.jms.JMSException {
        ReadOnlyPacket ack = this.writePacketWithAck(pkt, true, expectedReplyType1, writeType);
        if (ack.getPacketType() != expectedReplyType2) {
            if (logger.isTraceEnabled()) {
                logger.trace("expected pkt type: {}" + expectedReplyType2);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("pkt type: {}" + ack.getPacketType());
            }
            String errorString = AdministeredObject.cr.getKString("C4000") + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4000"));
        }
        return ack;
    }

    private void writePacketWithAck(ReadWritePacket pkt, int expectedAckType, int writeType) throws javax.jms.JMSException {
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, expectedAckType, writeType);
        int statusCode = TlqLocalProtocolHandler.getReplyStatus(ack);
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
    }

    private ReadOnlyPacket writePacketWithAck(ReadWritePacket pkt, int writeType) throws javax.jms.JMSException {
        return this.writePacketWithAck(pkt, false, -1, writeType);
    }

    private ReadOnlyPacket writePacketWithAck(ReadWritePacket pkt, boolean reply2, int expectedAckType1, int writeType) throws javax.jms.JMSException {
        ReadOnlyPacket ack = null;
        Long ackId = this.getNextAckID();
        pkt.setConsumerID(ackId);
        pkt.setSendAcknowledge(true);
        AckQueue tmpQ = reply2 ? new AckQueue(true, 2) : new AckQueue(true, 1);
        this.connection.addToAckQTable(ackId, tmpQ);
        this.addMetaData(pkt);
        if (logger.isTraceEnabled()) {
            logger.trace("before writePacketNoAck, ackId: {}, PacketType: {}", new Long(pkt.getConsumerID()), (Object)PacketType.getString(pkt.getPacketType()));
        }
        this.writePacketNoAck(pkt, writeType);
        if ((this.connection.connectionIsBroken || this.connection.recoverInProcess) && tmpQ.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace("tmpQ.isEmpty!");
            }
            ack = null;
        } else {
            ack = (ReadOnlyPacket)tmpQ.dequeueWait(this.connection, pkt, this.timeout);
            if (ack != null && logger.isTraceEnabled()) {
                logger.trace("writePacketWithAck, reply ok. ackId:{} packetType:{}", new Long(ack.getConsumerID()), (Object)PacketType.getString(ack.getPacketType()));
            }
        }
        if (reply2 && ack != null) {
            try {
                String errorString;
                int statusCode = (Integer)ack.getProperties().get("JMS_TONG_Status");
                int packetType = ack.getPacketType();
                if (packetType != expectedAckType1) {
                    errorString = AdministeredObject.cr.getKString("C4000") + this.getUserBrokerInfo();
                    ExceptionHandler.throwJMSException(new JMSException(errorString, "C4000"));
                }
                if (packetType == 11) {
                    if (statusCode == 503) {
                        errorString = AdministeredObject.cr.getKString("C4037") + this.getUserBrokerInfo();
                        ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new ResourceAllocationException(errorString, "C4037")));
                    } else if (statusCode == 408) {
                        errorString = AdministeredObject.cr.getKString("C4099") + this.getUserBrokerInfo();
                        ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new ResourceAllocationException(errorString, "C4099")));
                    } else if (statusCode == 301) {
                        errorString = AdministeredObject.cr.getKString("C4100") + this.getUserBrokerInfo();
                        ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new ResourceAllocationException(errorString, "C4100")));
                    }
                }
                if (statusCode != 200) {
                    this.throwServerErrorException(ack);
                }
                if ((this.connection.connectionIsBroken || this.connection.recoverInProcess) && tmpQ.isEmpty()) {
                    ack = null;
                } else {
                    logger.error("why here???");
                    ack = (ReadOnlyPacket)tmpQ.dequeueWait(this.connection, pkt, this.timeout);
                }
            }
            catch (IOException e) {
                ExceptionHandler.handleException(e, "C4000", true);
            }
            catch (ClassNotFoundException e) {
                ExceptionHandler.handleException(e, "C4000", true);
            }
        }
        this.connection.removeFromAckQTable(ackId);
        if (ack == null) {
            logger.error("*++*NOT RECEIVED REPLY, PacketType:" + PacketType.getString(pkt.getPacketType()) + ", ansId:" + pkt.getConsumerID());
            String errorString = AdministeredObject.cr.getKString("C4000") + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4000"));
        }
        return ack;
    }

    private void checkConnectionState(ReadWritePacket pkt) throws javax.jms.JMSException {
        if (this.connection.tmqiReconnect && this.connection.reconnecting && Thread.currentThread() != this.recoverThread && this.connection.readChannel.IsCurrentThread(Thread.currentThread())) {
            this.connection.checkReconnecting(pkt);
        }
    }

    private void checkReplyType(ReadOnlyPacket ack, int expectedType, ReadWritePacket pkt) throws javax.jms.JMSException {
        int receivedType = ack.getPacketType();
        if (receivedType != expectedType) {
            logger.error("receive unexpectedType ,expacted:{} received:{} send ackId:{} received ackId:{}", new Object[]{new Integer(expectedType), new Integer(ack.getPacketType()), new Long(pkt.getConsumerID()), new Long(ack.getConsumerID())});
            String errorString = AdministeredObject.cr.getKString("C4093", PacketType.getString(expectedType), PacketType.getString(receivedType)) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4093"));
        }
    }

    protected static int getReplyStatus(ReadOnlyPacket ack) throws javax.jms.JMSException {
        int statusCode = -1;
        Hashtable ackProperties = TlqLocalProtocolHandler.getReplyProperties(ack);
        Integer value = (Integer)ackProperties.get("JMS_TONG_Status");
        statusCode = value;
        return statusCode;
    }

    protected static Hashtable getReplyProperties(ReadOnlyPacket ack) throws javax.jms.JMSException {
        Hashtable ackProperties = null;
        try {
            ackProperties = ack.getProperties();
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, "C4005", true);
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e, "C4005", true);
        }
        return ackProperties;
    }

    protected void setTimeout() {
        String prop = this.connection.getTrimmedProperty("tmqiAckTimeout");
        if (prop != null) {
            this.timeout = Integer.parseInt(prop);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Ack timeout: " + this.timeout);
        }
    }

    private Long getNextAckID() {
        return NextCounter.getInstance().getNextAckID();
    }

    protected void addMetaData(ReadWritePacket pkt) throws javax.jms.JMSException {
        int pktType = pkt.getPacketType();
        if (pktType == 14 || pktType == 26 || pktType == 18) {
            try {
                Hashtable props = pkt.getProperties();
                Object consumer = props.get("requestMetaData");
                props.remove("requestMetaData");
                Long ackID = new Long(pkt.getConsumerID());
                if (logger.isTraceEnabled()) {
                    logger.trace("addMetaData ackid: {}, consumer: {}", ackID, consumer);
                }
                this.requestMetaData.put(ackID, consumer);
            }
            catch (IOException e) {
                ExceptionHandler.handleException(e, "C4000", true);
            }
            catch (ClassNotFoundException e) {
                ExceptionHandler.handleException(e, "C4000", true);
            }
        }
    }

    public boolean getReadStatus() {
        return this.readStatus;
    }

    public void sendConsumerPause(Consumer consumer) throws javax.jms.JMSException {
        Hashtable<String, Long> props = new Hashtable<String, Long>();
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(137);
        props.put("JMS_TONG_ConsumerID", consumer.getInterestId());
        pkt.setProperties(props);
        if (logger.isTraceEnabled()) {
            logger.trace("send flow control.");
        }
        this.writePacketNoAck(pkt, 0);
    }

    public void run() {
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:start write thread.");
        }
        ReadWritePacket pkt = null;
        TlqException tlqException = new TlqException("connection success");
        try {
            pkt = (ReadWritePacket)this.queue.take();
            if (pkt.getPacketType() == 300) {
                if (logger.isTraceEnabled()) {
                    logger.trace("start call openconnection.");
                }
                this.tlqWrapper.openConnection();
                if (logger.isTraceEnabled()) {
                    logger.trace("end of openconnection.");
                }
            } else {
                logger.error("start write thread, error.");
                return;
            }
            tlqException.setTlqErrno(0);
            this.ackQueue.put((Object)tlqException);
        }
        catch (Exception ex) {
            logger.error(ex.toString(), ex);
            try {
                TlqException tlqEx = new TlqException(ex.getMessage());
                tlqEx.setTlqErrno(-1);
                this.ackQueue.put((Object)tlqEx);
            }
            catch (InterruptedException ex1) {
                logger.error("put ackQueue failed!", ex);
            }
            return;
        }
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("WriteThread checkin.");
            }
            this.checkin();
            ConnectionResult t = new ConnectionResult("success.", 0);
            this.checkinQueue.put(t);
            if (logger.isTraceEnabled()) {
                logger.trace("after WriteThread checkin.");
            }
        }
        catch (Exception ex) {
            logger.error("check in failed!", ex);
            ConnectionResult t1 = new ConnectionResult(ex.getMessage(), -1);
            try {
                this.checkinQueue.put(t1);
            }
            catch (InterruptedException ex1) {
                logger.error("why???", ex1);
            }
            return;
        }
        while (!this.isClosed) {
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("writeChannel Waiting for read ReadWritePacket...");
                }
                if ((pkt = (ReadWritePacket)this.queue.take()).getPacketType() == 1000) {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("writeChanel closed!");
                    break;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("queue.take PakcetType={}", new Integer(pkt.getPacketType()));
                }
                this.tlqWrapper.jmsWrite(pkt);
                pkt = null;
            }
            catch (Exception ex) {
                logger.error(ex.toString(), ex);
                this.handleWriteException(pkt, ex);
            }
            catch (Throwable error) {
                error.printStackTrace();
                this.fatalError(error);
            }
        }
        try {
            this.closeConnection();
        }
        catch (javax.jms.JMSException ex) {
            logger.error("close Connection failed!", ex);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("WriteChannel exit 4...");
        }
    }

    public void handleWriteException(ReadWritePacket pkt, Exception e) {
        if (pkt.getPacketType() == 14) {
            long ackid = pkt.getConsumerID();
            AckQueue ackQueue = (AckQueue)this.connection.getAndRemoveFromAckQTable(new Long(ackid));
            TlqLocalReadWritePacket ackPkt = new TlqLocalReadWritePacket();
            ackPkt.setPacketType(15);
            Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
            if (e.toString().indexOf("GetMsg QueName is error!") >= 0) {
                if (logger.isTraceEnabled()) {
                    logger.trace("TlqLocalProtocolHandler:write error, send NOT_FOUND to caller.");
                }
                properties.put("JMS_TONG_Status", new Integer(404));
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("TlqLocalProtocolHandler:write error, send BAD_REQUEST to caller.");
                }
                properties.put("JMS_TONG_Status", new Integer(400));
            }
            ackPkt.setProperties(properties);
            ackQueue.enqueueNotify(ackPkt);
        } else {
            logger.info("write error, send UNAVAILABLE to caller.");
            long ackid = pkt.getConsumerID();
            AckQueue ackQueue = (AckQueue)this.connection.getAndRemoveFromAckQTable(new Long(ackid));
            TlqLocalReadWritePacket ackPkt = new TlqLocalReadWritePacket();
            int replyType = PacketType.getReplyType(pkt.getPacketType());
            ackPkt.setPacketType(replyType);
            Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
            properties.put("JMS_TONG_Status", new Integer(503));
            ackPkt.setProperties(properties);
            ackQueue.enqueueNotify(ackPkt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fatalError(Throwable error) {
        try {
            try {
                this.fatalLock.lock();
                if (this.fatalErrorIsProcessed) {
                    Object var5_2 = null;
                    this.isClosed = true;
                    this.fatalLock.unlock();
                    return;
                }
                this.fatalErrorIsProcessed = true;
                this.connection.connectionIsBroken = true;
                String errorString = AdministeredObject.cr.getKString("C4089", error.toString());
                javax.jms.JMSException jMSException = new javax.jms.JMSException(errorString, "C4089");
            }
            catch (Throwable err) {
                logger.warn("", err);
                Object var5_4 = null;
                this.isClosed = true;
                this.fatalLock.unlock();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.isClosed = true;
            this.fatalLock.unlock();
            throw throwable;
        }
        Object var5_3 = null;
        this.isClosed = true;
        this.fatalLock.unlock();
    }

    public void checkout(Transaction transcation) throws javax.jms.JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:session checkout  .");
        }
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(202);
        pkt.setProducerID(transcation.getTransactionID());
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 118, 0);
        int statusCode = TlqLocalProtocolHandler.getReplyStatus(ack);
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:end of session checkout .");
        }
    }

    public ConnectionResult getConnectionResult() throws Exception {
        return (ConnectionResult)this.getCheckinQueue().poll(60L, TimeUnit.SECONDS);
    }

    public String getConnectinId() throws javax.jms.JMSException {
        if (this.connection != null) {
            return String.valueOf(this.connection.connectionID);
        }
        return null;
    }

    public long getConnectionTotalSendCount() {
        return 0L;
    }

    public long getConnectionTotalRecCount() {
        return 0L;
    }

    public void forgetTransaction(long l, JMQXid xid) {
    }

    public void sendServerControl(byte type) throws javax.jms.JMSException {
    }

    public void rollbackSession(SessionImpl sessionImpl) throws javax.jms.JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:rollbackSession");
        }
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(1);
        pkt.setPacketType(22);
        Hashtable<String, Long> ht = new Hashtable<String, Long>(1);
        ht.put("JMS_TONG_TransactionID", new Long(sessionImpl.getTransaction().getTransactionID()));
        ht.put("JMS_TONG_SessionID", new Long(sessionImpl.getBrokerSessionID()));
        pkt.setTransactionID(sessionImpl.getTransaction().getTransactionID());
        pkt.setProperties(ht);
        ReadOnlyPacket ack = this.writePacketWithReply(pkt, 120, 0);
        if (logger.isDebugEnabled()) {
            logger.debug("rollbackSession send ackId:{}", new Long(pkt.getConsumerID()));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler:end of rollbackSession");
        }
    }

    public void rollbackEnd(Long txId) {
        if (logger.isTraceEnabled()) {
            logger.trace("remove sessionStopTable {} ", txId);
        }
        this.sessionStopTable.remove(txId);
    }

    public void rollbackStart(SessionImpl sessionImpl) {
        if (logger.isTraceEnabled()) {
            logger.trace("put sessionStopTable {} ", sessionImpl.getTransaction().getTransactionID());
        }
        this.sessionStopTable.put(new Long(sessionImpl.getTransaction().getTransactionID()), sessionImpl);
    }

    public void removeProducer(MessageProducerImpl producer, long producerid) throws javax.jms.JMSException {
    }
}

