/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.protocol;

import com.tongtech.log.Logger;
import com.tongtech.tmqi.io.PacketProperties;
import com.tongtech.tmqi.io.ReadOnlyPacket;
import com.tongtech.tmqi.io.SysMessageID;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StreamCorruptedException;
import java.util.Hashtable;

public class TlqLocalReadOnlyPacket
implements ReadOnlyPacket {
    public static short defaultVersion = (short)301;
    protected static final int HEADER_SIZE = 72;
    protected byte[] headerBuffer = new byte[72];
    protected byte[] ropBuffer = null;
    protected int ropLength = 0;
    protected int version = defaultVersion;
    protected int magic = 469754818;
    protected int packetType = 0;
    protected int packetSize = 0;
    protected long expiration = 0L;
    protected int propertyOffset = 0;
    protected int propertySize = 0;
    protected int encryption = 0;
    protected long transactionID = -3L;
    protected int priority = 5;
    protected int bitFlags = 0;
    protected long consumerID = 0L;
    protected SysMessageID sysMessageID = new SysMessageID();
    protected String destination = null;
    protected String destinationClass = null;
    protected String messageID = null;
    protected String correlationID = null;
    protected String replyTo = null;
    protected String replyToClass = null;
    protected String messageType = null;
    protected long producerID = 0L;
    private String srcNode = "";
    protected String pubQueue = null;
    protected String subQueue = null;
    protected String fixedMessageID = null;
    protected boolean stringsParsed = false;
    protected Hashtable properties = null;

    @Override
    public Object clone() {
        return null;
    }

    @Override
    public Object cloneShallow() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void dump(Logger os) {
    }

    @Override
    public boolean getConsumerFlow() {
        return false;
    }

    @Override
    public long getConsumerID() {
        return this.consumerID;
    }

    @Override
    public String getCorrelationID() {
        return this.correlationID;
    }

    @Override
    public String getDestination() {
        return this.destination;
    }

    @Override
    public String getDestinationClass() {
        return this.destinationClass;
    }

    @Override
    public int getEncryption() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long getExpiration() {
        return this.expiration;
    }

    @Override
    public boolean getFlag(int flag) {
        return (this.bitFlags & flag) == flag;
    }

    @Override
    public boolean getFlowPaused() {
        return false;
    }

    @Override
    public byte[] getIP() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getIPString() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getIndempotent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getInterestID() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getIsLast() {
        return this.getFlag(32);
    }

    @Override
    public boolean getIsQueue() {
        return this.getFlag(1);
    }

    @Override
    public boolean getIsTransacted() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMagic() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMessageBodySize() {
        return this.packetSize - this.propertyOffset - this.propertySize;
    }

    @Override
    public InputStream getMessageBodyStream() {
        int offset = this.propertyOffset - 72 + this.propertySize;
        int size = this.ropLength - offset;
        if (this.ropBuffer == null || size <= 0) {
            return null;
        }
        return new ByteArrayInputStream(this.ropBuffer, offset, size);
    }

    @Override
    public String getMessageID() {
        return this.messageID;
    }

    @Override
    public String getMessageType() {
        return this.messageType;
    }

    @Override
    public int getPacketSize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getPacketType() {
        return this.packetType;
    }

    @Override
    public boolean getPersistent() {
        return this.getFlag(4);
    }

    @Override
    public int getPort() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public long getProducerID() {
        return this.producerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable getProperties() throws IOException, ClassNotFoundException {
        if (this.properties == null && this.propertySize > 0) {
            TlqLocalReadOnlyPacket tlqLocalReadOnlyPacket = this;
            synchronized (tlqLocalReadOnlyPacket) {
                if (this.properties == null) {
                    this.parseProperties(new ByteArrayInputStream(this.ropBuffer, this.propertyOffset - 72, this.propertySize));
                }
            }
        }
        return this.properties;
    }

    @Override
    public int getPropertyOffset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getPropertySize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getRedelivered() {
        return this.getFlag(2);
    }

    @Override
    public String getReplyTo() {
        return this.replyTo;
    }

    @Override
    public String getReplyToClass() {
        return this.replyToClass;
    }

    @Override
    public boolean getSelectorsProcessed() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getSendAcknowledge() {
        return this.getFlag(16);
    }

    @Override
    public int getSequence() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SysMessageID getSysMessageID() {
        return this.sysMessageID;
    }

    @Override
    public long getTimestamp() {
        return this.sysMessageID.timestamp;
    }

    @Override
    public long getTransactionID() {
        return this.transactionID;
    }

    @Override
    public int getVersion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isEqual(SysMessageID id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void readPacket(InputStream is) throws IOException, EOFException, StreamCorruptedException, IllegalArgumentException {
    }

    @Override
    public void retryReadPacket(InputStream is) throws IOException, EOFException, StreamCorruptedException, IllegalArgumentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String toVerboseString() {
        return "";
    }

    @Override
    public void setSrcNode(String trim) {
        this.srcNode = trim;
    }

    @Override
    public String getSrcNode() {
        return this.srcNode;
    }

    @Override
    public void writePacket(OutputStream os) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writePacket(OutputStream os, int new_version) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writePacket(OutputStream os, long new_consumerID, boolean new_pauseFlow, boolean new_redelivered, boolean new_lastPkt) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writePacket(OutputStream os, int new_version, long new_consumerID, boolean new_pauseFlow, boolean new_redelivered, boolean new_lastPkt) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void parseProperties(InputStream is) throws IOException, ClassNotFoundException {
        if (this.version == 301) {
            this.properties = PacketProperties.parseProperties(is);
        } else {
            ObjectInputStream p = new ObjectInputStream(is);
            this.properties = (Hashtable)p.readObject();
        }
    }

    public void dump(PrintStream os) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getFixedMessageID() {
        return this.fixedMessageID;
    }

    @Override
    public String getPubQueue() {
        return this.pubQueue;
    }

    @Override
    public String getSubQueue() {
        return this.subQueue;
    }
}

