/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.protocol;

import com.tongtech.jms.JMSException;
import com.tongtech.jms.protocol.TlqRemoteReadOnlyPacket;
import com.tongtech.log.Logger;
import com.tongtech.remote.protocol.command.BaseMessage;
import com.tongtech.remote.protocol.command.Command;
import com.tongtech.remote.protocol.command.Message;
import com.tongtech.tmqi.io.JMQByteArrayOutputStream;
import com.tongtech.tmqi.io.PacketProperties;
import com.tongtech.tmqi.io.ReadWritePacket;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;

public class TlqRemoteReadWritePacket
extends TlqRemoteReadOnlyPacket
implements ReadWritePacket {
    static int sequenceNumber = 0;
    protected boolean headerBufferDirty = false;
    protected boolean ropBufferDirty = false;
    protected byte[] messageBody = null;
    protected int messageBodyOffset = 0;
    protected int messageBodyLength = 0;
    private boolean genTimestamp = true;
    private boolean genSequenceNumber = true;

    public TlqRemoteReadWritePacket() {
        this.reset();
    }

    @Override
    public synchronized void readPacket(InputStream is) throws IOException, EOFException {
        super.readPacket(is);
    }

    @Override
    public synchronized void writePacket(OutputStream os) throws IOException {
        if (this.genSequenceNumber) {
            this.updateSequenceNumber();
        }
        if (this.genTimestamp) {
            this.updateTimestamp();
        }
        this.updateBuffers();
        super.writePacket(os);
    }

    @Override
    public synchronized void writePacket(OutputStream os, int new_version) throws IOException {
        this.setVersion(new_version);
        super.writePacket(os);
    }

    @Override
    public synchronized void updateTimestamp() {
        this.setTimestamp(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateSequenceNumber() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.setSequence(++sequenceNumber);
        }
    }

    @Override
    public void writePacket(OutputStream os, long new_consumerID, boolean new_pauseFlow, boolean new_redelivered, boolean new_lastPkt) throws IOException {
        this.writePacket(os, this.version, new_consumerID, new_pauseFlow, new_redelivered, new_lastPkt);
    }

    @Override
    public void writePacket(OutputStream os, int new_version, long new_consumerID, boolean new_pauseFlow, boolean new_redelivered, boolean new_lastPkt) throws IOException {
        this.setVersion(new_version);
        this.setRedelivered(new_redelivered);
        this.setConsumerID(new_consumerID);
        this.setIsLast(new_lastPkt);
        this.setFlowPaused(new_pauseFlow);
        this.writePacket(os);
    }

    @Override
    public void updateBuffers() throws IOException {
        if (this.ropBuffer == null || this.ropBufferDirty) {
            this.updateRopBuffer();
            this.updateHeaderBuffer();
        } else if (this.headerBufferDirty) {
            this.updateHeaderBuffer();
        }
    }

    private void updateHeaderBuffer() throws IOException {
        JMQByteArrayOutputStream bos = new JMQByteArrayOutputStream(this.headerBuffer);
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(469754818);
        dos.writeShort(this.version);
        dos.writeShort(this.packetType);
        dos.writeInt(this.packetSize);
        if (this.version == 103) {
            dos.writeInt((int)this.transactionID);
        }
        dos.writeLong(this.expiration);
        dos.writeInt(this.propertyOffset);
        dos.writeInt(this.propertySize);
        dos.writeByte(this.priority);
        dos.writeByte(this.encryption);
        dos.writeShort(this.bitFlags);
        if (this.version == 103) {
            dos.writeInt((int)this.consumerID);
        } else {
            dos.writeLong(this.consumerID);
        }
        dos.flush();
        bos.flush();
        this.headerBuffer = bos.getBuf();
        this.headerBufferDirty = false;
    }

    private void updateRopBuffer() throws IOException {
        byte[] pad = new byte[4];
        try {
            this.getProperties();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.getMessageBody();
        if (this.ropBuffer == null) {
            int size = 1024;
            if (this.messageBody != null) {
                size += this.messageBodyLength;
            }
            this.ropBuffer = new byte[size];
        }
        JMQByteArrayOutputStream bos = new JMQByteArrayOutputStream(this.ropBuffer);
        DataOutputStream dos = new DataOutputStream(bos);
        if (this.version >= 200 && this.transactionID != 0L) {
            this.writeLong(dos, 8, this.transactionID);
        }
        if (this.producerID != 0L) {
            this.writeLong(dos, 9, this.producerID);
        }
        this.writeString(dos, 1, this.destination);
        this.writeString(dos, 6, this.destinationClass);
        this.writeString(dos, 2, this.messageID);
        this.writeString(dos, 3, this.correlationID);
        this.writeString(dos, 4, this.replyTo);
        this.writeString(dos, 7, this.replyToClass);
        this.writeString(dos, 5, this.messageType);
        dos.writeShort(0);
        dos.flush();
        int padding = 4 - bos.getCount() % 4;
        bos.write(pad, 0, padding);
        bos.flush();
        this.propertyOffset = bos.getCount() + 72;
        if (this.properties != null) {
            if (this.version == 301) {
                PacketProperties.write(this.properties, bos);
            } else {
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(this.properties);
                oos.flush();
                oos.close();
            }
        }
        this.propertySize = bos.getCount() - (this.propertyOffset - 72);
        if (this.messageBody != null) {
            bos.write(this.messageBody, this.messageBodyOffset, this.messageBodyLength);
        }
        this.ropLength = bos.getCount();
        this.packetSize = this.ropLength + 72;
        bos.flush();
        this.ropBuffer = bos.getBuf();
        this.ropBufferDirty = false;
        bos.close();
    }

    private void writeString(DataOutputStream dos, int type, String value) throws IOException {
        if (value != null) {
            dos.writeShort(type);
            dos.writeUTF(value);
        }
    }

    private void writeLong(DataOutputStream dos, int type, long value) throws IOException {
        dos.writeShort(type);
        dos.writeShort(8);
        dos.writeLong(value);
    }

    @Override
    public void generateSequenceNumber(boolean generate) {
        this.genSequenceNumber = generate;
    }

    @Override
    public void generateTimestamp(boolean generate) {
        this.genTimestamp = generate;
    }

    @Override
    public synchronized void setPacketType(int pType) {
        this.packetType = pType;
        this.headerBufferDirty = true;
    }

    @Override
    public synchronized void setTimestamp(long t) {
        this.operateCommandAsMessage().setTimestamp(t);
        this.operateCommandAsMessage().setProperty("JMSTimestamp", new Long(t));
        this.headerBufferDirty = true;
    }

    @Override
    public synchronized void setExpiration(long e) {
        this.operateCommandAsMessage().setExpiration(e);
        this.operateCommandAsMessage().setProperty("JMSExpiration", new Long(e));
        this.headerBufferDirty = true;
    }

    @Override
    public synchronized void setPort(int p) {
        this.headerBufferDirty = true;
    }

    @Override
    public synchronized void setIP(byte[] ip) {
        this.headerBufferDirty = true;
    }

    @Override
    public synchronized void setIP(byte[] ip, byte[] mac) {
        this.headerBufferDirty = true;
    }

    @Override
    public synchronized void setSequence(int n) {
        this.headerBufferDirty = true;
    }

    @Override
    public synchronized void setVersion(int n) {
        if (this.version != n) {
            this.version = n;
            this.headerBufferDirty = true;
        }
    }

    @Override
    public synchronized void setTransactionID(long n) {
        this.transactionID = n;
        this.headerBufferDirty = true;
    }

    @Override
    public synchronized void setEncryption(int e) {
        this.encryption = e;
        this.headerBufferDirty = true;
    }

    @Override
    public synchronized void setPriority(int p) {
        this.priority = p;
        this.operateCommandAsMessage().setPriority((byte)p);
        this.headerBufferDirty = true;
    }

    @Override
    public void setConsumerID(long n) {
        this.consumerID = n;
        this.headerBufferDirty = true;
    }

    @Override
    public void setInterestID(int n) {
        this.setConsumerID(n);
    }

    @Override
    public void setPersistent(boolean b) {
        this.operateCommandAsMessage().setPersistent(b);
        this.setFlag(4, b);
    }

    @Override
    public void setRedelivered(boolean b) {
        this.operateCommandAsMessage().setRedelivered(b);
    }

    @Override
    public void setIsQueue(boolean b) {
        this.setFlag(1, b);
    }

    @Override
    public void setSelectorsProcessed(boolean b) {
        this.setFlag(8, b);
    }

    @Override
    public void setSendAcknowledge(boolean b) {
        this.setFlag(16, b);
    }

    @Override
    public void setIsLast(boolean b) {
        this.setFlag(32, b);
    }

    @Override
    public void setFlowPaused(boolean b) {
        this.setFlag(64, b);
    }

    @Override
    public void setIsTransacted(boolean b) {
        this.setFlag(128, b);
    }

    @Override
    public void setConsumerFlow(boolean b) {
        this.setFlag(256, b);
    }

    @Override
    public void setIndempotent(boolean b) {
        this.setFlag(2048, b);
    }

    @Override
    public synchronized void setFlag(int flag, boolean on) {
        this.bitFlags = on ? (this.bitFlags |= flag) : (this.bitFlags &= ~flag);
        this.headerBufferDirty = true;
    }

    @Override
    public synchronized void setProducerID(long l) {
        this.producerID = l;
        this.ropBufferDirty = true;
    }

    @Override
    public synchronized void setDestination(String d) {
        this.operateCommandAsMessage().setProperty("JMSDestination", d);
        this.ropBufferDirty = true;
    }

    @Override
    public synchronized void setDestinationClass(String d) {
        this.ropBufferDirty = true;
    }

    @Override
    public synchronized void setMessageID(String id) {
        this.messageID = id;
        this.ropBufferDirty = true;
    }

    @Override
    public synchronized void setCorrelationID(String id) {
        if (id != null && !id.equals("")) {
            this.operateCommandAsMessage().setCorrelationId(id);
            this.operateCommandAsMessage().setProperty("JMSCorrelationID", id);
            this.ropBufferDirty = true;
        }
    }

    @Override
    public synchronized void setReplyTo(String r) {
        if (r != null && !r.equals("")) {
            this.operateCommandAsMessage().setProperty("JMSReplyTo", r);
            this.ropBufferDirty = true;
        }
    }

    @Override
    public synchronized void setReplyToClass(String r) {
        if (r != null && !r.equals("")) {
            this.operateCommandAsMessage().setProperty("JMS_TONG_ReplyToClass", r);
            this.ropBufferDirty = true;
        }
    }

    @Override
    public synchronized void setMessageType(String t) {
        if (t != null && !t.equals("")) {
            this.operateCommandAsMessage().setType(t);
            this.operateCommandAsMessage().setProperty("JMSType", t);
            this.ropBufferDirty = true;
        }
    }

    @Override
    public synchronized void setProperties(Hashtable props) {
        this.operateCommandAsMessage().getProperties().putAll(props);
        this.ropBufferDirty = true;
    }

    @Override
    public synchronized void setMessageBody(byte[] body) {
        if (body != null && body.length != 0) {
            this.operateCommandAsMessage().setContent(body);
            this.operateCommandAsMessage().setMsgSize(body.length);
        } else {
            this.operateCommandAsMessage().setContent(null);
            this.operateCommandAsMessage().setMsgSize(0);
        }
        this.messageBodyOffset = 0;
        this.messageBodyLength = body != null ? body.length : 0;
        this.ropBufferDirty = true;
    }

    @Override
    public synchronized void setMessageBody(byte[] body, int off, int len) {
        byte[] buf = new byte[len];
        System.arraycopy(body, off, buf, 0, len);
        this.operateCommandAsMessage().setContent(buf);
        this.operateCommandAsMessage().setMsgSize(len);
        this.messageBodyOffset = off;
        this.messageBodyLength = len;
        this.ropBufferDirty = true;
    }

    @Override
    public synchronized int getMessageBodyLength() {
        return this.messageBodyLength;
    }

    @Override
    public synchronized int getMessageBodySize() {
        return this.getMessageBodyLength();
    }

    @Override
    public synchronized int getMessageBodyOffset() {
        return this.messageBodyOffset;
    }

    @Override
    public synchronized byte[] getMessageBody() {
        return this.operateCommandAsMessage().getContent();
    }

    @Override
    public Object cloneShallow() {
        return super.cloneShallow();
    }

    @Override
    public Object clone() {
        TlqRemoteReadWritePacket newPkt = (TlqRemoteReadWritePacket)super.clone();
        if (this.messageBody != null) {
            byte[] b = new byte[this.messageBodyLength];
            System.arraycopy(this.messageBody, this.messageBodyOffset, b, 0, this.messageBodyLength);
            newPkt.messageBody = b;
            newPkt.messageBodyOffset = 0;
            newPkt.messageBodyLength = b.length;
        }
        return newPkt;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.headerBufferDirty = false;
        this.ropBufferDirty = false;
        this.messageBody = null;
        this.messageBodyOffset = 0;
        this.messageBodyLength = 0;
    }

    @Override
    public void dump(Logger logger) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream os = new PrintStream(bos);
            super.dump(logger);
            if (this.messageBody == null) {
                os.println("    messageBodyBuffer: null");
            } else {
                os.println("    messageBodyBuffer: " + this.messageBody + " " + this.messageBodyLength + " bytes");
            }
            os.println("    headerBufferDirty: " + this.headerBufferDirty + "    ropBufferDirty: " + this.ropBufferDirty);
            os.println("         genTimestamp: " + this.genTimestamp + "  genSequenceNumber: " + this.genSequenceNumber);
            os.flush();
            os.close();
            bos.close();
            logger.trace(bos.toString());
        }
        catch (IOException ex) {
            logger.warn("", ex);
        }
    }

    @Override
    public void setTimeToLive(long timetolive) {
        this.expiration = timetolive;
    }

    @Override
    public long getTimeToLive() {
        return this.expiration;
    }

    @Override
    public String getSrcNode() {
        return null;
    }

    @Override
    public void setFixedMessageID(String id) {
    }

    @Override
    public void setSrcNode(String trim) {
    }

    public void setCommand(Command command) {
        this.openwireCommand = command;
    }

    public void setPacketProperties(Hashtable props) {
        this.properties = props;
    }

    public void appendPartialMessage(BaseMessage message) throws JMSException {
        try {
            if (this.msgContentBuf == null) {
                this.msgContentBuf = new JMQByteArrayOutputStream(new byte[((Message)this.openwireCommand).getMsgSize()]);
                byte[] content = ((Message)this.openwireCommand).getContent();
                if (content != null && content.length != 0) {
                    this.msgContentBuf.write(content);
                }
                ((Message)this.openwireCommand).setContent(null);
            }
            if (message.getContent() != null && message.getContent().length != 0) {
                this.msgContentBuf.write(message.getContent());
            }
            message.setContent(null);
            if (this.msgPropBuf == null) {
                this.msgPropBuf = new JMQByteArrayOutputStream(new byte[((Message)this.openwireCommand).getPropSize()]);
                byte[] marshalledProperties = ((Message)this.openwireCommand).getMarshalledProperties();
                if (marshalledProperties != null && marshalledProperties.length != 0) {
                    this.msgPropBuf.write(marshalledProperties);
                }
                ((Message)this.openwireCommand).setMarshalledProperties(null);
            }
            if (message.getMarshalledProperties() != null && message.getMarshalledProperties().length != 0) {
                this.msgPropBuf.write(message.getMarshalledProperties());
            }
            message.setMarshalledProperties(null);
        }
        catch (IOException e) {
            throw new JMSException(e.getMessage(), "", e);
        }
    }

    public void setPartialBufToMessage() {
        ((Message)this.openwireCommand).setContent(this.msgContentBuf.getBuf());
        ((Message)this.openwireCommand).setMarshalledProperties(this.msgPropBuf.getBuf());
    }

    public void setPartialMessageLastRecTimestamp(long timestamp) {
        this.partialMessageLastRecTimestamp = timestamp;
    }

    @Override
    public void setPubQueue(String pubQueue) {
    }

    @Override
    public void setSubQueue(String subQueue) {
    }
}

