/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.protocol;

import com.tongtech.backport.java.util.concurrent.BlockingQueue;
import com.tongtech.backport.java.util.concurrent.locks.ReentrantLock;
import com.tongtech.jms.jni.TlqException;
import com.tongtech.jms.protocol.TlqLocalProtocolHandler;
import com.tongtech.jms.protocol.TlqLocalReadWritePacket;
import com.tongtech.jms.tlq.TlqWrapper;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.io.PacketType;
import com.tongtech.tmqi.io.ReadWritePacket;
import com.tongtech.tmqi.jmsclient.AckQueue;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import java.util.Hashtable;
import javax.jms.JMSException;

public class TlqWriteThread
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(TlqWriteThread.class);
    private BlockingQueue queue = null;
    private TlqWrapper tlqWrapper = null;
    BlockingQueue ackQueue = null;
    boolean isClosed = false;
    ConnectionImpl connection = null;
    private boolean fatalErrorIsProcessed = false;
    TlqLocalProtocolHandler handler = null;
    ReentrantLock fatalLock = new ReentrantLock();

    public TlqWriteThread(BlockingQueue q, TlqWrapper t, BlockingQueue ackQueue, ConnectionImpl connection, TlqLocalProtocolHandler handler) {
        this.queue = q;
        this.tlqWrapper = t;
        this.ackQueue = ackQueue;
        this.connection = connection;
        this.handler = handler;
    }

    @Override
    public void run() {
        ReadWritePacket pkt = null;
        TlqException tlqException = new TlqException("connection success");
        try {
            pkt = (ReadWritePacket)this.queue.take();
            if (pkt.getPacketType() != 300) {
                return;
            }
            this.tlqWrapper.openConnection();
            tlqException.setTlqErrno(0);
            this.ackQueue.put((Object)tlqException);
        }
        catch (TlqException e) {
            block23: {
                if (logger.isTraceEnabled()) {
                    logger.trace("connection error!", (Throwable)((Object)e));
                }
                try {
                    this.ackQueue.put((Object)e);
                }
                catch (InterruptedException ex) {
                    if (!logger.isTraceEnabled()) break block23;
                    logger.trace("put ackQueue failed!");
                }
            }
            return;
        }
        catch (Exception ex) {
            block24: {
                if (logger.isTraceEnabled()) {
                    logger.trace("writeChanel closed!");
                }
                try {
                    tlqException.setTlqErrno(-1);
                    this.ackQueue.put((Object)tlqException);
                }
                catch (InterruptedException ex1) {
                    if (!logger.isTraceEnabled()) break block24;
                    logger.trace("put ackQueue failed!");
                }
            }
            return;
        }
        try {
            this.handler.checkin();
        }
        catch (JMSException ex) {
            if (logger.isTraceEnabled()) {
                logger.trace("check in failed!");
            }
            return;
        }
        while (!this.isClosed) {
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("+++writeChannel Waiting for read ReadWritePacket...");
                }
                long start = System.currentTimeMillis();
                pkt = (ReadWritePacket)this.queue.take();
                long end = System.currentTimeMillis();
                if (logger.isTraceEnabled()) {
                    logger.trace("writeChannel take time is:" + (end - start) + "end time is:" + end);
                }
                if (pkt.getPacketType() == 1000) {
                    if (!logger.isTraceEnabled()) break;
                    logger.trace("writeChanel closed!");
                    break;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("++++++++++writeChannel  packetType :" + pkt.getPacketType() + "isClosed:" + this.isClosed);
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("writePacketNoAck+++++++++++++++++packetType:" + pkt.getPacketType());
                }
                this.tlqWrapper.jmsWrite(pkt);
                pkt = null;
            }
            catch (Exception ex) {
                logger.warn("write message error!!", ex);
                this.handleWriteException(pkt, ex);
            }
            catch (Throwable error) {
                this.fatalError(error);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("WriteChannel exit 4...");
        }
    }

    public void handleWriteException(ReadWritePacket pkt, Exception e) {
        if (pkt.getPacketType() == 14) {
            if (logger.isTraceEnabled()) {
                logger.trace("write error, send BAD_REQUEST to caller.");
            }
            long ackid = pkt.getConsumerID();
            AckQueue ackQueue = (AckQueue)this.connection.getAndRemoveFromAckQTable(new Long(ackid));
            TlqLocalReadWritePacket ackPkt = new TlqLocalReadWritePacket();
            ackPkt.setPacketType(15);
            Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
            properties.put("JMS_TONG_Status", new Integer(400));
            ackPkt.setProperties(properties);
            ackQueue.enqueueNotify(ackPkt);
        } else {
            logger.info("write error, send UNAVAILABLE to caller.");
            long ackid = pkt.getConsumerID();
            AckQueue ackQueue = (AckQueue)this.connection.getAndRemoveFromAckQTable(new Long(ackid));
            TlqLocalReadWritePacket ackPkt = new TlqLocalReadWritePacket();
            int replyType = PacketType.getReplyType(pkt.getPacketType());
            ackPkt.setPacketType(replyType);
            Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
            properties.put("JMS_TONG_Status", new Integer(503));
            ackPkt.setProperties(properties);
            ackQueue.enqueueNotify(ackPkt);
        }
    }

    protected void fatalError(Throwable error) {
        try {
            this.fatalLock.lock();
            if (this.fatalErrorIsProcessed) {
                return;
            }
            this.fatalErrorIsProcessed = true;
            this.connection.connectionIsBroken = true;
        }
        catch (Throwable err) {
            logger.warn("", err);
        }
        finally {
            this.isClosed = true;
            this.fatalLock.unlock();
        }
    }
}

