/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.protocol.http;

import com.tongtech.jms.protocol.SocketConnectionHandler;
import com.tongtech.jms.transport.httptunnel.HttpTunnelSocket;
import com.tongtech.tmqi.io.MQAddress;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.JMSException;

public class HTTPConnectionHandler
extends SocketConnectionHandler {
    private HttpTunnelSocket socket = null;
    private String URLString = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnectionHandler(Object conn) throws JMSException {
        ConnectionImpl connection = (ConnectionImpl)conn;
        this.URLString = connection.getProperty("tmqiConnectionURL");
        if (this.URLString == null) {
            throw new JMSException("tmqiConnectionURL property not found.");
        }
        try {
            this.socket = new HttpTunnelSocket(this.URLString);
        }
        catch (Exception e) {
            connection.getExceptionHandler();
            ExceptionHandler.handleConnectException(e, this.URLString);
        }
        finally {
            connection.setLastContactedBrokerAddress(this.URLString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnectionHandler(MQAddress addr, ConnectionImpl conn) throws JMSException {
        ConnectionImpl connection = conn;
        this.URLString = addr.getURL();
        if (this.URLString == null) {
            throw new JMSException("URL not found.");
        }
        try {
            this.socket = new HttpTunnelSocket(this.URLString);
        }
        catch (Exception e) {
            connection.getExceptionHandler();
            ExceptionHandler.handleConnectException(e, this.URLString);
        }
        finally {
            conn.setLastContactedBrokerAddress(this.URLString);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public int getLocalPort() throws IOException {
        return this.socket.getConnId();
    }

    @Override
    protected void closeSocket() throws IOException {
        this.socket.close();
    }

    @Override
    public String getBrokerHostName() {
        return this.URLString;
    }

    @Override
    public String getBrokerAddress() {
        return this.URLString;
    }
}

