/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.protocol.io;

import com.tongtech.jms.protocol.TlqLocalProtocolHandler;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.io.MQAddress;
import com.tongtech.tmqi.jmsclient.ConnectionHandler;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.JMSException;

public class TlqLocalConnectionHandler
implements ConnectionHandler {
    static Logger logger = LoggerFactory.getLogger(ConnectionHandler.class);
    private MQAddress addr = null;
    private static int connectionCount = 0;
    private int counter = 0;
    TlqLocalProtocolHandler protocolHandler = null;

    TlqLocalConnectionHandler(Object conn, MQAddress tlqAddr) throws JMSException {
        this.addr = tlqAddr;
        ConnectionImpl connection = (ConnectionImpl)conn;
        connection.setLastContactedBrokerAddress(this.getBrokerAddress());
        connection.setProtocolType(1);
        try {
            this.protocolHandler = (TlqLocalProtocolHandler)connection.getProtocolHandler();
            this.protocolHandler.openConnection();
            this.counter = ++connectionCount;
        }
        catch (Exception e) {
            connection.getExceptionHandler();
            ExceptionHandler.handleConnectException(e, this.addr.toString());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("openConnection success!");
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getLocalPort() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close() throws JMSException {
        this.protocolHandler.closeConnection();
    }

    @Override
    public String getBrokerHostName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getBrokerAddress() {
        return this.addr.getHostName();
    }
}

